/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentStyle;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.ChatSerializer;
import net.md_5.bungee.protocol.Either;
import net.md_5.bungee.protocol.NumberFormat;
import net.md_5.bungee.protocol.OverflowPacketException;
import net.md_5.bungee.protocol.PlayerPublicKey;
import net.md_5.bungee.protocol.Property;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.TagUtil;
import se.llbit.nbt.ErrorTag;
import se.llbit.nbt.NamedTag;
import se.llbit.nbt.SpecificTag;
import se.llbit.nbt.Tag;

public abstract class DefinedPacket {
    public <T> T readNullable(Function<ByteBuf, T> reader, ByteBuf buf) {
        return buf.readBoolean() ? (T)reader.apply(buf) : null;
    }

    public <T> void writeNullable(T t0, BiConsumer<T, ByteBuf> writer, ByteBuf buf) {
        if (t0 != null) {
            buf.writeBoolean(true);
            writer.accept(t0, buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    public static void writeString(String s2, ByteBuf buf) {
        DefinedPacket.writeString(s2, buf, Short.MAX_VALUE);
    }

    public static void writeString(String s2, ByteBuf buf, int maxLength) {
        if (s2.length() > maxLength) {
            throw new OverflowPacketException("Cannot send string longer than " + maxLength + " (got " + s2.length() + " characters)");
        }
        byte[] b = s2.getBytes(StandardCharsets.UTF_8);
        if (b.length > maxLength * 3) {
            throw new OverflowPacketException("Cannot send string longer than " + maxLength * 3 + " (got " + b.length + " bytes)");
        }
        DefinedPacket.writeVarInt(b.length, buf);
        buf.writeBytes(b);
    }

    public static <T> T readStringMapKey(ByteBuf buf, Map<String, T> map) {
        String string = DefinedPacket.readString(buf);
        T result = map.get(string);
        Preconditions.checkArgument(result != null, "Unknown string key %s", (Object)string);
        return result;
    }

    public static String readString(ByteBuf buf) {
        return DefinedPacket.readString(buf, Short.MAX_VALUE);
    }

    public static String readString(ByteBuf buf, int maxLen) {
        int len = DefinedPacket.readVarInt(buf);
        if (len > maxLen * 3) {
            throw new OverflowPacketException("Cannot receive string longer than " + maxLen * 3 + " (got " + len + " bytes)");
        }
        String s2 = buf.toString(buf.readerIndex(), len, StandardCharsets.UTF_8);
        buf.readerIndex(buf.readerIndex() + len);
        if (s2.length() > maxLen) {
            throw new OverflowPacketException("Cannot receive string longer than " + maxLen + " (got " + s2.length() + " characters)");
        }
        return s2;
    }

    public static Either<String, BaseComponent> readEitherBaseComponent(ByteBuf buf, int protocolVersion, boolean string) {
        return string ? Either.left(DefinedPacket.readString(buf)) : Either.right(DefinedPacket.readBaseComponent(buf, protocolVersion));
    }

    public static BaseComponent readBaseComponent(ByteBuf buf, int protocolVersion) {
        return DefinedPacket.readBaseComponent(buf, Short.MAX_VALUE, protocolVersion);
    }

    public static BaseComponent readBaseComponent(ByteBuf buf, int maxStringLength, int protocolVersion) {
        if (protocolVersion >= 765) {
            SpecificTag nbt = (SpecificTag)DefinedPacket.readTag(buf, protocolVersion);
            JsonElement json = TagUtil.toJson(nbt);
            return ChatSerializer.forVersion(protocolVersion).deserialize(json);
        }
        String string = DefinedPacket.readString(buf, maxStringLength);
        return ChatSerializer.forVersion(protocolVersion).deserialize(string);
    }

    public static ComponentStyle readComponentStyle(ByteBuf buf, int protocolVersion) {
        SpecificTag nbt = (SpecificTag)DefinedPacket.readTag(buf, protocolVersion);
        JsonElement json = TagUtil.toJson(nbt);
        return ChatSerializer.forVersion(protocolVersion).deserializeStyle(json);
    }

    public static void writeEitherBaseComponent(Either<String, BaseComponent> message, ByteBuf buf, int protocolVersion) {
        if (message.isLeft()) {
            DefinedPacket.writeString(message.getLeft(), buf);
        } else {
            DefinedPacket.writeBaseComponent(message.getRight(), buf, protocolVersion);
        }
    }

    public static void writeBaseComponent(BaseComponent message, ByteBuf buf, int protocolVersion) {
        if (protocolVersion >= 765) {
            JsonElement json = ChatSerializer.forVersion(protocolVersion).toJson(message);
            SpecificTag nbt = TagUtil.fromJson(json);
            DefinedPacket.writeTag(nbt, buf, protocolVersion);
        } else {
            String string = ChatSerializer.forVersion(protocolVersion).toString(message);
            DefinedPacket.writeString(string, buf);
        }
    }

    public static void writeComponentStyle(ComponentStyle style, ByteBuf buf, int protocolVersion) {
        JsonElement json = ChatSerializer.forVersion(protocolVersion).toJson(style);
        SpecificTag nbt = TagUtil.fromJson(json);
        DefinedPacket.writeTag(nbt, buf, protocolVersion);
    }

    public static void writeArray(byte[] b, ByteBuf buf) {
        if (b.length > Short.MAX_VALUE) {
            throw new OverflowPacketException("Cannot send byte array longer than Short.MAX_VALUE (got " + b.length + " bytes)");
        }
        DefinedPacket.writeVarInt(b.length, buf);
        buf.writeBytes(b);
    }

    public static byte[] toArray(ByteBuf buf) {
        byte[] ret = new byte[buf.readableBytes()];
        buf.readBytes(ret);
        return ret;
    }

    public static byte[] readArray(ByteBuf buf) {
        return DefinedPacket.readArray(buf, buf.readableBytes());
    }

    public static byte[] readArray(ByteBuf buf, int limit) {
        int len = DefinedPacket.readVarInt(buf);
        if (len > limit) {
            throw new OverflowPacketException("Cannot receive byte array longer than " + limit + " (got " + len + " bytes)");
        }
        byte[] ret = new byte[len];
        buf.readBytes(ret);
        return ret;
    }

    public static int[] readVarIntArray(ByteBuf buf) {
        int len = DefinedPacket.readVarInt(buf);
        int[] ret = new int[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = DefinedPacket.readVarInt(buf);
        }
        return ret;
    }

    public static void writeStringArray(List<String> s2, ByteBuf buf) {
        DefinedPacket.writeVarInt(s2.size(), buf);
        for (String str : s2) {
            DefinedPacket.writeString(str, buf);
        }
    }

    public static List<String> readStringArray(ByteBuf buf) {
        int len = DefinedPacket.readVarInt(buf);
        ArrayList<String> ret = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            ret.add(DefinedPacket.readString(buf));
        }
        return ret;
    }

    public static int readVarInt(ByteBuf input) {
        return DefinedPacket.readVarInt(input, 5);
    }

    public static int readVarInt(ByteBuf input, int maxBytes) {
        byte in;
        int out = 0;
        int bytes = 0;
        do {
            in = input.readByte();
            out |= (in & 0x7F) << bytes++ * 7;
            if (bytes <= maxBytes) continue;
            throw new OverflowPacketException("VarInt too big (max " + maxBytes + ")");
        } while ((in & 0x80) == 128);
        return out;
    }

    public static void writeVarInt(int value, ByteBuf output) {
        do {
            int part = value & 0x7F;
            if ((value >>>= 7) != 0) {
                part |= 0x80;
            }
            output.writeByte(part);
        } while (value != 0);
    }

    public static void setVarInt(int value, ByteBuf output, int pos, int len) {
        switch (len) {
            case 1: {
                output.setByte(pos, value);
                break;
            }
            case 2: {
                output.setShort(pos, (value & 0x7F | 0x80) << 8 | value >>> 7 & 0x7F);
                break;
            }
            case 3: {
                output.setMedium(pos, (value & 0x7F | 0x80) << 16 | (value >>> 7 & 0x7F | 0x80) << 8 | value >>> 14 & 0x7F);
                break;
            }
            case 4: {
                output.setInt(pos, (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | value >>> 21 & 0x7F);
                break;
            }
            case 5: {
                output.setInt(pos, (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | (value >>> 21 & 0x7F | 0x80));
                output.setByte(pos + 4, value >>> 28);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid varint len: " + len);
            }
        }
    }

    public static int readVarShort(ByteBuf buf) {
        int low = buf.readUnsignedShort();
        int high = 0;
        if ((low & 0x8000) != 0) {
            low &= Short.MAX_VALUE;
            high = buf.readUnsignedByte();
        }
        return (high & 0xFF) << 15 | low;
    }

    public static void writeVarShort(ByteBuf buf, int toWrite) {
        int low = toWrite & Short.MAX_VALUE;
        int high = (toWrite & 0x7F8000) >> 15;
        if (high != 0) {
            low |= 0x8000;
        }
        buf.writeShort(low);
        if (high != 0) {
            buf.writeByte(high);
        }
    }

    public static void writeUUID(UUID value, ByteBuf output) {
        output.writeLong(value.getMostSignificantBits());
        output.writeLong(value.getLeastSignificantBits());
    }

    public static UUID readUUID(ByteBuf input) {
        return new UUID(input.readLong(), input.readLong());
    }

    public static void writeProperties(Property[] properties, ByteBuf buf) {
        if (properties == null) {
            DefinedPacket.writeVarInt(0, buf);
            return;
        }
        DefinedPacket.writeVarInt(properties.length, buf);
        for (Property prop : properties) {
            DefinedPacket.writeString(prop.getName(), buf);
            DefinedPacket.writeString(prop.getValue(), buf);
            if (prop.getSignature() != null) {
                buf.writeBoolean(true);
                DefinedPacket.writeString(prop.getSignature(), buf);
                continue;
            }
            buf.writeBoolean(false);
        }
    }

    public static Property[] readProperties(ByteBuf buf) {
        Property[] properties = new Property[DefinedPacket.readVarInt(buf)];
        for (int j = 0; j < properties.length; ++j) {
            String name = DefinedPacket.readString(buf);
            String value = DefinedPacket.readString(buf);
            properties[j] = buf.readBoolean() ? new Property(name, value, DefinedPacket.readString(buf)) : new Property(name, value);
        }
        return properties;
    }

    public static void writePublicKey(PlayerPublicKey publicKey, ByteBuf buf) {
        if (publicKey != null) {
            buf.writeBoolean(true);
            buf.writeLong(publicKey.getExpiry());
            DefinedPacket.writeArray(publicKey.getKey(), buf);
            DefinedPacket.writeArray(publicKey.getSignature(), buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    public static PlayerPublicKey readPublicKey(ByteBuf buf) {
        if (buf.readBoolean()) {
            return new PlayerPublicKey(buf.readLong(), DefinedPacket.readArray(buf, 512), DefinedPacket.readArray(buf, 4096));
        }
        return null;
    }

    public static void writeNumberFormat(NumberFormat format, ByteBuf buf, int protocolVersion) {
        DefinedPacket.writeVarInt(format.getType().ordinal(), buf);
        switch (format.getType()) {
            case BLANK: {
                break;
            }
            case STYLED: {
                DefinedPacket.writeComponentStyle((ComponentStyle)format.getValue(), buf, protocolVersion);
                break;
            }
            case FIXED: {
                DefinedPacket.writeBaseComponent((BaseComponent)format.getValue(), buf, protocolVersion);
            }
        }
    }

    public static NumberFormat readNumberFormat(ByteBuf buf, int protocolVersion) {
        int format = DefinedPacket.readVarInt(buf);
        switch (format) {
            case 0: {
                return new NumberFormat(NumberFormat.Type.BLANK, null);
            }
            case 1: {
                return new NumberFormat(NumberFormat.Type.STYLED, DefinedPacket.readComponentStyle(buf, protocolVersion));
            }
            case 2: {
                return new NumberFormat(NumberFormat.Type.FIXED, DefinedPacket.readBaseComponent(buf, protocolVersion));
            }
        }
        throw new IllegalArgumentException("Unknown number format " + format);
    }

    public static Tag readTag(ByteBuf input, int protocolVersion) {
        Tag tag;
        DataInputStream in = new DataInputStream(new ByteBufInputStream(input));
        if (protocolVersion >= 764) {
            try {
                byte type = in.readByte();
                if (type == 0) {
                    return Tag.END;
                }
                tag = SpecificTag.read(type, in);
            }
            catch (IOException ex) {
                tag = new ErrorTag("IOException while reading tag type:\n" + ex.getMessage());
            }
        } else {
            tag = NamedTag.read(in);
        }
        Preconditions.checkArgument(!tag.isError(), "Error reading tag: %s", (Object)tag.error());
        return tag;
    }

    public static void writeTag(Tag tag, ByteBuf output, int protocolVersion) {
        DataOutputStream out = new DataOutputStream(new ByteBufOutputStream(output));
        try {
            if (tag instanceof SpecificTag) {
                SpecificTag specificTag = (SpecificTag)tag;
                specificTag.writeType(out);
                specificTag.write(out);
            } else {
                tag.write(out);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Exception writing tag", ex);
        }
    }

    public static <E extends Enum<E>> void writeEnumSet(EnumSet<E> enumset, Class<E> oclass, ByteBuf buf) {
        Enum[] enums = (Enum[])oclass.getEnumConstants();
        BitSet bits = new BitSet(enums.length);
        for (int i = 0; i < enums.length; ++i) {
            bits.set(i, enumset.contains(enums[i]));
        }
        DefinedPacket.writeFixedBitSet(bits, enums.length, buf);
    }

    public static <E extends Enum<E>> EnumSet<E> readEnumSet(Class<E> oclass, ByteBuf buf) {
        Enum[] enums = (Enum[])oclass.getEnumConstants();
        BitSet bits = DefinedPacket.readFixedBitSet(enums.length, buf);
        EnumSet<Enum> set = EnumSet.noneOf(oclass);
        for (int i = 0; i < enums.length; ++i) {
            if (!bits.get(i)) continue;
            set.add(enums[i]);
        }
        return set;
    }

    public static BitSet readFixedBitSet(int i, ByteBuf buf) {
        byte[] bits = new byte[i + 7 >> 3];
        buf.readBytes(bits);
        return BitSet.valueOf(bits);
    }

    public static void writeFixedBitSet(BitSet bits, int size, ByteBuf buf) {
        if (bits.length() > size) {
            throw new OverflowPacketException("BitSet too large (expected " + size + " got " + bits.size() + ")");
        }
        buf.writeBytes(Arrays.copyOf(bits.toByteArray(), size + 7 >> 3));
    }

    public void read(ByteBuf buf) {
        throw new UnsupportedOperationException("Packet must implement read method");
    }

    public void read(ByteBuf buf, Protocol protocol, ProtocolConstants.Direction direction, int protocolVersion) {
        this.read(buf, direction, protocolVersion);
    }

    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.read(buf);
    }

    public void write(ByteBuf buf) {
        throw new UnsupportedOperationException("Packet must implement write method");
    }

    public void write(ByteBuf buf, Protocol protocol, ProtocolConstants.Direction direction, int protocolVersion) {
        this.write(buf, direction, protocolVersion);
    }

    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.write(buf);
    }

    public Protocol nextProtocol() {
        return null;
    }

    public abstract void handle(AbstractPacketHandler var1) throws Exception;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    @Generated
    public DefinedPacket() {
    }
}

