/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class DisconnectReportDetails
extends DefinedPacket {
    private Map<String, String> details;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        int len = DisconnectReportDetails.readVarInt(buf);
        Preconditions.checkArgument(len <= 32, "Too many details");
        this.details = new HashMap<String, String>();
        for (int i = 0; i < len; ++i) {
            this.details.put(DisconnectReportDetails.readString(buf, 128), DisconnectReportDetails.readString(buf, 4096));
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        Preconditions.checkArgument(this.details.size() <= 32, "Too many details");
        DisconnectReportDetails.writeVarInt(this.details.size(), buf);
        for (Map.Entry<String, String> detail : this.details.entrySet()) {
            DisconnectReportDetails.writeString(detail.getKey(), buf, 128);
            DisconnectReportDetails.writeString(detail.getValue(), buf, 4096);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @Generated
    public Map<String, String> getDetails() {
        return this.details;
    }

    @Generated
    public void setDetails(Map<String, String> details) {
        this.details = details;
    }

    @Override
    @Generated
    public String toString() {
        return "DisconnectReportDetails(details=" + this.getDetails() + ")";
    }

    @Generated
    public DisconnectReportDetails() {
    }

    @Generated
    public DisconnectReportDetails(Map<String, String> details) {
        this.details = details;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisconnectReportDetails)) {
            return false;
        }
        DisconnectReportDetails other = (DisconnectReportDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$details = this.getDetails();
        Map<String, String> other$details = other.getDetails();
        return !(this$details == null ? other$details != null : !((Object)this$details).equals(other$details));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DisconnectReportDetails;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $details = this.getDetails();
        result = result * 59 + ($details == null ? 43 : ((Object)$details).hashCode());
        return result;
    }
}

