/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import io.netty.buffer.ByteBuf;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class Commands
extends DefinedPacket {
    private static final int FLAG_TYPE = 3;
    private static final int FLAG_EXECUTABLE = 4;
    private static final int FLAG_REDIRECT = 8;
    private static final int FLAG_SUGGESTIONS = 16;
    private static final int NODE_ROOT = 0;
    private static final int NODE_LITERAL = 1;
    private static final int NODE_ARGUMENT = 2;
    private RootCommandNode root;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        boolean mustCycle;
        int nodeCount = Commands.readVarInt(buf);
        NetworkNode[] nodes = new NetworkNode[nodeCount];
        ArrayDeque<NetworkNode> nodeQueue = new ArrayDeque<NetworkNode>(nodes.length);
        for (int i = 0; i < nodeCount; ++i) {
            NetworkNode node;
            ArgumentBuilder argumentBuilder;
            byte flags = buf.readByte();
            int[] children = Commands.readVarIntArray(buf);
            int redirectNode = (flags & 8) != 0 ? Commands.readVarInt(buf) : 0;
            switch (flags & 3) {
                case 0: {
                    argumentBuilder = null;
                    break;
                }
                case 1: {
                    argumentBuilder = LiteralArgumentBuilder.literal(Commands.readString(buf));
                    break;
                }
                case 2: {
                    String name = Commands.readString(buf);
                    argumentBuilder = RequiredArgumentBuilder.argument(name, ArgumentRegistry.read(buf, protocolVersion));
                    if ((flags & 0x10) == 0) break;
                    String suggster = Commands.readString(buf);
                    ((RequiredArgumentBuilder)argumentBuilder).suggests(SuggestionRegistry.getProvider(suggster));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unhandled node type " + flags);
                }
            }
            nodes[i] = node = new NetworkNode(argumentBuilder, flags, redirectNode, children);
            nodeQueue.add(node);
        }
        do {
            if (nodeQueue.isEmpty()) {
                int rootIndex = Commands.readVarInt(buf);
                this.root = (RootCommandNode)nodes[rootIndex].command;
                return;
            }
            mustCycle = false;
            Iterator iter = nodeQueue.iterator();
            while (iter.hasNext()) {
                NetworkNode node = (NetworkNode)iter.next();
                if (!node.buildSelf(nodes)) continue;
                iter.remove();
                mustCycle = true;
            }
        } while (mustCycle);
        throw new IllegalStateException("Did not finish building root node");
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        LinkedHashMap<CommandNode, Integer> indexMap = new LinkedHashMap<CommandNode, Integer>();
        ArrayDeque nodeQueue = new ArrayDeque();
        nodeQueue.add(this.root);
        while (!nodeQueue.isEmpty()) {
            CommandNode command = (CommandNode)nodeQueue.pollFirst();
            if (indexMap.containsKey(command)) continue;
            int currentIndex = indexMap.size();
            indexMap.put(command, currentIndex);
            nodeQueue.addAll(command.getChildren());
            if (command.getRedirect() == null) continue;
            nodeQueue.add(command.getRedirect());
        }
        Commands.writeVarInt(indexMap.size(), buf);
        int currentIndex = 0;
        for (Map.Entry entry : indexMap.entrySet()) {
            Preconditions.checkState((Integer)entry.getValue() == currentIndex++, "Iteration out of order!");
            CommandNode node = (CommandNode)entry.getKey();
            int flags = 0;
            if (node.getRedirect() != null) {
                flags = (byte)(flags | 8);
            }
            if (node.getCommand() != null) {
                flags = (byte)(flags | 4);
            }
            if (node instanceof RootCommandNode) {
                flags = (byte)(flags | 0);
            } else if (node instanceof LiteralCommandNode) {
                flags = (byte)(flags | 1);
            } else if (node instanceof ArgumentCommandNode) {
                flags = (byte)(flags | 2);
                if (((ArgumentCommandNode)node).getCustomSuggestions() != null) {
                    flags = (byte)(flags | 0x10);
                }
            } else {
                throw new IllegalArgumentException("Unhandled node type " + node);
            }
            buf.writeByte(flags);
            Commands.writeVarInt(node.getChildren().size(), buf);
            for (CommandNode child : node.getChildren()) {
                Commands.writeVarInt((Integer)indexMap.get(child), buf);
            }
            if (node.getRedirect() != null) {
                Commands.writeVarInt((Integer)indexMap.get(node.getRedirect()), buf);
            }
            if (node instanceof LiteralCommandNode) {
                Commands.writeString(((LiteralCommandNode)node).getLiteral(), buf);
                continue;
            }
            if (!(node instanceof ArgumentCommandNode)) continue;
            ArgumentCommandNode argumentNode = (ArgumentCommandNode)node;
            Commands.writeString(argumentNode.getName(), buf);
            ArgumentRegistry.write(argumentNode.getType(), buf, protocolVersion);
            if (argumentNode.getCustomSuggestions() == null) continue;
            Commands.writeString(SuggestionRegistry.getKey(argumentNode.getCustomSuggestions()), buf);
        }
        int rootIndex = (Integer)indexMap.get(this.root);
        Preconditions.checkState(rootIndex == 0, "How did root not land up at index 0?!?");
        Commands.writeVarInt(rootIndex, buf);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    private static byte binaryFlag(boolean first, boolean second) {
        byte ret = 0;
        if (first) {
            ret = (byte)(ret | 1);
        }
        if (second) {
            ret = (byte)(ret | 2);
        }
        return ret;
    }

    @Generated
    public RootCommandNode getRoot() {
        return this.root;
    }

    @Generated
    public void setRoot(RootCommandNode root) {
        this.root = root;
    }

    @Override
    @Generated
    public String toString() {
        return "Commands(root=" + this.getRoot() + ")";
    }

    @Generated
    public Commands() {
    }

    @Generated
    public Commands(RootCommandNode root) {
        this.root = root;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Commands)) {
            return false;
        }
        Commands other = (Commands)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RootCommandNode this$root = this.getRoot();
        RootCommandNode other$root = other.getRoot();
        return !(this$root == null ? other$root != null : !((Object)this$root).equals(other$root));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Commands;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RootCommandNode $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : ((Object)$root).hashCode());
        return result;
    }

    private static class NetworkNode {
        private final ArgumentBuilder argumentBuilder;
        private final byte flags;
        private final int redirectNode;
        private final int[] children;
        private CommandNode command;

        private boolean buildSelf(NetworkNode[] otherNodes) {
            if (this.command == null) {
                if (this.argumentBuilder == null) {
                    this.command = new RootCommandNode();
                } else {
                    if ((this.flags & 8) != 0) {
                        if (otherNodes[this.redirectNode].command == null) {
                            return false;
                        }
                        this.argumentBuilder.redirect(otherNodes[this.redirectNode].command);
                    }
                    if ((this.flags & 4) != 0) {
                        this.argumentBuilder.executes(new Command(){

                            public int run(CommandContext context) throws CommandSyntaxException {
                                return 0;
                            }
                        });
                    }
                    this.command = this.argumentBuilder.build();
                }
            }
            for (int childIndex : this.children) {
                if (otherNodes[childIndex].command != null) continue;
                return false;
            }
            for (int childIndex : this.children) {
                CommandNode child = otherNodes[childIndex].command;
                Preconditions.checkArgument(!(child instanceof RootCommandNode), "Cannot have RootCommandNode as child");
                this.command.addChild(child);
            }
            return true;
        }

        @Generated
        public NetworkNode(ArgumentBuilder argumentBuilder, byte flags, int redirectNode, int[] children) {
            this.argumentBuilder = argumentBuilder;
            this.flags = flags;
            this.redirectNode = redirectNode;
            this.children = children;
        }

        @Generated
        public ArgumentBuilder getArgumentBuilder() {
            return this.argumentBuilder;
        }

        @Generated
        public byte getFlags() {
            return this.flags;
        }

        @Generated
        public int getRedirectNode() {
            return this.redirectNode;
        }

        @Generated
        public int[] getChildren() {
            return this.children;
        }

        @Generated
        public CommandNode getCommand() {
            return this.command;
        }

        @Generated
        public void setCommand(CommandNode command) {
            this.command = command;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NetworkNode)) {
                return false;
            }
            NetworkNode other = (NetworkNode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFlags() != other.getFlags()) {
                return false;
            }
            if (this.getRedirectNode() != other.getRedirectNode()) {
                return false;
            }
            ArgumentBuilder this$argumentBuilder = this.getArgumentBuilder();
            ArgumentBuilder other$argumentBuilder = other.getArgumentBuilder();
            if (this$argumentBuilder == null ? other$argumentBuilder != null : !this$argumentBuilder.equals(other$argumentBuilder)) {
                return false;
            }
            if (!Arrays.equals(this.getChildren(), other.getChildren())) {
                return false;
            }
            CommandNode this$command = this.getCommand();
            CommandNode other$command = other.getCommand();
            return !(this$command == null ? other$command != null : !((Object)this$command).equals(other$command));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NetworkNode;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFlags();
            result = result * 59 + this.getRedirectNode();
            ArgumentBuilder $argumentBuilder = this.getArgumentBuilder();
            result = result * 59 + ($argumentBuilder == null ? 43 : $argumentBuilder.hashCode());
            result = result * 59 + Arrays.hashCode(this.getChildren());
            CommandNode $command = this.getCommand();
            result = result * 59 + ($command == null ? 43 : ((Object)$command).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Commands.NetworkNode(argumentBuilder=" + this.getArgumentBuilder() + ", flags=" + this.getFlags() + ", redirectNode=" + this.getRedirectNode() + ", children=" + Arrays.toString(this.getChildren()) + ", command=" + this.getCommand() + ")";
        }
    }

    private static class ArgumentRegistry {
        private static final Map<String, ArgumentSerializer> PROVIDERS = new HashMap<String, ArgumentSerializer>();
        private static final ArgumentSerializer[] IDS_1_19;
        private static final ArgumentSerializer[] IDS_1_19_3;
        private static final ArgumentSerializer[] IDS_1_19_4;
        private static final ArgumentSerializer[] IDS_1_20_3;
        private static final ArgumentSerializer[] IDS_1_20_5;
        private static final ArgumentSerializer[] IDS_1_21_5;
        private static final Map<Class<?>, ProperArgumentSerializer<?>> PROPER_PROVIDERS;
        private static final ArgumentSerializer<Void> VOID;
        private static final ArgumentSerializer<Boolean> BOOLEAN;
        private static final ArgumentSerializer<Byte> BYTE;
        private static final ArgumentSerializer<FloatArgumentType> FLOAT_RANGE;
        private static final ArgumentSerializer<DoubleArgumentType> DOUBLE_RANGE;
        private static final ArgumentSerializer<IntegerArgumentType> INTEGER_RANGE;
        private static final ArgumentSerializer<Integer> INTEGER;
        private static final ArgumentSerializer<LongArgumentType> LONG_RANGE;
        private static final ProperArgumentSerializer<StringArgumentType> STRING;
        private static final ArgumentSerializer<String> RAW_STRING;

        private static void register(String name, ArgumentSerializer serializer) {
            PROVIDERS.put(name, serializer);
        }

        private static ArgumentSerializer get(String name, ArgumentSerializer serializer) {
            return serializer;
        }

        private static ArgumentType<?> read(ByteBuf buf, int protocolVersion) {
            ArgumentSerializer reader;
            Object key;
            if (protocolVersion >= 759) {
                key = DefinedPacket.readVarInt(buf);
                reader = protocolVersion >= 1073742061 ? IDS_1_21_5[(Integer)key] : (protocolVersion >= 766 ? IDS_1_20_5[(Integer)key] : (protocolVersion >= 765 ? IDS_1_20_3[(Integer)key] : (protocolVersion >= 762 ? IDS_1_19_4[(Integer)key] : (protocolVersion >= 761 ? IDS_1_19_3[(Integer)key] : IDS_1_19[(Integer)key]))));
            } else {
                key = DefinedPacket.readString(buf);
                reader = PROVIDERS.get((String)key);
            }
            Preconditions.checkArgument(reader != null, "No provider for argument " + key);
            Object val = reader.read(buf);
            return val != null && PROPER_PROVIDERS.containsKey(val.getClass()) ? (ArgumentType)val : new DummyType(key, reader, val);
        }

        private static void write(ArgumentType<?> arg, ByteBuf buf, int protocolVersion) {
            ProperArgumentSerializer<?> proper = PROPER_PROVIDERS.get(arg.getClass());
            if (proper != null) {
                if (protocolVersion >= 759) {
                    DefinedPacket.writeVarInt(proper.getIntKey(), buf);
                } else {
                    DefinedPacket.writeString(proper.getKey(), buf);
                }
                proper.write(buf, arg);
            } else {
                Preconditions.checkArgument(arg instanceof DummyType, "Non dummy arg " + arg.getClass());
                DummyType dummy = (DummyType)arg;
                if (dummy.key instanceof Integer) {
                    DefinedPacket.writeVarInt((Integer)dummy.key, buf);
                } else {
                    DefinedPacket.writeString((String)dummy.key, buf);
                }
                dummy.serializer.write(buf, dummy.value);
            }
        }

        @Generated
        public ArgumentRegistry() {
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArgumentRegistry)) {
                return false;
            }
            ArgumentRegistry other = (ArgumentRegistry)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ArgumentRegistry;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Generated
        public String toString() {
            return "Commands.ArgumentRegistry()";
        }

        static {
            PROPER_PROVIDERS = new HashMap();
            VOID = new ArgumentSerializer<Void>(){

                @Override
                protected Void read(ByteBuf buf) {
                    return null;
                }

                @Override
                protected void write(ByteBuf buf, Void t2) {
                }
            };
            BOOLEAN = new ArgumentSerializer<Boolean>(){

                @Override
                protected Boolean read(ByteBuf buf) {
                    return buf.readBoolean();
                }

                @Override
                protected void write(ByteBuf buf, Boolean t2) {
                    buf.writeBoolean(t2);
                }
            };
            BYTE = new ArgumentSerializer<Byte>(){

                @Override
                protected Byte read(ByteBuf buf) {
                    return buf.readByte();
                }

                @Override
                protected void write(ByteBuf buf, Byte t2) {
                    buf.writeByte(t2.byteValue());
                }
            };
            FLOAT_RANGE = new ArgumentSerializer<FloatArgumentType>(){

                @Override
                protected FloatArgumentType read(ByteBuf buf) {
                    byte flags = buf.readByte();
                    float min2 = (flags & 1) != 0 ? buf.readFloat() : -3.4028235E38f;
                    float max = (flags & 2) != 0 ? buf.readFloat() : Float.MAX_VALUE;
                    return FloatArgumentType.floatArg(min2, max);
                }

                @Override
                protected void write(ByteBuf buf, FloatArgumentType t2) {
                    boolean hasMin = t2.getMinimum() != -3.4028235E38f;
                    boolean hasMax = t2.getMaximum() != Float.MAX_VALUE;
                    buf.writeByte(Commands.binaryFlag(hasMin, hasMax));
                    if (hasMin) {
                        buf.writeFloat(t2.getMinimum());
                    }
                    if (hasMax) {
                        buf.writeFloat(t2.getMaximum());
                    }
                }
            };
            DOUBLE_RANGE = new ArgumentSerializer<DoubleArgumentType>(){

                @Override
                protected DoubleArgumentType read(ByteBuf buf) {
                    byte flags = buf.readByte();
                    double min2 = (flags & 1) != 0 ? buf.readDouble() : -1.7976931348623157E308;
                    double max = (flags & 2) != 0 ? buf.readDouble() : Double.MAX_VALUE;
                    return DoubleArgumentType.doubleArg(min2, max);
                }

                @Override
                protected void write(ByteBuf buf, DoubleArgumentType t2) {
                    boolean hasMin = t2.getMinimum() != -1.7976931348623157E308;
                    boolean hasMax = t2.getMaximum() != Double.MAX_VALUE;
                    buf.writeByte(Commands.binaryFlag(hasMin, hasMax));
                    if (hasMin) {
                        buf.writeDouble(t2.getMinimum());
                    }
                    if (hasMax) {
                        buf.writeDouble(t2.getMaximum());
                    }
                }
            };
            INTEGER_RANGE = new ArgumentSerializer<IntegerArgumentType>(){

                @Override
                protected IntegerArgumentType read(ByteBuf buf) {
                    byte flags = buf.readByte();
                    int min2 = (flags & 1) != 0 ? buf.readInt() : Integer.MIN_VALUE;
                    int max = (flags & 2) != 0 ? buf.readInt() : Integer.MAX_VALUE;
                    return IntegerArgumentType.integer(min2, max);
                }

                @Override
                protected void write(ByteBuf buf, IntegerArgumentType t2) {
                    boolean hasMin = t2.getMinimum() != Integer.MIN_VALUE;
                    boolean hasMax = t2.getMaximum() != Integer.MAX_VALUE;
                    buf.writeByte(Commands.binaryFlag(hasMin, hasMax));
                    if (hasMin) {
                        buf.writeInt(t2.getMinimum());
                    }
                    if (hasMax) {
                        buf.writeInt(t2.getMaximum());
                    }
                }
            };
            INTEGER = new ArgumentSerializer<Integer>(){

                @Override
                protected Integer read(ByteBuf buf) {
                    return buf.readInt();
                }

                @Override
                protected void write(ByteBuf buf, Integer t2) {
                    buf.writeInt(t2);
                }
            };
            LONG_RANGE = new ArgumentSerializer<LongArgumentType>(){

                @Override
                protected LongArgumentType read(ByteBuf buf) {
                    byte flags = buf.readByte();
                    long min2 = (flags & 1) != 0 ? buf.readLong() : Long.MIN_VALUE;
                    long max = (flags & 2) != 0 ? buf.readLong() : Long.MAX_VALUE;
                    return LongArgumentType.longArg(min2, max);
                }

                @Override
                protected void write(ByteBuf buf, LongArgumentType t2) {
                    boolean hasMin = t2.getMinimum() != Long.MIN_VALUE;
                    boolean hasMax = t2.getMaximum() != Long.MAX_VALUE;
                    buf.writeByte(Commands.binaryFlag(hasMin, hasMax));
                    if (hasMin) {
                        buf.writeLong(t2.getMinimum());
                    }
                    if (hasMax) {
                        buf.writeLong(t2.getMaximum());
                    }
                }
            };
            STRING = new ProperArgumentSerializer<StringArgumentType>(){

                @Override
                protected StringArgumentType read(ByteBuf buf) {
                    int val = DefinedPacket.readVarInt(buf);
                    switch (val) {
                        case 0: {
                            return StringArgumentType.word();
                        }
                        case 1: {
                            return StringArgumentType.string();
                        }
                        case 2: {
                            return StringArgumentType.greedyString();
                        }
                    }
                    throw new IllegalArgumentException("Unknown string type " + val);
                }

                @Override
                protected void write(ByteBuf buf, StringArgumentType t2) {
                    DefinedPacket.writeVarInt(t2.getType().ordinal(), buf);
                }

                @Override
                protected int getIntKey() {
                    return 5;
                }

                @Override
                protected String getKey() {
                    return "brigadier:string";
                }
            };
            RAW_STRING = new ArgumentSerializer<String>(){

                @Override
                protected String read(ByteBuf buf) {
                    return DefinedPacket.readString(buf);
                }

                @Override
                protected void write(ByteBuf buf, String t2) {
                    DefinedPacket.writeString(t2, buf);
                }
            };
            ArgumentRegistry.register("brigadier:bool", VOID);
            ArgumentRegistry.register("brigadier:float", FLOAT_RANGE);
            ArgumentRegistry.register("brigadier:double", DOUBLE_RANGE);
            ArgumentRegistry.register("brigadier:integer", INTEGER_RANGE);
            ArgumentRegistry.register("brigadier:long", LONG_RANGE);
            ArgumentRegistry.register("brigadier:string", STRING);
            PROPER_PROVIDERS.put(StringArgumentType.class, STRING);
            ArgumentRegistry.register("minecraft:entity", BYTE);
            ArgumentRegistry.register("minecraft:game_profile", VOID);
            ArgumentRegistry.register("minecraft:block_pos", VOID);
            ArgumentRegistry.register("minecraft:column_pos", VOID);
            ArgumentRegistry.register("minecraft:vec3", VOID);
            ArgumentRegistry.register("minecraft:vec2", VOID);
            ArgumentRegistry.register("minecraft:block_state", VOID);
            ArgumentRegistry.register("minecraft:block_predicate", VOID);
            ArgumentRegistry.register("minecraft:item_stack", VOID);
            ArgumentRegistry.register("minecraft:item_predicate", VOID);
            ArgumentRegistry.register("minecraft:color", VOID);
            ArgumentRegistry.register("minecraft:component", VOID);
            ArgumentRegistry.register("minecraft:message", VOID);
            ArgumentRegistry.register("minecraft:nbt_compound_tag", VOID);
            ArgumentRegistry.register("minecraft:nbt_tag", VOID);
            ArgumentRegistry.register("minecraft:nbt_path", VOID);
            ArgumentRegistry.register("minecraft:objective", VOID);
            ArgumentRegistry.register("minecraft:objective_criteria", VOID);
            ArgumentRegistry.register("minecraft:operation", VOID);
            ArgumentRegistry.register("minecraft:particle", VOID);
            ArgumentRegistry.register("minecraft:angle", VOID);
            ArgumentRegistry.register("minecraft:rotation", VOID);
            ArgumentRegistry.register("minecraft:scoreboard_slot", VOID);
            ArgumentRegistry.register("minecraft:score_holder", BYTE);
            ArgumentRegistry.register("minecraft:swizzle", VOID);
            ArgumentRegistry.register("minecraft:team", VOID);
            ArgumentRegistry.register("minecraft:item_slot", VOID);
            ArgumentRegistry.register("minecraft:resource_location", VOID);
            ArgumentRegistry.register("minecraft:mob_effect", VOID);
            ArgumentRegistry.register("minecraft:function", VOID);
            ArgumentRegistry.register("minecraft:entity_anchor", VOID);
            ArgumentRegistry.register("minecraft:int_range", VOID);
            ArgumentRegistry.register("minecraft:float_range", VOID);
            ArgumentRegistry.register("minecraft:item_enchantment", VOID);
            ArgumentRegistry.register("minecraft:entity_summon", VOID);
            ArgumentRegistry.register("minecraft:dimension", VOID);
            ArgumentRegistry.register("minecraft:time", VOID);
            ArgumentRegistry.register("minecraft:resource_or_tag", RAW_STRING);
            ArgumentRegistry.register("minecraft:resource", RAW_STRING);
            ArgumentRegistry.register("minecraft:uuid", VOID);
            ArgumentRegistry.register("minecraft:nbt", VOID);
            IDS_1_19 = new ArgumentSerializer[]{ArgumentRegistry.get("brigadier:bool", VOID), ArgumentRegistry.get("brigadier:float", FLOAT_RANGE), ArgumentRegistry.get("brigadier:double", DOUBLE_RANGE), ArgumentRegistry.get("brigadier:integer", INTEGER_RANGE), ArgumentRegistry.get("brigadier:long", LONG_RANGE), ArgumentRegistry.get("brigadier:string", STRING), ArgumentRegistry.get("minecraft:entity", BYTE), ArgumentRegistry.get("minecraft:game_profile", VOID), ArgumentRegistry.get("minecraft:block_pos", VOID), ArgumentRegistry.get("minecraft:column_pos", VOID), ArgumentRegistry.get("minecraft:vec3", VOID), ArgumentRegistry.get("minecraft:vec2", VOID), ArgumentRegistry.get("minecraft:block_state", VOID), ArgumentRegistry.get("minecraft:block_predicate", VOID), ArgumentRegistry.get("minecraft:item_stack", VOID), ArgumentRegistry.get("minecraft:item_predicate", VOID), ArgumentRegistry.get("minecraft:color", VOID), ArgumentRegistry.get("minecraft:component", VOID), ArgumentRegistry.get("minecraft:message", VOID), ArgumentRegistry.get("minecraft:nbt_compound_tag", VOID), ArgumentRegistry.get("minecraft:nbt_tag", VOID), ArgumentRegistry.get("minecraft:nbt_path", VOID), ArgumentRegistry.get("minecraft:objective", VOID), ArgumentRegistry.get("minecraft:objective_criteria", VOID), ArgumentRegistry.get("minecraft:operation", VOID), ArgumentRegistry.get("minecraft:particle", VOID), ArgumentRegistry.get("minecraft:angle", VOID), ArgumentRegistry.get("minecraft:rotation", VOID), ArgumentRegistry.get("minecraft:scoreboard_slot", VOID), ArgumentRegistry.get("minecraft:score_holder", BYTE), ArgumentRegistry.get("minecraft:swizzle", VOID), ArgumentRegistry.get("minecraft:team", VOID), ArgumentRegistry.get("minecraft:item_slot", VOID), ArgumentRegistry.get("minecraft:resource_location", VOID), ArgumentRegistry.get("minecraft:mob_effect", VOID), ArgumentRegistry.get("minecraft:function", VOID), ArgumentRegistry.get("minecraft:entity_anchor", VOID), ArgumentRegistry.get("minecraft:int_range", VOID), ArgumentRegistry.get("minecraft:float_range", VOID), ArgumentRegistry.get("minecraft:item_enchantment", VOID), ArgumentRegistry.get("minecraft:entity_summon", VOID), ArgumentRegistry.get("minecraft:dimension", VOID), ArgumentRegistry.get("minecraft:time", VOID), ArgumentRegistry.get("minecraft:resource_or_tag", RAW_STRING), ArgumentRegistry.get("minecraft:resource", RAW_STRING), ArgumentRegistry.get("minecraft:template_mirror", VOID), ArgumentRegistry.get("minecraft:template_rotation", VOID), ArgumentRegistry.get("minecraft:uuid", VOID)};
            IDS_1_19_3 = new ArgumentSerializer[]{ArgumentRegistry.get("brigadier:bool", VOID), ArgumentRegistry.get("brigadier:float", FLOAT_RANGE), ArgumentRegistry.get("brigadier:double", DOUBLE_RANGE), ArgumentRegistry.get("brigadier:integer", INTEGER_RANGE), ArgumentRegistry.get("brigadier:long", LONG_RANGE), ArgumentRegistry.get("brigadier:string", STRING), ArgumentRegistry.get("minecraft:entity", BYTE), ArgumentRegistry.get("minecraft:game_profile", VOID), ArgumentRegistry.get("minecraft:block_pos", VOID), ArgumentRegistry.get("minecraft:column_pos", VOID), ArgumentRegistry.get("minecraft:vec3", VOID), ArgumentRegistry.get("minecraft:vec2", VOID), ArgumentRegistry.get("minecraft:block_state", VOID), ArgumentRegistry.get("minecraft:block_predicate", VOID), ArgumentRegistry.get("minecraft:item_stack", VOID), ArgumentRegistry.get("minecraft:item_predicate", VOID), ArgumentRegistry.get("minecraft:color", VOID), ArgumentRegistry.get("minecraft:component", VOID), ArgumentRegistry.get("minecraft:message", VOID), ArgumentRegistry.get("minecraft:nbt_compound_tag", VOID), ArgumentRegistry.get("minecraft:nbt_tag", VOID), ArgumentRegistry.get("minecraft:nbt_path", VOID), ArgumentRegistry.get("minecraft:objective", VOID), ArgumentRegistry.get("minecraft:objective_criteria", VOID), ArgumentRegistry.get("minecraft:operation", VOID), ArgumentRegistry.get("minecraft:particle", VOID), ArgumentRegistry.get("minecraft:angle", VOID), ArgumentRegistry.get("minecraft:rotation", VOID), ArgumentRegistry.get("minecraft:scoreboard_slot", VOID), ArgumentRegistry.get("minecraft:score_holder", BYTE), ArgumentRegistry.get("minecraft:swizzle", VOID), ArgumentRegistry.get("minecraft:team", VOID), ArgumentRegistry.get("minecraft:item_slot", VOID), ArgumentRegistry.get("minecraft:resource_location", VOID), ArgumentRegistry.get("minecraft:function", VOID), ArgumentRegistry.get("minecraft:entity_anchor", VOID), ArgumentRegistry.get("minecraft:int_range", VOID), ArgumentRegistry.get("minecraft:float_range", VOID), ArgumentRegistry.get("minecraft:dimension", VOID), ArgumentRegistry.get("minecraft:gamemode", VOID), ArgumentRegistry.get("minecraft:time", VOID), ArgumentRegistry.get("minecraft:resource_or_tag", RAW_STRING), ArgumentRegistry.get("minecraft:resource_or_tag_key", RAW_STRING), ArgumentRegistry.get("minecraft:resource", RAW_STRING), ArgumentRegistry.get("minecraft:resource_key", RAW_STRING), ArgumentRegistry.get("minecraft:template_mirror", VOID), ArgumentRegistry.get("minecraft:template_rotation", VOID), ArgumentRegistry.get("minecraft:uuid", VOID)};
            IDS_1_19_4 = new ArgumentSerializer[]{ArgumentRegistry.get("brigadier:bool", VOID), ArgumentRegistry.get("brigadier:float", FLOAT_RANGE), ArgumentRegistry.get("brigadier:double", DOUBLE_RANGE), ArgumentRegistry.get("brigadier:integer", INTEGER_RANGE), ArgumentRegistry.get("brigadier:long", LONG_RANGE), ArgumentRegistry.get("brigadier:string", STRING), ArgumentRegistry.get("minecraft:entity", BYTE), ArgumentRegistry.get("minecraft:game_profile", VOID), ArgumentRegistry.get("minecraft:block_pos", VOID), ArgumentRegistry.get("minecraft:column_pos", VOID), ArgumentRegistry.get("minecraft:vec3", VOID), ArgumentRegistry.get("minecraft:vec2", VOID), ArgumentRegistry.get("minecraft:block_state", VOID), ArgumentRegistry.get("minecraft:block_predicate", VOID), ArgumentRegistry.get("minecraft:item_stack", VOID), ArgumentRegistry.get("minecraft:item_predicate", VOID), ArgumentRegistry.get("minecraft:color", VOID), ArgumentRegistry.get("minecraft:component", VOID), ArgumentRegistry.get("minecraft:message", VOID), ArgumentRegistry.get("minecraft:nbt_compound_tag", VOID), ArgumentRegistry.get("minecraft:nbt_tag", VOID), ArgumentRegistry.get("minecraft:nbt_path", VOID), ArgumentRegistry.get("minecraft:objective", VOID), ArgumentRegistry.get("minecraft:objective_criteria", VOID), ArgumentRegistry.get("minecraft:operation", VOID), ArgumentRegistry.get("minecraft:particle", VOID), ArgumentRegistry.get("minecraft:angle", VOID), ArgumentRegistry.get("minecraft:rotation", VOID), ArgumentRegistry.get("minecraft:scoreboard_slot", VOID), ArgumentRegistry.get("minecraft:score_holder", BYTE), ArgumentRegistry.get("minecraft:swizzle", VOID), ArgumentRegistry.get("minecraft:team", VOID), ArgumentRegistry.get("minecraft:item_slot", VOID), ArgumentRegistry.get("minecraft:resource_location", VOID), ArgumentRegistry.get("minecraft:function", VOID), ArgumentRegistry.get("minecraft:entity_anchor", VOID), ArgumentRegistry.get("minecraft:int_range", VOID), ArgumentRegistry.get("minecraft:float_range", VOID), ArgumentRegistry.get("minecraft:dimension", VOID), ArgumentRegistry.get("minecraft:gamemode", VOID), ArgumentRegistry.get("minecraft:time", INTEGER), ArgumentRegistry.get("minecraft:resource_or_tag", RAW_STRING), ArgumentRegistry.get("minecraft:resource_or_tag_key", RAW_STRING), ArgumentRegistry.get("minecraft:resource", RAW_STRING), ArgumentRegistry.get("minecraft:resource_key", RAW_STRING), ArgumentRegistry.get("minecraft:template_mirror", VOID), ArgumentRegistry.get("minecraft:template_rotation", VOID), ArgumentRegistry.get("minecraft:uuid", VOID), ArgumentRegistry.get("minecraft:heightmap", VOID)};
            IDS_1_20_3 = new ArgumentSerializer[]{ArgumentRegistry.get("brigadier:bool", VOID), ArgumentRegistry.get("brigadier:float", FLOAT_RANGE), ArgumentRegistry.get("brigadier:double", DOUBLE_RANGE), ArgumentRegistry.get("brigadier:integer", INTEGER_RANGE), ArgumentRegistry.get("brigadier:long", LONG_RANGE), ArgumentRegistry.get("brigadier:string", STRING), ArgumentRegistry.get("minecraft:entity", BYTE), ArgumentRegistry.get("minecraft:game_profile", VOID), ArgumentRegistry.get("minecraft:block_pos", VOID), ArgumentRegistry.get("minecraft:column_pos", VOID), ArgumentRegistry.get("minecraft:vec3", VOID), ArgumentRegistry.get("minecraft:vec2", VOID), ArgumentRegistry.get("minecraft:block_state", VOID), ArgumentRegistry.get("minecraft:block_predicate", VOID), ArgumentRegistry.get("minecraft:item_stack", VOID), ArgumentRegistry.get("minecraft:item_predicate", VOID), ArgumentRegistry.get("minecraft:color", VOID), ArgumentRegistry.get("minecraft:component", VOID), ArgumentRegistry.get("minecraft:style", VOID), ArgumentRegistry.get("minecraft:message", VOID), ArgumentRegistry.get("minecraft:nbt_compound_tag", VOID), ArgumentRegistry.get("minecraft:nbt_tag", VOID), ArgumentRegistry.get("minecraft:nbt_path", VOID), ArgumentRegistry.get("minecraft:objective", VOID), ArgumentRegistry.get("minecraft:objective_criteria", VOID), ArgumentRegistry.get("minecraft:operation", VOID), ArgumentRegistry.get("minecraft:particle", VOID), ArgumentRegistry.get("minecraft:angle", VOID), ArgumentRegistry.get("minecraft:rotation", VOID), ArgumentRegistry.get("minecraft:scoreboard_slot", VOID), ArgumentRegistry.get("minecraft:score_holder", BYTE), ArgumentRegistry.get("minecraft:swizzle", VOID), ArgumentRegistry.get("minecraft:team", VOID), ArgumentRegistry.get("minecraft:item_slot", VOID), ArgumentRegistry.get("minecraft:resource_location", VOID), ArgumentRegistry.get("minecraft:function", VOID), ArgumentRegistry.get("minecraft:entity_anchor", VOID), ArgumentRegistry.get("minecraft:int_range", VOID), ArgumentRegistry.get("minecraft:float_range", VOID), ArgumentRegistry.get("minecraft:dimension", VOID), ArgumentRegistry.get("minecraft:gamemode", VOID), ArgumentRegistry.get("minecraft:time", INTEGER), ArgumentRegistry.get("minecraft:resource_or_tag", RAW_STRING), ArgumentRegistry.get("minecraft:resource_or_tag_key", RAW_STRING), ArgumentRegistry.get("minecraft:resource", RAW_STRING), ArgumentRegistry.get("minecraft:resource_key", RAW_STRING), ArgumentRegistry.get("minecraft:template_mirror", VOID), ArgumentRegistry.get("minecraft:template_rotation", VOID), ArgumentRegistry.get("minecraft:uuid", VOID), ArgumentRegistry.get("minecraft:heightmap", VOID)};
            IDS_1_20_5 = new ArgumentSerializer[]{ArgumentRegistry.get("brigadier:bool", VOID), ArgumentRegistry.get("brigadier:float", FLOAT_RANGE), ArgumentRegistry.get("brigadier:double", DOUBLE_RANGE), ArgumentRegistry.get("brigadier:integer", INTEGER_RANGE), ArgumentRegistry.get("brigadier:long", LONG_RANGE), ArgumentRegistry.get("brigadier:string", STRING), ArgumentRegistry.get("minecraft:entity", BYTE), ArgumentRegistry.get("minecraft:game_profile", VOID), ArgumentRegistry.get("minecraft:block_pos", VOID), ArgumentRegistry.get("minecraft:column_pos", VOID), ArgumentRegistry.get("minecraft:vec3", VOID), ArgumentRegistry.get("minecraft:vec2", VOID), ArgumentRegistry.get("minecraft:block_state", VOID), ArgumentRegistry.get("minecraft:block_predicate", VOID), ArgumentRegistry.get("minecraft:item_stack", VOID), ArgumentRegistry.get("minecraft:item_predicate", VOID), ArgumentRegistry.get("minecraft:color", VOID), ArgumentRegistry.get("minecraft:component", VOID), ArgumentRegistry.get("minecraft:style", VOID), ArgumentRegistry.get("minecraft:message", VOID), ArgumentRegistry.get("minecraft:nbt_compound_tag", VOID), ArgumentRegistry.get("minecraft:nbt_tag", VOID), ArgumentRegistry.get("minecraft:nbt_path", VOID), ArgumentRegistry.get("minecraft:objective", VOID), ArgumentRegistry.get("minecraft:objective_criteria", VOID), ArgumentRegistry.get("minecraft:operation", VOID), ArgumentRegistry.get("minecraft:particle", VOID), ArgumentRegistry.get("minecraft:angle", VOID), ArgumentRegistry.get("minecraft:rotation", VOID), ArgumentRegistry.get("minecraft:scoreboard_slot", VOID), ArgumentRegistry.get("minecraft:score_holder", BYTE), ArgumentRegistry.get("minecraft:swizzle", VOID), ArgumentRegistry.get("minecraft:team", VOID), ArgumentRegistry.get("minecraft:item_slot", VOID), ArgumentRegistry.get("minecraft:item_slots", VOID), ArgumentRegistry.get("minecraft:resource_location", VOID), ArgumentRegistry.get("minecraft:function", VOID), ArgumentRegistry.get("minecraft:entity_anchor", VOID), ArgumentRegistry.get("minecraft:int_range", VOID), ArgumentRegistry.get("minecraft:float_range", VOID), ArgumentRegistry.get("minecraft:dimension", VOID), ArgumentRegistry.get("minecraft:gamemode", VOID), ArgumentRegistry.get("minecraft:time", INTEGER), ArgumentRegistry.get("minecraft:resource_or_tag", RAW_STRING), ArgumentRegistry.get("minecraft:resource_or_tag_key", RAW_STRING), ArgumentRegistry.get("minecraft:resource", RAW_STRING), ArgumentRegistry.get("minecraft:resource_key", RAW_STRING), ArgumentRegistry.get("minecraft:template_mirror", VOID), ArgumentRegistry.get("minecraft:template_rotation", VOID), ArgumentRegistry.get("minecraft:uuid", VOID), ArgumentRegistry.get("minecraft:heightmap", VOID), ArgumentRegistry.get("minecraft:loot_table", VOID), ArgumentRegistry.get("minecraft:loot_predicate", VOID), ArgumentRegistry.get("minecraft:loot_modifier", VOID)};
            IDS_1_21_5 = new ArgumentSerializer[]{ArgumentRegistry.get("brigadier:bool", VOID), ArgumentRegistry.get("brigadier:float", FLOAT_RANGE), ArgumentRegistry.get("brigadier:double", DOUBLE_RANGE), ArgumentRegistry.get("brigadier:integer", INTEGER_RANGE), ArgumentRegistry.get("brigadier:long", LONG_RANGE), ArgumentRegistry.get("brigadier:string", STRING), ArgumentRegistry.get("minecraft:entity", BYTE), ArgumentRegistry.get("minecraft:game_profile", VOID), ArgumentRegistry.get("minecraft:block_pos", VOID), ArgumentRegistry.get("minecraft:column_pos", VOID), ArgumentRegistry.get("minecraft:vec3", VOID), ArgumentRegistry.get("minecraft:vec2", VOID), ArgumentRegistry.get("minecraft:block_state", VOID), ArgumentRegistry.get("minecraft:block_predicate", VOID), ArgumentRegistry.get("minecraft:item_stack", VOID), ArgumentRegistry.get("minecraft:item_predicate", VOID), ArgumentRegistry.get("minecraft:color", VOID), ArgumentRegistry.get("minecraft:component", VOID), ArgumentRegistry.get("minecraft:style", VOID), ArgumentRegistry.get("minecraft:message", VOID), ArgumentRegistry.get("minecraft:nbt_compound_tag", VOID), ArgumentRegistry.get("minecraft:nbt_tag", VOID), ArgumentRegistry.get("minecraft:nbt_path", VOID), ArgumentRegistry.get("minecraft:objective", VOID), ArgumentRegistry.get("minecraft:objective_criteria", VOID), ArgumentRegistry.get("minecraft:operation", VOID), ArgumentRegistry.get("minecraft:particle", VOID), ArgumentRegistry.get("minecraft:angle", VOID), ArgumentRegistry.get("minecraft:rotation", VOID), ArgumentRegistry.get("minecraft:scoreboard_slot", VOID), ArgumentRegistry.get("minecraft:score_holder", BYTE), ArgumentRegistry.get("minecraft:swizzle", VOID), ArgumentRegistry.get("minecraft:team", VOID), ArgumentRegistry.get("minecraft:item_slot", VOID), ArgumentRegistry.get("minecraft:item_slots", VOID), ArgumentRegistry.get("minecraft:resource_location", VOID), ArgumentRegistry.get("minecraft:function", VOID), ArgumentRegistry.get("minecraft:entity_anchor", VOID), ArgumentRegistry.get("minecraft:int_range", VOID), ArgumentRegistry.get("minecraft:float_range", VOID), ArgumentRegistry.get("minecraft:dimension", VOID), ArgumentRegistry.get("minecraft:gamemode", VOID), ArgumentRegistry.get("minecraft:time", INTEGER), ArgumentRegistry.get("minecraft:resource_or_tag", RAW_STRING), ArgumentRegistry.get("minecraft:resource_or_tag_key", RAW_STRING), ArgumentRegistry.get("minecraft:resource", RAW_STRING), ArgumentRegistry.get("minecraft:resource_key", RAW_STRING), ArgumentRegistry.get("minecraft:resource_selector", RAW_STRING), ArgumentRegistry.get("minecraft:template_mirror", VOID), ArgumentRegistry.get("minecraft:template_rotation", VOID), ArgumentRegistry.get("minecraft:uuid", VOID), ArgumentRegistry.get("minecraft:heightmap", VOID), ArgumentRegistry.get("minecraft:loot_table", VOID), ArgumentRegistry.get("minecraft:loot_predicate", VOID), ArgumentRegistry.get("minecraft:loot_modifier", VOID)};
        }

        private static abstract class ArgumentSerializer<T> {
            private ArgumentSerializer() {
            }

            protected abstract T read(ByteBuf var1);

            protected abstract void write(ByteBuf var1, T var2);
        }

        private static class DummyType<T>
        implements ArgumentType<T> {
            private final Object key;
            private final ArgumentSerializer<T> serializer;
            private final T value;

            @Override
            public T parse(StringReader reader) throws CommandSyntaxException {
                throw new UnsupportedOperationException("Not supported.");
            }

            @Generated
            public DummyType(Object key, ArgumentSerializer<T> serializer, T value) {
                this.key = key;
                this.serializer = serializer;
                this.value = value;
            }

            @Generated
            public Object getKey() {
                return this.key;
            }

            @Generated
            public ArgumentSerializer<T> getSerializer() {
                return this.serializer;
            }

            @Generated
            public T getValue() {
                return this.value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DummyType)) {
                    return false;
                }
                DummyType other = (DummyType)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Object this$key = this.getKey();
                Object other$key = other.getKey();
                if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                    return false;
                }
                ArgumentSerializer<T> this$serializer = this.getSerializer();
                ArgumentSerializer<T> other$serializer = other.getSerializer();
                if (this$serializer == null ? other$serializer != null : !this$serializer.equals(other$serializer)) {
                    return false;
                }
                T this$value = this.getValue();
                T other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DummyType;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Object $key = this.getKey();
                result = result * 59 + ($key == null ? 43 : $key.hashCode());
                ArgumentSerializer<T> $serializer = this.getSerializer();
                result = result * 59 + ($serializer == null ? 43 : $serializer.hashCode());
                T $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Commands.ArgumentRegistry.DummyType(key=" + this.getKey() + ", serializer=" + this.getSerializer() + ", value=" + this.getValue() + ")";
            }
        }

        private static abstract class ProperArgumentSerializer<T>
        extends ArgumentSerializer<T> {
            private ProperArgumentSerializer() {
            }

            protected abstract int getIntKey();

            protected abstract String getKey();
        }
    }

    public static class SuggestionRegistry {
        public static final SuggestionProvider ASK_SERVER = new DummyProvider("minecraft:ask_server");
        private static final Map<String, SuggestionProvider<DummyProvider>> PROVIDERS = new HashMap<String, SuggestionProvider<DummyProvider>>();

        private static void registerDummy(String name) {
            PROVIDERS.put(name, new DummyProvider(name));
        }

        private static SuggestionProvider<DummyProvider> getProvider(String key) {
            SuggestionProvider<DummyProvider> provider = PROVIDERS.get(key);
            Preconditions.checkArgument(provider != null, "Unknown completion provider " + key);
            return provider;
        }

        private static String getKey(SuggestionProvider<DummyProvider> provider) {
            Preconditions.checkArgument(provider instanceof DummyProvider, "Non dummy provider " + provider);
            return ((DummyProvider)provider).key;
        }

        @Generated
        public SuggestionRegistry() {
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SuggestionRegistry)) {
                return false;
            }
            SuggestionRegistry other = (SuggestionRegistry)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SuggestionRegistry;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }

        @Generated
        public String toString() {
            return "Commands.SuggestionRegistry()";
        }

        static {
            PROVIDERS.put("minecraft:ask_server", ASK_SERVER);
            SuggestionRegistry.registerDummy("minecraft:all_recipes");
            SuggestionRegistry.registerDummy("minecraft:available_sounds");
            SuggestionRegistry.registerDummy("minecraft:available_biomes");
            SuggestionRegistry.registerDummy("minecraft:summonable_entities");
        }

        private static final class DummyProvider
        implements SuggestionProvider<DummyProvider> {
            private final String key;

            @Override
            public CompletableFuture<Suggestions> getSuggestions(CommandContext<DummyProvider> context, SuggestionsBuilder builder) throws CommandSyntaxException {
                return builder.buildFuture();
            }

            @Generated
            public DummyProvider(String key) {
                this.key = key;
            }

            @Generated
            public String getKey() {
                return this.key;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DummyProvider)) {
                    return false;
                }
                DummyProvider other = (DummyProvider)o;
                String this$key = this.getKey();
                String other$key = other.getKey();
                return !(this$key == null ? other$key != null : !this$key.equals(other$key));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $key = this.getKey();
                result = result * 59 + ($key == null ? 43 : $key.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "Commands.SuggestionRegistry.DummyProvider(key=" + this.getKey() + ")";
            }
        }
    }
}

