/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.log;

import java.io.IOException;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import jline.console.ConsoleReader;
import lombok.Generated;
import net.md_5.bungee.api.ChatColor;
import org.fusesource.jansi.Ansi;

public class ColouredWriter
extends Handler {
    private static final ReplacementSpecification[] REPLACEMENTS = new ReplacementSpecification[]{ColouredWriter.compile(ChatColor.BLACK, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.BLACK).boldOff().toString()), ColouredWriter.compile(ChatColor.DARK_BLUE, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.BLUE).boldOff().toString()), ColouredWriter.compile(ChatColor.DARK_GREEN, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.GREEN).boldOff().toString()), ColouredWriter.compile(ChatColor.DARK_AQUA, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.CYAN).boldOff().toString()), ColouredWriter.compile(ChatColor.DARK_RED, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.RED).boldOff().toString()), ColouredWriter.compile(ChatColor.DARK_PURPLE, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.MAGENTA).boldOff().toString()), ColouredWriter.compile(ChatColor.GOLD, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.YELLOW).boldOff().toString()), ColouredWriter.compile(ChatColor.GRAY, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.WHITE).boldOff().toString()), ColouredWriter.compile(ChatColor.DARK_GRAY, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.BLACK).bold().toString()), ColouredWriter.compile(ChatColor.BLUE, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.BLUE).bold().toString()), ColouredWriter.compile(ChatColor.GREEN, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.GREEN).bold().toString()), ColouredWriter.compile(ChatColor.AQUA, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.CYAN).bold().toString()), ColouredWriter.compile(ChatColor.RED, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.RED).bold().toString()), ColouredWriter.compile(ChatColor.LIGHT_PURPLE, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.MAGENTA).bold().toString()), ColouredWriter.compile(ChatColor.YELLOW, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.YELLOW).bold().toString()), ColouredWriter.compile(ChatColor.WHITE, Ansi.ansi().a(Ansi.Attribute.RESET).fg(Ansi.Color.WHITE).bold().toString()), ColouredWriter.compile(ChatColor.MAGIC, Ansi.ansi().a(Ansi.Attribute.BLINK_SLOW).toString()), ColouredWriter.compile(ChatColor.BOLD, Ansi.ansi().a(Ansi.Attribute.UNDERLINE_DOUBLE).toString()), ColouredWriter.compile(ChatColor.STRIKETHROUGH, Ansi.ansi().a(Ansi.Attribute.STRIKETHROUGH_ON).toString()), ColouredWriter.compile(ChatColor.UNDERLINE, Ansi.ansi().a(Ansi.Attribute.UNDERLINE).toString()), ColouredWriter.compile(ChatColor.ITALIC, Ansi.ansi().a(Ansi.Attribute.ITALIC).toString()), ColouredWriter.compile(ChatColor.RESET, Ansi.ansi().a(Ansi.Attribute.RESET).toString())};
    private final ConsoleReader console;

    private static ReplacementSpecification compile(ChatColor color, String ansi) {
        return new ReplacementSpecification(Pattern.compile("(?i)" + color.toString()), ansi);
    }

    public ColouredWriter(ConsoleReader console) {
        this.console = console;
    }

    public void print(String s2) {
        for (ReplacementSpecification replacement : REPLACEMENTS) {
            s2 = replacement.pattern.matcher(s2).replaceAll(replacement.replacement);
        }
        try {
            this.console.print(Ansi.ansi().eraseLine(Ansi.Erase.ALL).toString() + '\r' + s2 + Ansi.ansi().reset().toString());
            this.console.drawLine();
            this.console.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (this.isLoggable(record)) {
            this.print(this.getFormatter().format(record));
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    private static class ReplacementSpecification {
        private final Pattern pattern;
        private final String replacement;

        @Generated
        public ReplacementSpecification(Pattern pattern, String replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }

        @Generated
        public Pattern getPattern() {
            return this.pattern;
        }

        @Generated
        public String getReplacement() {
            return this.replacement;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplacementSpecification)) {
                return false;
            }
            ReplacementSpecification other = (ReplacementSpecification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Pattern this$pattern = this.getPattern();
            Pattern other$pattern = other.getPattern();
            if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
                return false;
            }
            String this$replacement = this.getReplacement();
            String other$replacement = other.getReplacement();
            return !(this$replacement == null ? other$replacement != null : !this$replacement.equals(other$replacement));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReplacementSpecification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Pattern $pattern = this.getPattern();
            result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
            String $replacement = this.getReplacement();
            result = result * 59 + ($replacement == null ? 43 : $replacement.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ColouredWriter.ReplacementSpecification(pattern=" + this.getPattern() + ", replacement=" + this.getReplacement() + ")";
        }
    }
}

