/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.nbt;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import se.llbit.nbt.ErrorTag;
import se.llbit.nbt.SpecificTag;

public class ByteArrayTag
extends SpecificTag {
    public final byte[] value;

    public static SpecificTag read(DataInputStream in) {
        try {
            int length = in.readInt();
            byte[] data = new byte[length];
            in.readFully(data, 0, length);
            return new ByteArrayTag(data);
        }
        catch (IOException e) {
            return new ErrorTag("IOException while reading TAG_Byte_Array:\n" + e.getMessage());
        }
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.getData().length);
        out.write(this.getData());
    }

    static void skip(DataInputStream in) {
        try {
            int length = in.readInt();
            in.skipBytes(length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ByteArrayTag(byte[] value) {
        this.value = value;
    }

    public byte[] getData() {
        return this.value;
    }

    @Override
    public String extraInfo() {
        return ": " + this.value.length;
    }

    public String type() {
        return "TAG_Byte_Array";
    }

    @Override
    public String tagName() {
        return "TAG_Byte_Array";
    }

    @Override
    public int tagType() {
        return 7;
    }

    @Override
    public byte[] byteArray() {
        return this.getData();
    }

    @Override
    public byte[] byteArray(byte[] defaultValue) {
        return this.getData();
    }

    @Override
    public boolean isByteArray(int size) {
        return this.getData().length >= size;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ByteArrayTag && Arrays.equals(((ByteArrayTag)obj).value, this.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }
}

