/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.channel.uring;

import io.netty.incubator.channel.uring.Native;
import io.netty.util.internal.PlatformDependent;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

final class SockaddrIn {
    static final byte[] IPV4_MAPPED_IPV6_PREFIX = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};
    static final int IPV4_ADDRESS_LENGTH = 4;
    static final int IPV6_ADDRESS_LENGTH = 16;

    private SockaddrIn() {
    }

    static int write(boolean ipv6, long memory, InetSocketAddress address) {
        if (ipv6) {
            return SockaddrIn.writeIPv6(memory, address.getAddress(), address.getPort());
        }
        return SockaddrIn.writeIPv4(memory, address.getAddress(), address.getPort());
    }

    static int writeIPv4(long memory, InetAddress address, int port) {
        PlatformDependent.setMemory(memory, Native.SIZEOF_SOCKADDR_IN, (byte)0);
        PlatformDependent.putShort(memory + (long)Native.SOCKADDR_IN_OFFSETOF_SIN_FAMILY, Native.AF_INET);
        PlatformDependent.putShort(memory + (long)Native.SOCKADDR_IN_OFFSETOF_SIN_PORT, SockaddrIn.handleNetworkOrder((short)port));
        byte[] bytes = address.getAddress();
        int offset = 0;
        if (bytes.length == 16) {
            offset = IPV4_MAPPED_IPV6_PREFIX.length;
        }
        assert (bytes.length == offset + 4);
        PlatformDependent.copyMemory(bytes, offset, memory + (long)Native.SOCKADDR_IN_OFFSETOF_SIN_ADDR + (long)Native.IN_ADDRESS_OFFSETOF_S_ADDR, 4L);
        return Native.SIZEOF_SOCKADDR_IN;
    }

    static int writeIPv6(long memory, InetAddress address, int port) {
        PlatformDependent.setMemory(memory, Native.SIZEOF_SOCKADDR_IN6, (byte)0);
        PlatformDependent.putShort(memory + (long)Native.SOCKADDR_IN6_OFFSETOF_SIN6_FAMILY, Native.AF_INET6);
        PlatformDependent.putShort(memory + (long)Native.SOCKADDR_IN6_OFFSETOF_SIN6_PORT, SockaddrIn.handleNetworkOrder((short)port));
        byte[] bytes = address.getAddress();
        if (bytes.length == 4) {
            int offset = Native.SOCKADDR_IN6_OFFSETOF_SIN6_ADDR + Native.IN6_ADDRESS_OFFSETOF_S6_ADDR;
            PlatformDependent.copyMemory(IPV4_MAPPED_IPV6_PREFIX, 0, memory + (long)offset, (long)IPV4_MAPPED_IPV6_PREFIX.length);
            PlatformDependent.copyMemory(bytes, 0, memory + (long)offset + (long)IPV4_MAPPED_IPV6_PREFIX.length, 4L);
        } else {
            PlatformDependent.copyMemory(bytes, 0, memory + (long)Native.SOCKADDR_IN6_OFFSETOF_SIN6_ADDR + (long)Native.IN6_ADDRESS_OFFSETOF_S6_ADDR, 16L);
            PlatformDependent.putInt(memory + (long)Native.SOCKADDR_IN6_OFFSETOF_SIN6_SCOPE_ID, ((Inet6Address)address).getScopeId());
        }
        return Native.SIZEOF_SOCKADDR_IN6;
    }

    static InetSocketAddress readIPv4(long memory, byte[] tmpArray) {
        assert (tmpArray.length == 4);
        int port = SockaddrIn.handleNetworkOrder(PlatformDependent.getShort(memory + (long)Native.SOCKADDR_IN_OFFSETOF_SIN_PORT)) & 0xFFFF;
        PlatformDependent.copyMemory(memory + (long)Native.SOCKADDR_IN_OFFSETOF_SIN_ADDR + (long)Native.IN_ADDRESS_OFFSETOF_S_ADDR, tmpArray, 0, 4L);
        try {
            return new InetSocketAddress(InetAddress.getByAddress(tmpArray), port);
        }
        catch (UnknownHostException ignore) {
            return null;
        }
    }

    static InetSocketAddress readIPv6(long memory, byte[] ipv6Array, byte[] ipv4Array) {
        assert (ipv6Array.length == 16);
        assert (ipv4Array.length == 4);
        int port = SockaddrIn.handleNetworkOrder(PlatformDependent.getShort(memory + (long)Native.SOCKADDR_IN6_OFFSETOF_SIN6_PORT)) & 0xFFFF;
        PlatformDependent.copyMemory(memory + (long)Native.SOCKADDR_IN6_OFFSETOF_SIN6_ADDR + (long)Native.IN6_ADDRESS_OFFSETOF_S6_ADDR, ipv6Array, 0, 16L);
        if (PlatformDependent.equals(ipv6Array, 0, IPV4_MAPPED_IPV6_PREFIX, 0, IPV4_MAPPED_IPV6_PREFIX.length)) {
            System.arraycopy(ipv6Array, IPV4_MAPPED_IPV6_PREFIX.length, ipv4Array, 0, 4);
            try {
                return new InetSocketAddress(Inet4Address.getByAddress(ipv4Array), port);
            }
            catch (UnknownHostException ignore) {
                return null;
            }
        }
        int scopeId = PlatformDependent.getInt(memory + (long)Native.SOCKADDR_IN6_OFFSETOF_SIN6_SCOPE_ID);
        try {
            return new InetSocketAddress(Inet6Address.getByAddress(null, ipv6Array, scopeId), port);
        }
        catch (UnknownHostException ignore) {
            return null;
        }
    }

    static boolean hasPortIpv4(long memory) {
        int port = SockaddrIn.handleNetworkOrder(PlatformDependent.getShort(memory + (long)Native.SOCKADDR_IN_OFFSETOF_SIN_PORT)) & 0xFFFF;
        return port > 0;
    }

    static boolean hasPortIpv6(long memory) {
        int port = SockaddrIn.handleNetworkOrder(PlatformDependent.getShort(memory + (long)Native.SOCKADDR_IN6_OFFSETOF_SIN6_PORT)) & 0xFFFF;
        return port > 0;
    }

    private static short handleNetworkOrder(short v) {
        return PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? v : Short.reverseBytes(v);
    }
}

