/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.compress;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import lombok.Generated;
import net.md_5.bungee.compress.CompressFactory;
import net.md_5.bungee.jni.zlib.BungeeZlib;
import net.md_5.bungee.protocol.DefinedPacket;

public class PacketCompressor
extends MessageToMessageEncoder<ByteBuf> {
    private final BungeeZlib zlib = CompressFactory.zlib.newInstance();
    private int threshold = 256;
    private boolean compose = true;

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.zlib.init(true, -1);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.zlib.free();
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) throws Exception {
        int origSize = msg.readableBytes();
        if (origSize < this.threshold) {
            if (this.compose) {
                out.add(ctx.alloc().compositeDirectBuffer(2).addComponents(true, ctx.alloc().directBuffer(1).writeByte(0), msg.retain()));
            } else {
                out.add(ctx.alloc().directBuffer(origSize + 1).writeByte(0).writeBytes(msg));
            }
        } else {
            ByteBuf buf = ctx.alloc().directBuffer(8192);
            DefinedPacket.writeVarInt(origSize, buf);
            this.zlib.process(msg, buf);
            out.add(buf);
        }
    }

    @Generated
    public BungeeZlib getZlib() {
        return this.zlib;
    }

    @Generated
    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Generated
    public void setCompose(boolean compose) {
        this.compose = compose;
    }
}

