/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml;

import java.util.Map;
import java.util.TimeZone;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Tag;

public final class DumperOptions {
    private ScalarStyle defaultStyle = ScalarStyle.PLAIN;
    private FlowStyle defaultFlowStyle = FlowStyle.AUTO;
    private boolean canonical = false;
    private boolean allowUnicode = true;
    private boolean allowReadOnlyProperties = false;
    private int indent = 2;
    private int bestWidth = 80;
    private LineBreak lineBreak = LineBreak.UNIX;
    private boolean explicitStart = false;
    private boolean explicitEnd = false;
    private TimeZone timeZone = null;
    private Tag explicitRoot = null;
    private Version version = null;
    private Map<String, String> tags = null;
    private Boolean prettyFlow = false;

    public final boolean isAllowUnicode() {
        return this.allowUnicode;
    }

    public final ScalarStyle getDefaultScalarStyle() {
        return this.defaultStyle;
    }

    public final int getIndent() {
        return this.indent;
    }

    public final boolean isPrettyFlow() {
        return this.prettyFlow;
    }

    public final int getWidth() {
        return this.bestWidth;
    }

    public final LineBreak getLineBreak() {
        return this.lineBreak;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDefaultFlowStyle(FlowStyle defaultFlowStyle) {
        void var1_1;
        if (defaultFlowStyle == null) {
            throw new NullPointerException("Use FlowStyle enum.");
        }
        this.defaultFlowStyle = var1_1;
    }

    public final FlowStyle getDefaultFlowStyle() {
        return this.defaultFlowStyle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Version
    extends Enum<Version> {
        public static final /* enum */ Version V1_0 = new Version(new Integer[]{1, 0});
        public static final /* enum */ Version V1_1 = new Version(new Integer[]{1, 1});
        private Integer[] version;

        /*
         * WARNING - void declaration
         */
        private Version(Integer[] version) {
            void var3_3;
            this.version = var3_3;
        }

        public final Integer[] getArray() {
            return this.version;
        }

        public final String getRepresentation() {
            return this.version[0] + "." + this.version[1];
        }

        public final String toString() {
            return "Version: " + this.getRepresentation();
        }

        static {
            Version[] versionArray = new Version[]{V1_0, V1_1};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LineBreak
    extends Enum<LineBreak> {
        private static /* enum */ LineBreak WIN = new LineBreak("\r\n");
        private static /* enum */ LineBreak MAC = new LineBreak("\r");
        public static final /* enum */ LineBreak UNIX = new LineBreak("\n");
        private String lineBreak;

        /*
         * WARNING - void declaration
         */
        private LineBreak(String lineBreak) {
            void var3_3;
            this.lineBreak = var3_3;
        }

        public final String getString() {
            return this.lineBreak;
        }

        public final String toString() {
            return "Line break: " + this.name();
        }

        static {
            LineBreak[] lineBreakArray = new LineBreak[]{WIN, MAC, UNIX};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FlowStyle
    extends Enum<FlowStyle> {
        private static /* enum */ FlowStyle FLOW = new FlowStyle(Boolean.TRUE);
        public static final /* enum */ FlowStyle BLOCK = new FlowStyle(Boolean.FALSE);
        public static final /* enum */ FlowStyle AUTO = new FlowStyle(null);
        private Boolean styleBoolean;

        /*
         * WARNING - void declaration
         */
        private FlowStyle(Boolean flowStyle) {
            void var3_3;
            this.styleBoolean = var3_3;
        }

        public final Boolean getStyleBoolean() {
            return this.styleBoolean;
        }

        public final String toString() {
            return "Flow style: '" + this.styleBoolean + "'";
        }

        static {
            FlowStyle[] flowStyleArray = new FlowStyle[]{FLOW, BLOCK, AUTO};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ScalarStyle
    extends Enum<ScalarStyle> {
        private static /* enum */ ScalarStyle DOUBLE_QUOTED = new ScalarStyle(Character.valueOf('\"'));
        private static /* enum */ ScalarStyle SINGLE_QUOTED = new ScalarStyle(Character.valueOf('\''));
        private static /* enum */ ScalarStyle LITERAL = new ScalarStyle(Character.valueOf('|'));
        private static /* enum */ ScalarStyle FOLDED = new ScalarStyle(Character.valueOf('>'));
        public static final /* enum */ ScalarStyle PLAIN = new ScalarStyle(null);
        private Character styleChar;

        /*
         * WARNING - void declaration
         */
        private ScalarStyle(Character style) {
            void var3_3;
            this.styleChar = var3_3;
        }

        public final Character getChar() {
            return this.styleChar;
        }

        public final String toString() {
            return "Scalar style: '" + this.styleChar + "'";
        }

        public static ScalarStyle createStyle(Character style) {
            Character c;
            if (style == null) {
                return PLAIN;
            }
            switch (style.charValue()) {
                case '\"': {
                    return DOUBLE_QUOTED;
                }
                case '\'': {
                    return SINGLE_QUOTED;
                }
                case '|': {
                    return LITERAL;
                }
                case '>': {
                    return FOLDED;
                }
            }
            throw new YAMLException("Unknown scalar style character: " + c);
        }

        static {
            ScalarStyle[] scalarStyleArray = new ScalarStyle[]{DOUBLE_QUOTED, SINGLE_QUOTED, LITERAL, FOLDED, PLAIN};
        }
    }
}

