/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.EntityMap;
import net.md_5.bungee.GenericConnection;
import net.md_5.bungee.KickException;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.command.CommandSender;
import net.md_5.bungee.packet.DefinedPacket;
import net.md_5.bungee.packet.Packet10HeldItem;
import net.md_5.bungee.packet.Packet1Login;
import net.md_5.bungee.packet.Packet2Handshake;
import net.md_5.bungee.packet.Packet3Chat;
import net.md_5.bungee.packet.Packet46GameState;
import net.md_5.bungee.packet.Packet9Respawn;
import net.md_5.bungee.packet.PacketFAPluginMessage;
import net.md_5.bungee.packet.PacketInputStream;

public class UserConnection
extends GenericConnection
implements CommandSender {
    public final Packet2Handshake handshake;
    public Queue<DefinedPacket> packetQueue = new ConcurrentLinkedQueue<DefinedPacket>();
    private ServerConnection server;
    private UpstreamBridge upBridge;
    private DownstreamBridge downBridge;
    private Packet10HeldItem heldItem;
    private int clientEntityId;
    private int serverEntityId;
    private volatile boolean reconnecting;

    /*
     * WARNING - void declaration
     */
    public UserConnection(Socket socket, PacketInputStream in, OutputStream out, Packet2Handshake handshake) {
        super((Socket)var1_1, (PacketInputStream)var2_2, (OutputStream)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.handshake = handshake;
        this.username = handshake.username;
        BungeeCord.instance.connections.put(this.username, this);
    }

    /*
     * WARNING - void declaration
     */
    public void connect(String server) {
        void var2_2;
        void var1_1;
        InetSocketAddress addr = BungeeCord.instance.config.getServer(server);
        this.connect((String)var1_1, (InetSocketAddress)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void connect(String name, InetSocketAddress serverAddr) {
        try {
            this.reconnecting = true;
            if (this.server != null) {
                this.out.write(new Packet9Respawn(1, 0, 0, 256, "DEFAULT").getPacket());
                this.out.write(new Packet9Respawn(-1, 0, 0, 256, "DEFAULT").getPacket());
            }
            ServerConnection newServer = ServerConnection.connect(name, serverAddr, this.handshake, this.server == null);
            if (this.server == null) {
                this.clientEntityId = newServer.loginPacket.entityId;
                this.serverEntityId = newServer.loginPacket.entityId;
                this.out.write(newServer.loginPacket.getPacket());
                this.upBridge = new UpstreamBridge();
                this.upBridge.start();
            } else {
                void var2_4;
                try {
                    this.downBridge.interrupt();
                    this.downBridge.join();
                }
                catch (InterruptedException interruptedException) {}
                this.server.disconnect("Quitting");
                Packet1Login login = newServer.loginPacket;
                this.serverEntityId = login.entityId;
                this.out.write(new Packet9Respawn(login.dimension, login.difficulty, login.gameMode, 256, var2_4.levelType).getPacket());
                this.out.write(new Packet46GameState(2, 0).getPacket());
                if (this.heldItem != null) {
                    newServer.out.write(this.heldItem.getPacket());
                }
            }
            this.reconnecting = false;
            this.downBridge = new DownstreamBridge();
            this.server = newServer;
            this.downBridge.start();
            return;
        }
        catch (KickException ex) {
            void var1_2;
            this.destroySelf(var1_2.getMessage());
            return;
        }
        catch (Exception exception) {
            this.destroySelf("Could not connect to server");
            return;
        }
    }

    public SocketAddress getAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    /*
     * WARNING - void declaration
     */
    private void destroySelf(String reason) {
        void var1_1;
        if (BungeeCord.instance.isRunning) {
            BungeeCord.instance.connections.remove(this.username);
        }
        this.disconnect((String)var1_1);
        if (this.server != null) {
            this.server.disconnect("Quitting");
            BungeeCord.instance.config.setServer(this, this.server.name);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sendMessage(String message) {
        void var1_1;
        this.packetQueue.add(new Packet3Chat((String)var1_1));
    }

    @Override
    public String getName() {
        return this.username;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Packet10HeldItem access$002(UserConnection x0, Packet10HeldItem x1) {
        void var1_1;
        x0.heldItem = var1_1;
        return x0.heldItem;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(UserConnection x0, String x1) {
        void var1_1;
        x0.destroySelf((String)var1_1);
    }

    class DownstreamBridge
    extends Thread {
        public DownstreamBridge() {
            super("Downstream Bridge - " + UserConnection.this.username);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            try {
                String server;
                PacketFAPluginMessage message;
                block6: {
                    while (!UserConnection.this.reconnecting) {
                        byte[] packet = ((UserConnection)UserConnection.this).server.in.readPacket();
                        int n = Util.getId(packet);
                        if (n == 250) {
                            message = new PacketFAPluginMessage(packet);
                            if (message.tag.equals("RubberBand")) break block6;
                        }
                        while (!UserConnection.this.packetQueue.isEmpty()) {
                            void var2_5;
                            DefinedPacket p = UserConnection.this.packetQueue.poll();
                            if (p == null) continue;
                            UserConnection.this.out.write(var2_5.getPacket());
                        }
                        EntityMap.rewrite((byte[])server, UserConnection.this.serverEntityId, UserConnection.this.clientEntityId);
                        UserConnection.this.out.write((byte[])server);
                    }
                    return;
                }
                server = new String(message.data);
                UserConnection.this.connect(server);
            }
            catch (Exception ex) {
                void var1_2;
                UserConnection.access$400(UserConnection.this, Util.exception((Throwable)var1_2));
            }
        }
    }

    class UpstreamBridge
    extends Thread {
        public UpstreamBridge() {
            super("Upstream Bridge - " + UserConnection.this.username);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            while (!UserConnection.this.socket.isClosed()) {
                try {
                    void var2_3;
                    void var3_4;
                    byte[] packet = UserConnection.this.in.readPacket();
                    boolean sendPacket = true;
                    int id2 = Util.getId(packet);
                    if (id2 == 3) {
                        Packet3Chat id2 = new Packet3Chat(packet);
                        String message = id2.message;
                        if (message.startsWith("/")) {
                            void var3_5;
                            sendPacket = !BungeeCord.instance.dispatchCommand(var3_5.substring(1), UserConnection.this);
                        }
                    } else if (var3_4 == 16) {
                        UserConnection.access$002(UserConnection.this, new Packet10HeldItem(packet));
                    }
                    EntityMap.rewrite(packet, UserConnection.this.clientEntityId, UserConnection.this.serverEntityId);
                    if (var2_3 == false || ((UserConnection)UserConnection.this).server.socket.isClosed()) continue;
                    ((UserConnection)UserConnection.this).server.out.write(packet);
                }
                catch (IOException iOException) {
                    UserConnection.access$400(UserConnection.this, "Reached end of stream");
                }
                catch (Exception ex) {
                    void var1_2;
                    UserConnection.access$400(UserConnection.this, Util.exception((Throwable)var1_2));
                }
            }
        }
    }
}

