/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.serializer;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.emitter.Emitable;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ImplicitTuple;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;
import org.yaml.snakeyaml.nodes.AnchorNode;
import org.yaml.snakeyaml.nodes.CollectionNode;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.resolver.Resolver;
import org.yaml.snakeyaml.serializer.SerializerException;

public final class Serializer {
    private final Emitable emitter;
    private final Resolver resolver;
    private boolean explicitStart;
    private boolean explicitEnd;
    private DumperOptions.Version useVersion;
    private Map<String, String> useTags;
    private Set<Node> serializedNodes;
    private Map<Node, String> anchors;
    private int lastAnchorId;
    private Boolean closed;
    private Tag explicitRoot;

    /*
     * WARNING - void declaration
     */
    public Serializer(Emitable emitter, Resolver resolver, DumperOptions opts, Tag rootTag) {
        void var3_3;
        void var2_2;
        DumperOptions dumperOptions;
        this.emitter = dumperOptions;
        this.resolver = var2_2;
        dumperOptions = opts;
        this.explicitStart = false;
        dumperOptions = opts;
        this.explicitEnd = false;
        dumperOptions = opts;
        dumperOptions = var3_3;
        this.useTags = null;
        this.serializedNodes = new HashSet<Node>();
        this.anchors = new HashMap<Node, String>();
        this.lastAnchorId = 0;
        this.closed = null;
        this.explicitRoot = rootTag;
    }

    public final void open() throws IOException {
        if (this.closed == null) {
            this.emitter.emit(new StreamStartEvent(null, null));
            this.closed = Boolean.FALSE;
            return;
        }
        if (Boolean.TRUE.equals(this.closed)) {
            throw new SerializerException("serializer is closed");
        }
        throw new SerializerException("serializer is already opened");
    }

    public final void close() throws IOException {
        if (this.closed == null) {
            throw new SerializerException("serializer is not opened");
        }
        if (!Boolean.TRUE.equals(this.closed)) {
            this.emitter.emit(new StreamEndEvent(null, null));
            this.closed = Boolean.TRUE;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void serialize(Node node) throws IOException {
        void var1_1;
        if (this.closed == null) {
            throw new SerializerException("serializer is not opened");
        }
        if (this.closed.booleanValue()) {
            throw new SerializerException("serializer is closed");
        }
        this.emitter.emit(new DocumentStartEvent(null, null, this.explicitStart, this.useVersion, this.useTags));
        this.anchorNode(node);
        if (this.explicitRoot != null) {
            node.setTag(this.explicitRoot);
        }
        this.serializeNode$130992cb((Node)var1_1);
        this.emitter.emit(new DocumentEndEvent(null, null, this.explicitEnd));
        this.serializedNodes.clear();
        this.anchors.clear();
        this.lastAnchorId = 0;
    }

    /*
     * WARNING - void declaration
     */
    private void anchorNode(Node node) {
        if (((Node)node).getNodeId() == NodeId.anchor) {
            node = ((AnchorNode)node).getRealNode();
        }
        if (this.anchors.containsKey(node)) {
            Object anchor = this.anchors.get(node);
            if (anchor == null) {
                anchor = this;
                ++((Serializer)anchor).lastAnchorId;
                NumberFormat numberFormat = NumberFormat.getNumberInstance();
                numberFormat.setMinimumIntegerDigits(3);
                numberFormat.setGroupingUsed(false);
                anchor = numberFormat.format(((Serializer)anchor).lastAnchorId);
                anchor = "id" + (String)anchor;
                this.anchors.put((Node)node, (String)anchor);
            }
            return;
        }
        this.anchors.put((Node)node, null);
        switch (((Node)node).getNodeId()) {
            case sequence: {
                SequenceNode anchor = (SequenceNode)node;
                node = anchor.getValue();
                Iterator<NodeTuple> i$ = node.iterator();
                while (i$.hasNext()) {
                    Node item = (Node)((Object)i$.next());
                    this.anchorNode(item);
                }
                return;
            }
            case mapping: {
                Iterator<NodeTuple> i$;
                i$ = (MappingNode)((Object)i$);
                List<NodeTuple> item = ((MappingNode)((Object)i$)).getValue();
                for (NodeTuple object : item) {
                    void var2_4;
                    void var3_6;
                    Node key = object.getKeyNode();
                    Node value = object.getValueNode();
                    this.anchorNode((Node)var3_6);
                    this.anchorNode((Node)var2_4);
                }
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void serializeNode$130992cb(Node node) throws IOException {
        Object event;
        if (node.getNodeId() == NodeId.anchor) {
            node = ((AnchorNode)node).getRealNode();
        }
        String tAlias = this.anchors.get(node);
        if (this.serializedNodes.contains(node)) {
            this.emitter.emit(new AliasEvent(tAlias, null, null));
            return;
        }
        this.serializedNodes.add(node);
        switch (node.getNodeId()) {
            case scalar: {
                ScalarNode scalarNode = (ScalarNode)node;
                Tag detectedTag = this.resolver.resolve(NodeId.scalar, scalarNode.getValue(), true);
                Tag defaultTag = this.resolver.resolve(NodeId.scalar, scalarNode.getValue(), false);
                ImplicitTuple tuple = new ImplicitTuple(node.getTag().equals(detectedTag), node.getTag().equals(defaultTag));
                event = new ScalarEvent(tAlias, node.getTag().getValue(), tuple, scalarNode.getValue(), null, null, scalarNode.getStyle());
                this.emitter.emit((Event)event);
                return;
            }
            case sequence: {
                SequenceNode seqNode = (SequenceNode)event;
                boolean implicitS = ((Node)event).getTag().equals(this.resolver.resolve(NodeId.sequence, null, true));
                this.emitter.emit(new SequenceStartEvent(tAlias, ((Node)event).getTag().getValue(), implicitS, null, null, seqNode.getFlowStyle()));
                event = seqNode.getValue();
                Iterator<Node> i$ = event.iterator();
                while (i$.hasNext()) {
                    Node item = i$.next();
                    this.serializeNode$130992cb(item);
                }
                this.emitter.emit(new SequenceEndEvent(null, null));
                return;
            }
        }
        Tag implicitTag = this.resolver.resolve(NodeId.mapping, null, true);
        boolean implicitM = ((Node)event).getTag().equals(implicitTag);
        this.emitter.emit(new MappingStartEvent(tAlias, ((Node)event).getTag().getValue(), implicitM, null, null, ((CollectionNode)event).getFlowStyle()));
        event = (MappingNode)event;
        event = ((MappingNode)event).getValue();
        Iterator<NodeTuple> i$ = event.iterator();
        while (i$.hasNext()) {
            void var2_2;
            void var3_5;
            NodeTuple row = i$.next();
            Node key = row.getKeyNode();
            Node value = row.getValueNode();
            this.serializeNode$130992cb((Node)var3_5);
            this.serializeNode$130992cb((Node)var2_2);
        }
        this.emitter.emit(new MappingEndEvent(null, null));
    }
}

