/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.resolver.ResolverTuple;

public final class Resolver {
    private static Pattern BOOL = Pattern.compile("^(?:yes|Yes|YES|no|No|NO|true|True|TRUE|false|False|FALSE|on|On|ON|off|Off|OFF)$");
    private static Pattern FLOAT = Pattern.compile("^([-+]?(\\.[0-9]+|[0-9_]+(\\.[0-9_]*)?)([eE][-+]?[0-9]+)?|[-+]?[0-9][0-9_]*(?::[0-5]?[0-9])+\\.[0-9_]*|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$");
    private static Pattern INT = Pattern.compile("^(?:[-+]?0b[0-1_]+|[-+]?0[0-7_]+|[-+]?(?:0|[1-9][0-9_]*)|[-+]?0x[0-9a-fA-F_]+|[-+]?[1-9][0-9_]*(?::[0-5]?[0-9])+)$");
    private static Pattern MERGE = Pattern.compile("^(?:<<)$");
    private static Pattern NULL = Pattern.compile("^(?:~|null|Null|NULL| )$");
    private static Pattern EMPTY = Pattern.compile("^$");
    private static Pattern TIMESTAMP = Pattern.compile("^(?:[0-9][0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9]|[0-9][0-9][0-9][0-9]-[0-9][0-9]?-[0-9][0-9]?(?:[Tt]|[ \t]+)[0-9][0-9]?:[0-9][0-9]:[0-9][0-9](?:\\.[0-9]*)?(?:[ \t]*(?:Z|[-+][0-9][0-9]?(?::[0-9][0-9])?))?)$");
    private static Pattern VALUE = Pattern.compile("^(?:=)$");
    private static Pattern YAML = Pattern.compile("^(?:!|&|\\*)$");
    private Map<Character, List<ResolverTuple>> yamlImplicitResolvers = new HashMap<Character, List<ResolverTuple>>();

    private Resolver(boolean respectDefaultImplicitScalars) {
        Resolver resolver = this;
        resolver.addImplicitResolver(Tag.BOOL, BOOL, "yYnNtTfFoO");
        resolver.addImplicitResolver(Tag.INT, INT, "-+0123456789");
        resolver.addImplicitResolver(Tag.FLOAT, FLOAT, "-+0123456789.");
        resolver.addImplicitResolver(Tag.MERGE, MERGE, "<");
        resolver.addImplicitResolver(Tag.NULL, NULL, "~nN\u0000");
        resolver.addImplicitResolver(Tag.NULL, EMPTY, null);
        resolver.addImplicitResolver(Tag.TIMESTAMP, TIMESTAMP, "0123456789");
        resolver.addImplicitResolver(Tag.VALUE, VALUE, "=");
        resolver.addImplicitResolver(Tag.YAML, YAML, "!&*");
    }

    public Resolver() {
        this(true);
    }

    private void addImplicitResolver(Tag tag, Pattern regexp, String first) {
        List<ResolverTuple> curr;
        if (first == null) {
            curr = this.yamlImplicitResolvers.get(null);
            if (curr == null) {
                curr = new ArrayList<ResolverTuple>();
                this.yamlImplicitResolvers.put(null, curr);
            }
            curr.add(new ResolverTuple(tag, regexp));
            return;
        }
        char[] chrs = ((String)((Object)curr)).toCharArray();
        int j = chrs.length;
        for (int i = 0; i < j; ++i) {
            List<ResolverTuple> curr2;
            Character theC = Character.valueOf(chrs[i]);
            if (theC.charValue() == '\u0000') {
                theC = null;
            }
            if ((curr2 = this.yamlImplicitResolvers.get(theC)) == null) {
                curr2 = new ArrayList<ResolverTuple>();
                this.yamlImplicitResolvers.put(theC, curr2);
            }
            curr2.add(new ResolverTuple(tag, regexp));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Tag resolve(NodeId kind, String value, boolean implicit) {
        void var1_1;
        if (kind == NodeId.scalar && implicit) {
            Tag tag;
            List<ResolverTuple> resolvers = value.length() == 0 ? this.yamlImplicitResolvers.get(Character.valueOf('\u0000')) : this.yamlImplicitResolvers.get(Character.valueOf(value.charAt(0)));
            if (resolvers != null) {
                for (ResolverTuple resolverTuple : resolvers) {
                    tag = resolverTuple.getTag();
                    Pattern pattern = resolverTuple.getRegexp();
                    if (!pattern.matcher(value).matches()) continue;
                    return tag;
                }
            }
            if (this.yamlImplicitResolvers.containsKey(null)) {
                for (ResolverTuple resolverTuple : this.yamlImplicitResolvers.get(null)) {
                    tag = resolverTuple.getTag();
                    Pattern pattern = resolverTuple.getRegexp();
                    if (!pattern.matcher(value).matches()) continue;
                    return tag;
                }
            }
        }
        switch (1.$SwitchMap$org$yaml$snakeyaml$nodes$NodeId[var1_1.ordinal()]) {
            case 1: {
                return Tag.STR;
            }
            case 2: {
                return Tag.SEQ;
            }
        }
        return Tag.MAP;
    }

    static final class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$yaml$snakeyaml$nodes$NodeId;

        static {
            $SwitchMap$org$yaml$snakeyaml$nodes$NodeId = new int[NodeId.values().length];
            try {
                1.$SwitchMap$org$yaml$snakeyaml$nodes$NodeId[NodeId.scalar.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$SwitchMap$org$yaml$snakeyaml$nodes$NodeId[NodeId.sequence.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

