/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.constructor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Constructor
extends SafeConstructor {
    private final Map<Tag, Class<? extends Object>> typeTags;
    private final Map<Class<? extends Object>, TypeDescription> typeDefinitions;

    public Constructor() {
        this(Object.class);
    }

    /*
     * WARNING - void declaration
     */
    private Constructor(Class<? extends Object> theRoot) {
        void var1_1;
        if (var1_1 == null) {
            throw new NullPointerException("Root class must be provided.");
        }
        this(new TypeDescription((Class<? extends Object>)var1_1));
    }

    private Constructor(TypeDescription theRoot) {
        Constructor constructor;
        if (theRoot == null) {
            throw new NullPointerException("Root type must be provided.");
        }
        this.yamlConstructors.put(null, new ConstructYamlObject(this));
        if (!Object.class.equals(theRoot.getType())) {
            this.rootTag = new Tag(theRoot.getType());
        }
        this.typeTags = new HashMap<Tag, Class<? extends Object>>();
        this.typeDefinitions = new HashMap<Class<? extends Object>, TypeDescription>();
        this.yamlClassConstructors.put(NodeId.scalar, new ConstructScalar(this));
        this.yamlClassConstructors.put(NodeId.mapping, new ConstructMapping(this));
        this.yamlClassConstructors.put(NodeId.sequence, new ConstructSequence(this));
        void var2_2 = constructor;
        constructor = this;
        if (var2_2 == null) {
            throw new NullPointerException("TypeDescription is required.");
        }
        Tag tag = var2_2.getTag();
        constructor.typeTags.put(tag, var2_2.getType());
        constructor.typeDefinitions.put(var2_2.getType(), (TypeDescription)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected final Class<?> getClassForNode(Node node) {
        void var2_2;
        Class<? extends Object> classForTag = this.typeTags.get(node.getTag());
        if (classForTag == null) {
            void var1_1;
            Class<?> cl;
            String string;
            String name = node.getTag().getClassName();
            try {
                string = name;
                cl = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new YAMLException("Class not found: " + (String)var2_2);
            }
            this.typeTags.put(var1_1.getTag(), cl);
            return string;
        }
        return var2_2;
    }

    public final class ConstructSequence
    implements Construct {
        private /* synthetic */ Constructor this$0;

        protected ConstructSequence(Constructor constructor) {
            this.this$0 = constructor;
        }

        /*
         * WARNING - void declaration
         */
        public final Object construct(Node node) {
            void var1_1;
            void var2_2;
            SequenceNode snode = (SequenceNode)node;
            if (Set.class.isAssignableFrom(node.getType())) {
                if (node.isTwoStepsConstruction()) {
                    throw new YAMLException("Set cannot be recursive.");
                }
                return this.this$0.constructSet(snode);
            }
            if (Collection.class.isAssignableFrom(node.getType())) {
                if (node.isTwoStepsConstruction()) {
                    return Constructor.createDefaultList(snode.getValue().size());
                }
                return this.this$0.constructSequence(snode);
            }
            if (node.getType().isArray()) {
                if (node.isTwoStepsConstruction()) {
                    return Constructor.createArray(node.getType(), snode.getValue().size());
                }
                return this.this$0.constructArray(snode);
            }
            ArrayList possibleConstructors = new ArrayList(snode.getValue().size());
            for (java.lang.reflect.Constructor<?> constructor : node.getType().getConstructors()) {
                if (snode.getValue().size() != constructor.getParameterTypes().length) continue;
                possibleConstructors.add(constructor);
            }
            if (!possibleConstructors.isEmpty()) {
                Class<?> type;
                int index;
                Object argumentList;
                if (possibleConstructors.size() == 1) {
                    argumentList = new Object[snode.getValue().size()];
                    java.lang.reflect.Constructor c = (java.lang.reflect.Constructor)possibleConstructors.get(0);
                    index = 0;
                    for (Node argumentNode : snode.getValue()) {
                        type = c.getParameterTypes()[index];
                        argumentNode.setType(type);
                        argumentList[index++] = this.this$0.constructObject(argumentNode);
                    }
                    try {
                        return c.newInstance((Object[])argumentList);
                    }
                    catch (Exception e) {
                        throw new YAMLException(e);
                    }
                }
                argumentList = this.this$0.constructSequence(snode);
                Class[] parameterTypes = new Class[argumentList.size()];
                index = 0;
                Iterator<Object> i$ = argumentList.iterator();
                while (i$.hasNext()) {
                    Object parameter = i$.next();
                    parameterTypes[index] = parameter.getClass();
                    ++index;
                }
                i$ = type.iterator();
                while (i$.hasNext()) {
                    java.lang.reflect.Constructor c = (java.lang.reflect.Constructor)i$.next();
                    Class<?>[] argTypes = c.getParameterTypes();
                    boolean foundConstructor = true;
                    for (int i = 0; i < argTypes.length; ++i) {
                        Class<Object> clazz;
                        Class<?> clazz2 = argTypes[i];
                        if (!clazz2.isPrimitive()) {
                            clazz = clazz2;
                        } else if (clazz2 == Integer.TYPE) {
                            clazz = Integer.class;
                        } else if (clazz2 == Float.TYPE) {
                            clazz = Float.class;
                        } else if (clazz2 == Double.TYPE) {
                            clazz = Double.class;
                        } else if (clazz2 == Boolean.TYPE) {
                            clazz = Boolean.class;
                        } else if (clazz2 == Long.TYPE) {
                            clazz = Long.class;
                        } else if (clazz2 == Character.TYPE) {
                            clazz = Character.class;
                        } else if (clazz2 == Short.TYPE) {
                            clazz = Short.class;
                        } else if (clazz2 == Byte.TYPE) {
                            clazz = Byte.class;
                        } else {
                            throw new YAMLException("Unexpected primitive " + clazz2);
                        }
                        if (clazz.isAssignableFrom(parameterTypes[i])) continue;
                        foundConstructor = false;
                        break;
                    }
                    if (!foundConstructor) continue;
                    try {
                        return c.newInstance(argumentList.toArray());
                    }
                    catch (Exception e) {
                        throw new YAMLException(e);
                    }
                }
            }
            throw new YAMLException("No suitable constructor with " + String.valueOf(var2_2.getValue().size()) + " arguments found for " + var1_1.getType());
        }

        /*
         * WARNING - void declaration
         */
        public final void construct2ndStep(Node node, Object object) {
            void var1_1;
            SequenceNode snode = (SequenceNode)node;
            if (List.class.isAssignableFrom(node.getType())) {
                List list = (List)object;
                this.this$0.constructSequenceStep2(snode, (Collection<Object>)var1_1);
                return;
            }
            if (var1_1.getType().isArray()) {
                void var2_2;
                void var3_3;
                this.this$0.constructArrayStep2((SequenceNode)var3_3, var2_2);
                return;
            }
            throw new YAMLException("Immutable objects cannot be recursive.");
        }
    }

    public final class ConstructScalar
    extends AbstractConstruct {
        private /* synthetic */ Constructor this$0;

        protected ConstructScalar(Constructor constructor) {
            this.this$0 = constructor;
        }

        /*
         * WARNING - void declaration
         */
        public final Object construct(Node nnode) {
            void var2_2;
            Object result;
            ScalarNode node = (ScalarNode)nnode;
            Class<? extends Object> type = node.getType();
            if (type.isPrimitive() || type == String.class || Number.class.isAssignableFrom(type) || type == Boolean.class || Date.class.isAssignableFrom(type) || type == Character.class || type == BigInteger.class || type == BigDecimal.class || Enum.class.isAssignableFrom(type) || Tag.BINARY.equals(node.getTag()) || Calendar.class.isAssignableFrom(type)) {
                result = this.constructStandardJavaInstance(type, node);
            } else {
                Object argument;
                java.lang.reflect.Constructor<?>[] javaConstructors = ((Class)result).getConstructors();
                int oneArgCount = 0;
                java.lang.reflect.Constructor<Object> javaConstructor = null;
                java.lang.reflect.Constructor<?>[] arr$ = javaConstructors;
                int len$ = javaConstructors.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    java.lang.reflect.Constructor<?> c = arr$[i$];
                    if (c.getParameterTypes().length != 1) continue;
                    ++oneArgCount;
                    javaConstructor = c;
                }
                if (javaConstructor == null) {
                    throw new YAMLException("No single argument constructor found for " + result);
                }
                if (oneArgCount == 1) {
                    argument = this.constructStandardJavaInstance(javaConstructor.getParameterTypes()[0], node);
                } else {
                    argument = node;
                    argument = ((ScalarNode)argument).getValue();
                    try {
                        javaConstructor = ((Class)result).getConstructor(String.class);
                    }
                    catch (Exception e) {
                        throw new YAMLException("Can't construct a java object for scalar " + node.getTag() + "; No String constructor found. Exception=" + e.getMessage(), e);
                    }
                }
                try {
                    void var3_3;
                    result = javaConstructor.newInstance(var3_3);
                }
                catch (Exception e) {
                    void var1_1;
                    throw new ConstructorException(null, null, "Can't construct a java object for scalar " + node.getTag() + "; exception=" + e.getMessage(), var1_1.getStartMark(), e);
                }
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private Object constructStandardJavaInstance(Class type, ScalarNode node) {
            void var2_2;
            Object result;
            if (type == String.class) {
                Construct construct = (Construct)this.this$0.yamlConstructors.get(Tag.STR);
                result = construct.construct(node);
            } else if (type == Boolean.class || type == Boolean.TYPE) {
                Construct construct = (Construct)this.this$0.yamlConstructors.get(Tag.BOOL);
                result = construct.construct((Node)result);
            } else if (type == Character.class || type == Character.TYPE) {
                Construct construct = (Construct)this.this$0.yamlConstructors.get(Tag.STR);
                String ch = (String)construct.construct((Node)result);
                if (ch.length() == 0) {
                    result = null;
                } else {
                    if (((String)result).length() != 1) {
                        throw new YAMLException("Invalid node Character: '" + (String)result + "'; length: " + ((String)result).length());
                    }
                    result = Character.valueOf(((String)result).charAt(0));
                }
            } else if (Date.class.isAssignableFrom(type)) {
                Object object = (Construct)this.this$0.yamlConstructors.get(Tag.TIMESTAMP);
                Date date = (Date)object.construct((Node)result);
                if (type != Date.class) {
                    try {
                        object = type.getConstructor(Long.TYPE);
                        result = ((java.lang.reflect.Constructor)object).newInstance(((Date)result).getTime());
                    }
                    catch (Exception exception) {
                        throw new YAMLException("Cannot construct: '" + type + "'");
                    }
                }
            } else if (type == Float.class || type == Double.class || type == Float.TYPE || type == Double.TYPE || type == BigDecimal.class) {
                if (type == BigDecimal.class) {
                    result = new BigDecimal(((ScalarNode)result).getValue());
                } else {
                    Construct construct = (Construct)this.this$0.yamlConstructors.get(Tag.FLOAT);
                    result = construct.construct((Node)result);
                    if (type == Float.class || type == Float.TYPE) {
                        result = new Float((Double)result);
                    }
                }
            } else if (type == Byte.class || type == Short.class || type == Integer.class || type == Long.class || type == BigInteger.class || type == Byte.TYPE || type == Short.TYPE || type == Integer.TYPE || type == Long.TYPE) {
                Construct construct = (Construct)this.this$0.yamlConstructors.get(Tag.INT);
                result = construct.construct((Node)result);
                result = type == Byte.class || type == Byte.TYPE ? (Number)new Byte(result.toString()) : (Number)(type == Short.class || type == Short.TYPE ? (Number)new Short(result.toString()) : (Number)(type == Integer.class || type == Integer.TYPE ? (Number)Integer.parseInt(result.toString()) : (Number)(type == Long.class || type == Long.TYPE ? new Long(result.toString()) : new BigInteger(result.toString()))));
            } else if (Enum.class.isAssignableFrom(type)) {
                String enumValueName = ((ScalarNode)result).getValue();
                try {
                    result = Enum.valueOf(type, enumValueName);
                }
                catch (Exception exception) {
                    throw new YAMLException("Unable to find enum value '" + enumValueName + "' for enum class: " + type.getName());
                }
            } else if (Calendar.class.isAssignableFrom(type)) {
                void var3_10;
                SafeConstructor.ConstructYamlTimestamp contr = new SafeConstructor.ConstructYamlTimestamp();
                contr.construct((Node)result);
                result = var3_10.getCalendar();
            } else {
                void var1_1;
                throw new YAMLException("Unsupported class: " + var1_1);
            }
            return var2_2;
        }
    }

    public final class ConstructYamlObject
    implements Construct {
        private /* synthetic */ Constructor this$0;

        protected ConstructYamlObject(Constructor constructor) {
            this.this$0 = constructor;
        }

        /*
         * WARNING - void declaration
         */
        private Construct getConstructor(Node node) {
            Construct construct;
            void var2_2;
            Class<?> cl = this.this$0.getClassForNode(node);
            node.setType((Class<? extends Object>)var2_2);
            construct = (Construct)this.this$0.yamlClassConstructors.get((Object)((Node)((Object)construct)).getNodeId());
            return construct;
        }

        /*
         * WARNING - void declaration
         */
        public final Object construct(Node node) {
            void var2_2;
            try {
                Object result = this.getConstructor(node).construct(node);
            }
            catch (Exception e) {
                void var2_3;
                void var1_1;
                throw new ConstructorException(null, null, "Can't construct a java object for " + node.getTag() + "; exception=" + e.getMessage(), var1_1.getStartMark(), (Throwable)var2_3);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final void construct2ndStep(Node node, Object object) {
            try {
                this.getConstructor(node).construct2ndStep(node, object);
                return;
            }
            catch (Exception e) {
                void var2_3;
                void var1_1;
                throw new ConstructorException(null, null, "Can't construct a second step for a java object for " + node.getTag() + "; exception=" + e.getMessage(), var1_1.getStartMark(), (Throwable)var2_3);
            }
        }
    }

    public final class ConstructMapping
    implements Construct {
        private /* synthetic */ Constructor this$0;

        protected ConstructMapping(Constructor constructor) {
            this.this$0 = constructor;
        }

        /*
         * WARNING - void declaration
         */
        public final Object construct(Node node) {
            void var2_2;
            void var1_1;
            MappingNode mnode = (MappingNode)node;
            if (Properties.class.isAssignableFrom(node.getType())) {
                Properties properties = new Properties();
                if (node.isTwoStepsConstruction()) {
                    throw new YAMLException("Properties must not be recursive.");
                }
                this.this$0.constructMapping2ndStep(mnode, properties);
                return properties;
            }
            if (SortedMap.class.isAssignableFrom(node.getType())) {
                TreeMap<Object, Object> map = new TreeMap<Object, Object>();
                if (!node.isTwoStepsConstruction()) {
                    this.this$0.constructMapping2ndStep(mnode, map);
                }
                return map;
            }
            if (Map.class.isAssignableFrom(node.getType())) {
                if (node.isTwoStepsConstruction()) {
                    return new LinkedHashMap();
                }
                return this.this$0.constructMapping(mnode);
            }
            if (SortedSet.class.isAssignableFrom(node.getType())) {
                void var3_5;
                TreeSet<Object> set = new TreeSet<Object>();
                this.this$0.constructSet2ndStep(mnode, set);
                return var3_5;
            }
            if (Collection.class.isAssignableFrom(node.getType())) {
                if (node.isTwoStepsConstruction()) {
                    return new LinkedHashSet();
                }
                return this.this$0.constructSet(mnode);
            }
            if (var1_1.isTwoStepsConstruction()) {
                return ConstructMapping.createEmptyJavaBean(mnode);
            }
            return this.constructJavaBean2ndStep(mnode, ConstructMapping.createEmptyJavaBean((MappingNode)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public final void construct2ndStep(Node node, Object object) {
            void var2_2;
            void var1_1;
            if (Map.class.isAssignableFrom(node.getType())) {
                this.this$0.constructMapping2ndStep((MappingNode)node, (Map)object);
                return;
            }
            if (Set.class.isAssignableFrom(node.getType())) {
                this.this$0.constructSet2ndStep((MappingNode)node, (Set)object);
                return;
            }
            this.constructJavaBean2ndStep((MappingNode)var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private static Object createEmptyJavaBean(MappingNode node) {
            try {
                java.lang.reflect.Constructor<? extends Object> c = node.getType().getDeclaredConstructor(new Class[0]);
                c.setAccessible(true);
                return c.newInstance(new Object[0]);
            }
            catch (Exception e) {
                void var0_1;
                throw new YAMLException((Throwable)var0_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        private Object constructJavaBean2ndStep(MappingNode node, Object object) {
            void var2_2;
            this.this$0.flattenMapping((MappingNode)node);
            Class<? extends Object> beanType = ((Node)node).getType();
            node = ((MappingNode)node).getValue();
            Iterator<NodeTuple> i$ = node.iterator();
            while (i$.hasNext()) {
                NodeTuple tuple = i$.next();
                if (!(tuple.getKeyNode() instanceof ScalarNode)) {
                    throw new YAMLException("Keys must be scalars but found: " + tuple.getKeyNode());
                }
                ScalarNode keyNode = (ScalarNode)tuple.getKeyNode();
                Node valueNode = tuple.getValueNode();
                keyNode.setType(String.class);
                String key = (String)this.this$0.constructObject(keyNode);
                try {
                    Object arguments;
                    MappingNode mnode;
                    String string = key;
                    Class<? extends Object> clazz = beanType;
                    ConstructMapping constructMapping = this;
                    Property property = constructMapping.this$0.getPropertyUtils().getProperty(clazz, string);
                    valueNode.setType(property.getType());
                    TypeDescription memberDescription = (TypeDescription)this.this$0.typeDefinitions.get(beanType);
                    boolean typeDetected = false;
                    if (memberDescription != null) {
                        switch (valueNode.getNodeId()) {
                            case sequence: {
                                SequenceNode snode = (SequenceNode)valueNode;
                                Class<? extends Object> memberType = memberDescription.getListPropertyType(key);
                                if (memberType != null) {
                                    snode.setListType(memberType);
                                    typeDetected = true;
                                    break;
                                }
                                if (!property.getType().isArray()) break;
                                snode.setListType(property.getType().getComponentType());
                                typeDetected = true;
                                break;
                            }
                            case mapping: {
                                Class<? extends Object> memberType;
                                mnode = (MappingNode)valueNode;
                                Class<? extends Object> keyType = ((TypeDescription)((Object)memberType)).getMapKeyType(key);
                                if (keyType == null) break;
                                mnode.setTypes(keyType, ((TypeDescription)((Object)memberType)).getMapValueType(key));
                                typeDetected = true;
                            }
                        }
                    }
                    if (!typeDetected && valueNode.getNodeId() != NodeId.scalar && (arguments = property.getActualTypeArguments()) != null && ((Class<?>[])arguments).length > 0) {
                        Class<?> t;
                        if (valueNode.getNodeId() == NodeId.sequence) {
                            t = arguments[0];
                            arguments = (SequenceNode)valueNode;
                            arguments.setListType(t);
                        } else if (valueNode.getTag().equals(Tag.SET)) {
                            t = arguments[0];
                            mnode = (MappingNode)valueNode;
                            mnode.setOnlyKeyType(t);
                            mnode.setUseClassConstructor(true);
                        } else if (property.getType().isAssignableFrom(Map.class)) {
                            MappingNode ketType = mnode[0];
                            MappingNode valueType = mnode[1];
                            MappingNode mnode2 = (MappingNode)valueNode;
                            mnode2.setTypes((Class<? extends Object>)((Object)ketType), (Class<? extends Object>)((Object)valueType));
                            mnode2.setUseClassConstructor(true);
                        }
                    }
                    Object value = this.this$0.constructObject(valueNode);
                    property.set(object, value);
                }
                catch (Exception e) {
                    throw new YAMLException("Cannot create property=" + key + " for JavaBean=" + object + "; " + e.getMessage(), e);
                }
            }
            return var2_2;
        }
    }
}

