/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.representer;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.representer.BaseRepresenter;
import org.yaml.snakeyaml.representer.Represent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SafeRepresenter
extends BaseRepresenter {
    protected Map<Class<? extends Object>, Tag> classTags;
    protected TimeZone timeZone = null;
    public static Pattern MULTILINE_PATTERN = Pattern.compile("\n|\u0085|\u2028|\u2029");

    public SafeRepresenter() {
        this.nullRepresenter = new RepresentNull(this);
        this.representers.put(String.class, new RepresentString(this));
        this.representers.put(Boolean.class, new RepresentBoolean(this));
        this.representers.put(Character.class, new RepresentString(this));
        this.representers.put(byte[].class, new RepresentByteArray(this));
        this.multiRepresenters.put(Number.class, new RepresentNumber(this));
        this.multiRepresenters.put(List.class, new RepresentList(this));
        this.multiRepresenters.put(Map.class, new RepresentMap(this));
        this.multiRepresenters.put(Set.class, new RepresentSet(this));
        this.multiRepresenters.put(Iterator.class, new RepresentIterator(this));
        this.multiRepresenters.put(new Object[0].getClass(), new RepresentArray(this));
        this.multiRepresenters.put(Date.class, new RepresentDate(this));
        this.multiRepresenters.put(Enum.class, new RepresentEnum(this));
        this.multiRepresenters.put(Calendar.class, new RepresentDate(this));
        this.classTags = new HashMap<Class<? extends Object>, Tag>();
    }

    /*
     * WARNING - void declaration
     */
    protected final Tag getTag(Class<?> clazz, Tag defaultTag) {
        void var2_2;
        if (this.classTags.containsKey(clazz)) {
            void var1_1;
            return this.classTags.get(var1_1);
        }
        return var2_2;
    }

    public final TimeZone getTimeZone() {
        return this.timeZone;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTimeZone(TimeZone timeZone) {
        void var1_1;
        this.timeZone = var1_1;
    }

    public final class RepresentByteArray
    implements Represent {
        private /* synthetic */ SafeRepresenter this$0;

        protected RepresentByteArray(SafeRepresenter safeRepresenter) {
            this.this$0 = safeRepresenter;
        }

        /*
         * WARNING - void declaration
         */
        public final Node representData(Object data) {
            void var1_1;
            char[] binary = Base64Coder.encode((byte[])data);
            return this.this$0.representScalar(Tag.BINARY, String.valueOf((char[])var1_1), Character.valueOf('|'));
        }
    }

    public final class RepresentEnum
    implements Represent {
        private /* synthetic */ SafeRepresenter this$0;

        protected RepresentEnum(SafeRepresenter safeRepresenter) {
            this.this$0 = safeRepresenter;
        }

        /*
         * WARNING - void declaration
         */
        public final Node representData(Object data) {
            void var1_1;
            void var2_2;
            Tag tag = new Tag(data.getClass());
            return this.this$0.representScalar(this.this$0.getTag(data.getClass(), (Tag)var2_2), ((Enum)var1_1).name());
        }
    }

    public final class RepresentDate
    implements Represent {
        private /* synthetic */ SafeRepresenter this$0;

        protected RepresentDate(SafeRepresenter safeRepresenter) {
            this.this$0 = safeRepresenter;
        }

        /*
         * WARNING - void declaration
         */
        public final Node representData(Object data) {
            void var3_5;
            void var1_1;
            Calendar calendar;
            if (data instanceof Calendar) {
                calendar = (Calendar)data;
            } else {
                calendar = Calendar.getInstance(this.this$0.getTimeZone() == null ? TimeZone.getTimeZone("UTC") : this.this$0.timeZone);
                calendar.setTime((Date)data);
            }
            int years = calendar.get(1);
            int months = calendar.get(2) + 1;
            int days = calendar.get(5);
            int hour24 = calendar.get(11);
            int minutes = calendar.get(12);
            int seconds = calendar.get(13);
            int millis = calendar.get(14);
            StringBuilder buffer = new StringBuilder(String.valueOf(years));
            while (buffer.length() < 4) {
                buffer.insert(0, "0");
            }
            buffer.append("-");
            if (months < 10) {
                buffer.append("0");
            }
            buffer.append(String.valueOf(months));
            buffer.append("-");
            if (days < 10) {
                buffer.append("0");
            }
            buffer.append(String.valueOf(days));
            buffer.append("T");
            if (hour24 < 10) {
                buffer.append("0");
            }
            buffer.append(String.valueOf(hour24));
            buffer.append(":");
            if (minutes < 10) {
                buffer.append("0");
            }
            buffer.append(String.valueOf(minutes));
            buffer.append(":");
            if (seconds < 10) {
                buffer.append("0");
            }
            buffer.append(String.valueOf(seconds));
            if (millis > 0) {
                if (millis < 10) {
                    buffer.append(".00");
                } else if (millis < 100) {
                    buffer.append(".0");
                } else {
                    buffer.append(".");
                }
                buffer.append(String.valueOf(millis));
            }
            if (TimeZone.getTimeZone("UTC").equals(calendar.getTimeZone())) {
                buffer.append("Z");
            } else {
                void var2_3;
                int calendar2 = calendar.getTimeZone().getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14));
                int minutesOffset = calendar2 / 60000;
                int hoursOffset = minutesOffset / 60;
                int partOfHour = minutesOffset % 60;
                buffer.append((hoursOffset > 0 ? "+" : "") + hoursOffset + ":" + (partOfHour < 10 ? "0" + partOfHour : Integer.valueOf((int)var2_3)));
            }
            return this.this$0.representScalar(this.this$0.getTag(var1_1.getClass(), Tag.TIMESTAMP), var3_5.toString(), null);
        }
    }

    public final class RepresentSet
    implements Represent {
        private /* synthetic */ SafeRepresenter this$0;

        protected RepresentSet(SafeRepresenter safeRepresenter) {
            this.this$0 = safeRepresenter;
        }

        /*
         * WARNING - void declaration
         */
        public final Node representData(Object data) {
            void var2_2;
            void var1_1;
            LinkedHashMap value = new LinkedHashMap();
            Set set = (Set)data;
            for (Object key : set) {
                value.put(key, null);
            }
            return this.this$0.representMapping(this.this$0.getTag(var1_1.getClass(), Tag.SET), (Map<? extends Object, Object>)var2_2, null);
        }
    }

    public final class RepresentMap
    implements Represent {
        private /* synthetic */ SafeRepresenter this$0;

        protected RepresentMap(SafeRepresenter safeRepresenter) {
            this.this$0 = safeRepresenter;
        }

        /*
         * WARNING - void declaration
         */
        public final Node representData(Object data) {
            void var1_1;
            return this.this$0.representMapping(this.this$0.getTag(data.getClass(), Tag.MAP), (Map)var1_1, null);
        }
    }

    public final class RepresentArray
    implements Represent {
        private /* synthetic */ SafeRepresenter this$0;

        protected RepresentArray(SafeRepresenter safeRepresenter) {
            this.this$0 = safeRepresenter;
        }

        /*
         * WARNING - void declaration
         */
        public final Node representData(Object data) {
            void var1_1;
            data = data;
            List<Object> list = Arrays.asList(data);
            return this.this$0.representSequence(Tag.SEQ, (Iterable<? extends Object>)var1_1, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class IteratorWrapper
    implements Iterable<Object> {
        private Iterator<Object> iter;

        /*
         * WARNING - void declaration
         */
        public IteratorWrapper(Iterator<Object> iter) {
            void var1_1;
            this.iter = var1_1;
        }

        @Override
        public final Iterator<Object> iterator() {
            return this.iter;
        }
    }

    public final class RepresentIterator
    implements Represent {
        private /* synthetic */ SafeRepresenter this$0;

        protected RepresentIterator(SafeRepresenter safeRepresenter) {
            this.this$0 = safeRepresenter;
        }

        /*
         * WARNING - void declaration
         */
        public final Node representData(Object data) {
            void var2_2;
            void var1_1;
            Iterator iter = (Iterator)data;
            return this.this$0.representSequence(this.this$0.getTag(var1_1.getClass(), Tag.SEQ), new IteratorWrapper((Iterator<Object>)var2_2), null);
        }
    }

    public final class RepresentList
    implements Represent {
        private /* synthetic */ SafeRepresenter this$0;

        protected RepresentList(SafeRepresenter safeRepresenter) {
            this.this$0 = safeRepresenter;
        }

        /*
         * WARNING - void declaration
         */
        public final Node representData(Object data) {
            void var1_1;
            return this.this$0.representSequence(this.this$0.getTag(data.getClass(), Tag.SEQ), (List)var1_1, null);
        }
    }

    public final class RepresentNumber
    implements Represent {
        private /* synthetic */ SafeRepresenter this$0;

        protected RepresentNumber(SafeRepresenter safeRepresenter) {
            this.this$0 = safeRepresenter;
        }

        /*
         * WARNING - void declaration
         */
        public final Node representData(Object data) {
            void var3_3;
            void var2_2;
            void var1_1;
            String value;
            Tag tag;
            if (data instanceof Byte || data instanceof Short || data instanceof Integer || data instanceof Long || data instanceof BigInteger) {
                tag = Tag.INT;
                value = data.toString();
            } else {
                Number number = (Number)data;
                tag = Tag.FLOAT;
                value = number.equals(Double.NaN) ? ".NaN" : (value.equals(Double.POSITIVE_INFINITY) ? ".inf" : (value.equals(Double.NEGATIVE_INFINITY) ? "-.inf" : value.toString()));
            }
            return this.this$0.representScalar(this.this$0.getTag(var1_1.getClass(), (Tag)var2_2), (String)var3_3);
        }
    }

    public final class RepresentBoolean
    implements Represent {
        private /* synthetic */ SafeRepresenter this$0;

        protected RepresentBoolean(SafeRepresenter safeRepresenter) {
            this.this$0 = safeRepresenter;
        }

        /*
         * WARNING - void declaration
         */
        public final Node representData(Object data) {
            void var1_1;
            String value = Boolean.TRUE.equals(data) ? "true" : "false";
            return this.this$0.representScalar(Tag.BOOL, (String)var1_1);
        }
    }

    public final class RepresentString
    implements Represent {
        private /* synthetic */ SafeRepresenter this$0;

        protected RepresentString(SafeRepresenter safeRepresenter) {
            this.this$0 = safeRepresenter;
        }

        /*
         * WARNING - void declaration
         */
        public final Node representData(Object data) {
            void var3_4;
            void var2_3;
            String string;
            Tag tag = Tag.STR;
            Character style = null;
            String value = data.toString();
            if (StreamReader.NON_PRINTABLE.matcher(value).find()) {
                tag = Tag.BINARY;
                try {
                    char[] binary = Base64Coder.encode(value.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    void var1_2;
                    throw new YAMLException((Throwable)var1_2);
                }
                string = String.valueOf((char[])string);
                style = Character.valueOf('|');
            }
            if (this.this$0.defaultScalarStyle == null && MULTILINE_PATTERN.matcher(string).find()) {
                style = Character.valueOf('|');
            }
            return this.this$0.representScalar((Tag)var2_3, string, (Character)var3_4);
        }
    }

    public final class RepresentNull
    implements Represent {
        private /* synthetic */ SafeRepresenter this$0;

        protected RepresentNull(SafeRepresenter safeRepresenter) {
            this.this$0 = safeRepresenter;
        }

        public final Node representData(Object data) {
            return this.this$0.representScalar(Tag.NULL, "null");
        }
    }
}

