/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.external.com.google.gdata.util.common.base;

import org.yaml.snakeyaml.external.com.google.gdata.util.common.base.UnicodeEscaper;

public final class PercentEscaper
extends UnicodeEscaper {
    private static final char[] URI_ESCAPED_SPACE = new char[]{'+'};
    private static final char[] UPPER_HEX_DIGITS = "0123456789ABCDEF".toCharArray();
    private final boolean plusForSpace;
    private final boolean[] safeOctets;

    /*
     * WARNING - void declaration
     */
    public PercentEscaper(String safeChars, boolean plusForSpace) {
        void var1_1;
        if (safeChars.matches(".*[0-9A-Za-z].*")) {
            throw new IllegalArgumentException("Alphanumeric characters are always 'safe' and should not be explicitly specified");
        }
        if (safeChars.contains("%")) {
            throw new IllegalArgumentException("The '%' character cannot be specified as 'safe'");
        }
        this.plusForSpace = false;
        this.safeOctets = PercentEscaper.createSafeOctets((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean[] createSafeOctets(String safeChars) {
        void var2_3;
        int c;
        void var1_2;
        int maxChar = 122;
        char[] cArray = safeChars.toCharArray();
        Object safeCharArray = cArray;
        char[] arr$ = cArray;
        int len$ = cArray.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            char c2 = arr$[i$];
            maxChar = Math.max(c2, maxChar);
        }
        boolean[] octets = new boolean[var1_2 + true];
        for (c = 48; c <= 57; ++c) {
            octets[c] = true;
        }
        for (c = 65; c <= 90; ++c) {
            octets[c] = true;
        }
        for (c = 97; c <= 122; ++c) {
            octets[c] = true;
        }
        for (Object c3 : safeCharArray) {
            octets[var0_1] = true;
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    protected final int nextEscapeIndex(CharSequence csq, int index, int end) {
        void var2_2;
        char c;
        while (index < end && (c = csq.charAt(index)) < this.safeOctets.length && this.safeOctets[c]) {
            ++index;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final String escape(String s) {
        void var1_1;
        int slen = s.length();
        for (int index = 0; index < slen; ++index) {
            char c = s.charAt(index);
            if (c < this.safeOctets.length && this.safeOctets[c]) continue;
            return this.escapeSlow(s, index);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected final char[] escape(int cp) {
        void var1_1;
        if (cp < this.safeOctets.length && this.safeOctets[cp]) {
            return null;
        }
        if (cp == 32 && this.plusForSpace) {
            return URI_ESCAPED_SPACE;
        }
        if (cp <= 127) {
            char[] cArray = new char[3];
            char[] dest = cArray;
            cArray[0] = 37;
            dest[2] = UPPER_HEX_DIGITS[cp & 0xF];
            dest[1] = UPPER_HEX_DIGITS[cp >>> 4];
            return dest;
        }
        if (cp <= 2047) {
            char[] cArray = new char[6];
            char[] dest = cArray;
            cArray[0] = 37;
            dest[3] = 37;
            dest[5] = UPPER_HEX_DIGITS[cp & 0xF];
            dest[4] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[2] = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            dest[1] = UPPER_HEX_DIGITS[0xC | (cp >>>= 4)];
            return dest;
        }
        if (cp <= 65535) {
            char[] cArray = new char[9];
            char[] dest = cArray;
            cArray[0] = 37;
            dest[1] = 69;
            dest[3] = 37;
            dest[6] = 37;
            dest[8] = UPPER_HEX_DIGITS[cp & 0xF];
            dest[7] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[5] = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            dest[4] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[2] = UPPER_HEX_DIGITS[cp >>>= 2];
            return dest;
        }
        if (cp <= 0x10FFFF) {
            void var2_5;
            char[] cArray = new char[12];
            char[] dest = cArray;
            cArray[0] = 37;
            dest[1] = 70;
            dest[3] = 37;
            dest[6] = 37;
            dest[9] = 37;
            dest[11] = UPPER_HEX_DIGITS[cp & 0xF];
            dest[10] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[8] = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            dest[7] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[5] = UPPER_HEX_DIGITS[(cp >>>= 2) & 0xF];
            dest[4] = UPPER_HEX_DIGITS[8 | (cp >>>= 4) & 3];
            dest[2] = UPPER_HEX_DIGITS[(cp >>>= 2) & 7];
            return var2_5;
        }
        throw new IllegalArgumentException("Invalid unicode character value " + (int)var1_1);
    }
}

