/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.emitter;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.emitter.Emitable;
import org.yaml.snakeyaml.emitter.EmitterException;
import org.yaml.snakeyaml.emitter.EmitterState;
import org.yaml.snakeyaml.emitter.ScalarAnalysis;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.events.AliasEvent;
import org.yaml.snakeyaml.events.CollectionEndEvent;
import org.yaml.snakeyaml.events.CollectionStartEvent;
import org.yaml.snakeyaml.events.DocumentEndEvent;
import org.yaml.snakeyaml.events.DocumentStartEvent;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.NodeEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;
import org.yaml.snakeyaml.events.StreamEndEvent;
import org.yaml.snakeyaml.events.StreamStartEvent;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.scanner.Constant;
import org.yaml.snakeyaml.util.ArrayStack;

public final class Emitter
implements Emitable {
    private static final Map<Character, String> ESCAPE_REPLACEMENTS = new HashMap<Character, String>();
    private static final char[] SPACE = new char[]{' '};
    private static final Map<String, String> DEFAULT_TAG_PREFIXES;
    private final Writer stream;
    private final ArrayStack<EmitterState> states;
    private EmitterState state;
    private final Queue<Event> events;
    private Event event;
    private final ArrayStack<Integer> indents;
    private Integer indent;
    private int flowLevel;
    private boolean rootContext;
    private boolean mappingContext;
    private boolean simpleKeyContext;
    private int column;
    private boolean whitespace;
    private boolean indention;
    private boolean openEnded;
    private Boolean canonical;
    private Boolean prettyFlow;
    private boolean allowUnicode;
    private int bestIndent;
    private int bestWidth;
    private char[] bestLineBreak;
    private Map<String, String> tagPrefixes;
    private String preparedAnchor;
    private String preparedTag;
    private ScalarAnalysis analysis;
    private Character style;
    private DumperOptions options;
    private static final Pattern HANDLE_FORMAT;
    private static final Pattern ANCHOR_FORMAT;

    /*
     * WARNING - void declaration
     */
    public Emitter(Writer stream, DumperOptions opts) {
        void var2_2;
        DumperOptions dumperOptions;
        this.stream = dumperOptions;
        this.states = new ArrayStack(100);
        this.state = new ExpectStreamStart(this, 0);
        this.events = new ArrayBlockingQueue<Event>(100);
        this.event = null;
        this.indents = new ArrayStack(10);
        this.indent = null;
        this.flowLevel = 0;
        this.mappingContext = false;
        this.simpleKeyContext = false;
        this.column = 0;
        this.whitespace = true;
        this.indention = true;
        this.openEnded = false;
        dumperOptions = opts;
        this.canonical = false;
        this.prettyFlow = opts.isPrettyFlow();
        this.allowUnicode = opts.isAllowUnicode();
        this.bestIndent = 2;
        if (opts.getIndent() > 1 && opts.getIndent() < 10) {
            this.bestIndent = opts.getIndent();
        }
        this.bestWidth = 80;
        if (opts.getWidth() > this.bestIndent << 1) {
            this.bestWidth = opts.getWidth();
        }
        this.bestLineBreak = opts.getLineBreak().getString().toCharArray();
        this.tagPrefixes = new LinkedHashMap<String, String>();
        this.preparedAnchor = null;
        this.preparedTag = null;
        this.analysis = null;
        this.style = null;
        this.options = var2_2;
    }

    public final void emit(Event event) throws IOException {
        Emitter emitter;
        this.events.add((Event)((Object)emitter));
        while (true) {
            Event event2;
            emitter = this;
            if (emitter.events.isEmpty() ? true : ((event2 = emitter.events.peek()) instanceof DocumentStartEvent ? emitter.needEvents(1) : (event2 instanceof SequenceStartEvent ? emitter.needEvents(2) : (event2 instanceof MappingStartEvent ? emitter.needEvents(3) : false)))) break;
            this.event = this.events.poll();
            this.state.expect();
            this.event = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean needEvents(int count) {
        void var1_1;
        int level = 0;
        Iterator iter = this.events.iterator();
        iter.next();
        while (iter.hasNext()) {
            Event event = (Event)iter.next();
            if (event instanceof DocumentStartEvent || event instanceof CollectionStartEvent) {
                ++level;
            } else if (event instanceof DocumentEndEvent || event instanceof CollectionEndEvent) {
                --level;
            } else if (event instanceof StreamEndEvent) {
                level = -1;
            }
            if (level >= 0) continue;
            return false;
        }
        return this.events.size() < var1_1 + true;
    }

    /*
     * WARNING - void declaration
     */
    private void increaseIndent(boolean flow, boolean indentless) {
        void var2_3;
        this.indents.push(this.indent);
        if (this.indent == null) {
            void var1_1;
            if (var1_1 != false) {
                this.indent = this.bestIndent;
                return;
            }
            this.indent = 0;
            return;
        }
        if (var2_3 == false) {
            Emitter emitter = this;
            this.indent = emitter.indent + this.bestIndent;
        }
    }

    private boolean checkEmptySequence() {
        return this.event instanceof SequenceStartEvent && !this.events.isEmpty() && this.events.peek() instanceof SequenceEndEvent;
    }

    private boolean checkEmptyMapping() {
        return this.event instanceof MappingStartEvent && !this.events.isEmpty() && this.events.peek() instanceof MappingEndEvent;
    }

    /*
     * WARNING - void declaration
     */
    private void processAnchor(String indicator) throws IOException {
        void var1_1;
        NodeEvent ev = (NodeEvent)this.event;
        if (ev.getAnchor() == null) {
            this.preparedAnchor = null;
            return;
        }
        if (this.preparedAnchor == null) {
            void var2_2;
            this.preparedAnchor = Emitter.prepareAnchor(var2_2.getAnchor());
        }
        this.writeIndicator((String)var1_1 + this.preparedAnchor, true, false, false);
        this.preparedAnchor = null;
    }

    /*
     * WARNING - void declaration
     */
    private Character chooseScalarStyle() {
        void var1_1;
        ScalarEvent ev = (ScalarEvent)this.event;
        if (this.analysis == null) {
            this.analysis = this.analyzeScalar(ev.getValue());
        }
        if (ev.getStyle() != null && ev.getStyle().charValue() == '\"' || this.canonical.booleanValue()) {
            return Character.valueOf('\"');
        }
        if (ev.getStyle() == null && ev.getImplicit().canOmitTagInPlainScalar() && (!this.simpleKeyContext || !this.analysis.empty && !this.analysis.multiline) && (this.flowLevel != 0 && this.analysis.allowFlowPlain || this.flowLevel == 0 && this.analysis.allowBlockPlain)) {
            return null;
        }
        if (ev.getStyle() != null && (ev.getStyle().charValue() == '|' || ev.getStyle().charValue() == '>') && this.flowLevel == 0 && !this.simpleKeyContext && this.analysis.allowBlock) {
            return ev.getStyle();
        }
        if (!(ev.getStyle() != null && var1_1.getStyle().charValue() != '\'' || !this.analysis.allowSingleQuoted || this.simpleKeyContext && this.analysis.multiline)) {
            return Character.valueOf('\'');
        }
        return Character.valueOf('\"');
    }

    /*
     * WARNING - void declaration
     */
    private String prepareTag(String tag) {
        void var3_3;
        int end;
        String suffixText;
        if (tag.length() == 0) {
            throw new EmitterException("tag must not be empty");
        }
        if ("!".equals(tag)) {
            return tag;
        }
        String handle = null;
        String suffix = tag;
        for (String prefix : this.tagPrefixes.keySet()) {
            if (!tag.startsWith(prefix) || !"!".equals(prefix) && prefix.length() >= tag.length()) continue;
            handle = prefix;
        }
        if (handle != null) {
            void var1_1;
            suffix = var1_1.substring(handle.length());
            handle = this.tagPrefixes.get(handle);
        }
        String string = suffixText = (end = suffix.length()) > 0 ? var3_3.substring(0, end) : "";
        if (handle != null) {
            void var2_2;
            return (String)var2_2 + suffixText;
        }
        return "!<" + suffixText + ">";
    }

    private static String prepareAnchor(String anchor) {
        String string;
        if (anchor.length() == 0) {
            throw new EmitterException("anchor must not be empty");
        }
        if (!ANCHOR_FORMAT.matcher(anchor).matches()) {
            throw new EmitterException("invalid character in the anchor: " + anchor);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private ScalarAnalysis analyzeScalar(String scalar) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (scalar.length() == 0) {
            return new ScalarAnalysis(scalar, true, false, false, true, true, false);
        }
        boolean blockIndicators = false;
        boolean flowIndicators = false;
        boolean lineBreaks = false;
        boolean specialCharacters = false;
        boolean leadingSpace = false;
        boolean leadingBreak = false;
        boolean trailingSpace = false;
        boolean trailingBreak = false;
        boolean breakSpace = false;
        boolean spaceBreak = false;
        if (scalar.startsWith("---") || scalar.startsWith("...")) {
            blockIndicators = true;
            flowIndicators = true;
        }
        boolean preceededByWhitespace = true;
        boolean followedByWhitespace = scalar.length() == 1 || Constant.NULL_BL_T_LINEBR.has(scalar.charAt(1));
        boolean previousSpace = false;
        boolean previousBreak = false;
        int index = 0;
        while (index < scalar.length()) {
            boolean isLineBreak;
            char ch = scalar.charAt(index);
            if (index == 0) {
                if ("#,[]{}&*!|>'\"%@`".indexOf(ch) != -1) {
                    flowIndicators = true;
                    blockIndicators = true;
                }
                if (ch == '?' || ch == ':') {
                    flowIndicators = true;
                    if (followedByWhitespace) {
                        blockIndicators = true;
                    }
                }
                if (ch == '-' && followedByWhitespace) {
                    flowIndicators = true;
                    blockIndicators = true;
                }
            } else {
                if (",?[]{}".indexOf(ch) != -1) {
                    flowIndicators = true;
                }
                if (ch == ':') {
                    flowIndicators = true;
                    if (followedByWhitespace) {
                        blockIndicators = true;
                    }
                }
                if (ch == '#' && preceededByWhitespace) {
                    flowIndicators = true;
                    blockIndicators = true;
                }
            }
            if (isLineBreak = Constant.LINEBR.has(ch)) {
                lineBreaks = true;
            }
            if (!(ch == '\n' || ' ' <= ch && ch <= '~' || (ch == '\u0085' || '\u00a0' <= ch && ch <= '\ud7ff' || '\ue000' <= ch && ch <= '\ufffd') && ch != '\ufeff' && this.allowUnicode)) {
                specialCharacters = true;
            }
            if (ch == ' ') {
                if (index == 0) {
                    leadingSpace = true;
                }
                if (index == scalar.length() - 1) {
                    trailingSpace = true;
                }
                if (previousBreak) {
                    breakSpace = true;
                }
                previousSpace = true;
                previousBreak = false;
            } else if (isLineBreak) {
                if (index == 0) {
                    leadingBreak = true;
                }
                if (index == scalar.length() - 1) {
                    trailingBreak = true;
                }
                if (previousSpace) {
                    spaceBreak = true;
                }
                previousSpace = false;
                previousBreak = true;
            } else {
                previousSpace = false;
                previousBreak = false;
            }
            preceededByWhitespace = Constant.NULL_BL_T.has(ch) || isLineBreak;
            isLineBreak = ++index + 1 >= scalar.length() || Constant.NULL_BL_T.has(scalar.charAt(index + 1)) || isLineBreak;
        }
        boolean allowFlowPlain = true;
        boolean allowBlockPlain = true;
        boolean allowSingleQuoted = true;
        boolean allowBlock = true;
        if (leadingSpace || leadingBreak || trailingSpace || trailingBreak) {
            allowBlockPlain = false;
            allowFlowPlain = false;
        }
        if (trailingSpace) {
            allowBlock = false;
        }
        if (breakSpace) {
            allowSingleQuoted = false;
            allowBlockPlain = false;
            allowFlowPlain = false;
        }
        if (spaceBreak || specialCharacters) {
            allowBlock = false;
            allowSingleQuoted = false;
            allowBlockPlain = false;
            allowFlowPlain = false;
        }
        if (lineBreaks) {
            allowFlowPlain = false;
        }
        if (var3_3 != false) {
            allowFlowPlain = false;
        }
        if (var2_2 != false) {
            allowBlockPlain = false;
        }
        return new ScalarAnalysis((String)var1_1, false, lineBreaks, allowFlowPlain, allowBlockPlain, allowSingleQuoted, allowBlock);
    }

    final void flushStream() throws IOException {
        this.stream.flush();
    }

    static void writeStreamStart() {
    }

    final void writeStreamEnd() throws IOException {
        Emitter emitter = this;
        emitter.stream.flush();
    }

    /*
     * WARNING - void declaration
     */
    final void writeIndicator(String indicator, boolean needWhitespace, boolean whitespace, boolean indentation) throws IOException {
        void var1_1;
        void var3_3;
        void var2_2;
        if (!this.whitespace && var2_2 != false) {
            ++this.column;
            this.stream.write(SPACE);
        }
        this.whitespace = var3_3;
        this.indention = this.indention && indentation;
        this.column += indicator.length();
        this.openEnded = false;
        this.stream.write((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void writeIndent() throws IOException {
        int indent = this.indent != null ? this.indent : 0;
        if (!this.indention || this.column > indent || this.column == indent && !this.whitespace) {
            this.writeLineBreak(null);
        }
        if (this.column < indent) {
            void var2_2;
            void var1_1;
            this.whitespace = true;
            char[] data = new char[indent - this.column];
            for (int i = 0; i < data.length; ++i) {
                data[i] = 32;
            }
            this.column = var1_1;
            this.stream.write((char[])var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void writeLineBreak(String data) throws IOException {
        void var1_1;
        this.whitespace = true;
        this.indention = true;
        this.column = 0;
        if (data == null) {
            this.stream.write(this.bestLineBreak);
            return;
        }
        this.stream.write((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final void writeVersionDirective(String versionText) throws IOException {
        void var1_1;
        this.stream.write("%YAML ");
        this.stream.write((String)var1_1);
        this.writeLineBreak(null);
    }

    /*
     * WARNING - void declaration
     */
    final void writeTagDirective(String handleText, String prefixText) throws IOException {
        void var2_2;
        void var1_1;
        this.stream.write("%TAG ");
        this.stream.write((String)var1_1);
        this.stream.write(SPACE);
        this.stream.write((String)var2_2);
        this.writeLineBreak(null);
    }

    private void writeSingleQuoted(String text, boolean split) throws IOException {
        this.writeIndicator("'", true, false, false);
        boolean spaces = false;
        boolean breaks = false;
        int start = 0;
        for (int end = 0; end <= text.length(); ++end) {
            int n;
            int len2;
            char ch = '\u0000';
            if (end < text.length()) {
                ch = text.charAt(end);
            }
            if (spaces) {
                if (ch == '\u0000' || ch != ' ') {
                    if (start + 1 == end && this.column > this.bestWidth && split && start != 0 && end != text.length()) {
                        this.writeIndent();
                    } else {
                        len2 = end - start;
                        this.column += len2;
                        this.stream.write(text, start, len2);
                    }
                    start = end;
                }
            } else if (breaks) {
                if (ch == '\u0000' || Constant.LINEBR.hasNo(ch)) {
                    if (text.charAt(start) == '\n') {
                        this.writeLineBreak(null);
                    }
                    String len2 = text.substring(start, end);
                    for (char br : len2.toCharArray()) {
                        if (br == '\n') {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(br));
                    }
                    this.writeIndent();
                    n = end;
                }
            } else if (Constant.LINEBR.has(ch, "\u0000 '") && n < end) {
                len2 = end - n;
                this.column += len2;
                this.stream.write(text, n, len2);
                n = end;
            }
            if (ch == '\'') {
                this.column += 2;
                this.stream.write("''");
                n = end + 1;
            }
            if (ch == '\u0000') continue;
            spaces = ch == ' ';
            breaks = Constant.LINEBR.has(ch);
        }
        this.writeIndicator("'", false, false, false);
    }

    /*
     * WARNING - void declaration
     */
    private String determineBlockHints(String text) {
        void var2_2;
        void var1_1;
        void var3_3;
        StringBuilder hints = new StringBuilder();
        if (Constant.LINEBR.has(text.charAt(0), " ")) {
            hints.append(this.bestIndent);
        }
        char ch1 = text.charAt(text.length() - 1);
        if (Constant.LINEBR.hasNo((char)var3_3)) {
            hints.append("-");
        } else if (text.length() == 1 || Constant.LINEBR.has(text.charAt(var1_1.length() - 2))) {
            hints.append("+");
        }
        return var2_2.toString();
    }

    private void writeFolded(String text) throws IOException {
        String hints = this.determineBlockHints(text);
        this.writeIndicator(">" + hints, true, false, false);
        if (hints.length() > 0 && hints.charAt(hints.length() - 1) == '+') {
            this.openEnded = true;
        }
        this.writeLineBreak(null);
        boolean leadingSpace = true;
        boolean spaces = false;
        boolean breaks = true;
        int start = 0;
        for (int end = 0; end <= text.length(); ++end) {
            int len;
            int n;
            char ch = '\u0000';
            if (end < text.length()) {
                ch = text.charAt(end);
            }
            if (breaks) {
                if (ch == '\u0000' || Constant.LINEBR.hasNo(ch)) {
                    if (!leadingSpace && ch != '\u0000' && ch != ' ' && text.charAt(start) == '\n') {
                        this.writeLineBreak(null);
                    }
                    leadingSpace = ch == ' ';
                    String string = text.substring(start, end);
                    for (char br : string.toCharArray()) {
                        if (br == '\n') {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(br));
                    }
                    if (ch != '\u0000') {
                        this.writeIndent();
                    }
                    n = end;
                }
            } else if (spaces) {
                if (ch != ' ') {
                    if (n + true == end && this.column > this.bestWidth) {
                        this.writeIndent();
                    } else {
                        len = end - n;
                        this.column += len;
                        this.stream.write(text, n, len);
                    }
                    n = end;
                }
            } else if (Constant.LINEBR.has(ch, "\u0000 ")) {
                len = end - n;
                this.column += len;
                this.stream.write(text, n, len);
                if (ch == '\u0000') {
                    this.writeLineBreak(null);
                }
                n = end;
            }
            if (ch == '\u0000') continue;
            breaks = Constant.LINEBR.has(ch);
            spaces = ch == ' ';
        }
    }

    private void writeLiteral(String text) throws IOException {
        String hints = this.determineBlockHints(text);
        this.writeIndicator("|" + hints, true, false, false);
        if (hints.length() > 0 && hints.charAt(hints.length() - 1) == '+') {
            this.openEnded = true;
        }
        this.writeLineBreak(null);
        boolean breaks = true;
        int start2 = 0;
        for (int end = 0; end <= text.length(); ++end) {
            int n;
            char ch = '\u0000';
            if (end < text.length()) {
                ch = text.charAt(end);
            }
            if (breaks) {
                if (ch == '\u0000' || Constant.LINEBR.hasNo(ch)) {
                    String start2 = text.substring(start2, end);
                    for (char br : start2.toCharArray()) {
                        if (br == '\n') {
                            this.writeLineBreak(null);
                            continue;
                        }
                        this.writeLineBreak(String.valueOf(br));
                    }
                    if (ch != '\u0000') {
                        this.writeIndent();
                    }
                    n = end;
                }
            } else if (ch == '\u0000' || Constant.LINEBR.has(ch)) {
                this.stream.write(text, n, end - n);
                if (ch == '\u0000') {
                    this.writeLineBreak(null);
                }
                n = end;
            }
            if (ch == '\u0000') continue;
            breaks = Constant.LINEBR.has(ch);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ EmitterState access$202(Emitter x0, EmitterState x1) {
        void var1_1;
        x0.state = var1_1;
        return x0.state;
    }

    static /* synthetic */ String access$500(Emitter x0, DumperOptions.Version x1) {
        Object object = x1;
        if (((DumperOptions.Version)((Object)object)).getArray()[0] != 1) {
            throw new EmitterException("unsupported YAML version: " + object);
        }
        return ((DumperOptions.Version)((Object)object)).getRepresentation();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$602(Emitter x0, Map x1) {
        void var1_1;
        x0.tagPrefixes = var1_1;
        return x0.tagPrefixes;
    }

    static /* synthetic */ String access$800(Emitter x0, String x1) {
        String string = x1;
        if (string.length() == 0) {
            throw new EmitterException("tag handle must not be empty");
        }
        if (string.charAt(0) != '!' || string.charAt(string.length() - 1) != '!') {
            throw new EmitterException("tag handle must start and end with '!': " + (String)string);
        }
        if (!"!".equals(string) && !HANDLE_FORMAT.matcher(string).matches()) {
            throw new EmitterException("invalid character in the tag handle: " + (String)string);
        }
        return string;
    }

    static /* synthetic */ String access$900(Emitter x0, String x1) {
        String string = x1;
        if (string.length() == 0) {
            throw new EmitterException("tag prefix must not be empty");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        if (string.charAt(0) == '!') {
            n = 1;
        }
        while (n < string.length()) {
            ++n;
        }
        if (n > 0) {
            stringBuilder.append(string.substring(0, n));
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static /* synthetic */ boolean access$1100(Emitter x0) {
        Object object = x0;
        if (!(((Emitter)object).event instanceof DocumentStartEvent)) return false;
        if (((Emitter)object).events.isEmpty()) {
            return false;
        }
        object = ((Emitter)object).events.peek();
        if (!(object instanceof ScalarEvent)) return false;
        if (((NodeEvent)(object = (ScalarEvent)object)).getAnchor() != null) return false;
        if (((ScalarEvent)object).getTag() != null) return false;
        if (((ScalarEvent)object).getImplicit() == null) return false;
        if (((ScalarEvent)object).getValue().length() != 0) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static /* synthetic */ void access$1600(Emitter x0, boolean x1, boolean x2, boolean x3) throws IOException {
        block56: {
            block59: {
                block57: {
                    block58: {
                        var0 /* !! */  = x0;
                        x0.rootContext = var1_4;
                        var0 /* !! */ .mappingContext = var2_7;
                        var0 /* !! */ .simpleKeyContext = var3_10;
                        if (var0 /* !! */ .event instanceof AliasEvent) {
                            var1_5 = var0 /* !! */ ;
                            if (((NodeEvent)var1_5.event).getAnchor() == null) {
                                throw new EmitterException("anchor is not specified for alias");
                            }
                            var1_5.processAnchor("*");
                            var1_5.state = var1_5.states.pop();
                            return;
                        }
                        if (!(var0 /* !! */ .event instanceof ScalarEvent) && !(var0 /* !! */ .event instanceof CollectionStartEvent)) break block56;
                        var0 /* !! */ .processAnchor("&");
                        var1_6 = var0 /* !! */ ;
                        if (!(var1_6.event instanceof ScalarEvent)) break block57;
                        var3_11 = (ScalarEvent)var1_6.event;
                        var2_8 = var3_11.getTag();
                        if (var1_6.style == null) {
                            var1_6.style = var1_6.chooseScalarStyle();
                        }
                        if (var1_6.canonical.booleanValue() && var2_8 != null || (var1_6.style != null || !var3_11.getImplicit().canOmitTagInPlainScalar()) && (var1_6.style == null || !var3_11.getImplicit().canOmitTagInNonPlainScalar())) break block58;
                        var1_6.preparedTag = null;
                        break block59;
                    }
                    if (!var3_11.getImplicit().canOmitTagInPlainScalar() || var2_8 != null) ** GOTO lbl-1000
                    var2_8 = "!";
                    var1_6.preparedTag = null;
                    ** GOTO lbl-1000
                }
                var3_11 = (CollectionStartEvent)var1_6.event;
                var2_8 = var3_11.getTag();
                if ((!var1_6.canonical.booleanValue() || var2_8 == null) && var3_11.getImplicit()) {
                    var1_6.preparedTag = null;
                } else lbl-1000:
                // 3 sources

                {
                    if (var2_8 == null) {
                        throw new EmitterException("tag is not specified");
                    }
                    if (var1_6.preparedTag == null) {
                        var1_6.preparedTag = var1_6.prepareTag((String)var2_8);
                    }
                    var1_6.writeIndicator(var1_6.preparedTag, true, false, false);
                    var1_6.preparedTag = null;
                }
            }
            if (var0 /* !! */ .event instanceof ScalarEvent) {
                var1_6 = var0 /* !! */ ;
                var1_6.increaseIndent(true, false);
                var2_8 = var1_6;
                var3_11 = (ScalarEvent)var2_8.event;
                if (var2_8.analysis == null) {
                    var2_8.analysis = super.analyzeScalar(var3_11.getValue());
                }
                if (var2_8.style == null) {
                    var2_8.style = super.chooseScalarStyle();
                }
                var2_8.options;
                var2_8.analysis;
                var0 /* !! */  = DumperOptions.ScalarStyle.createStyle(var2_8.style);
                var2_8.style = var0 /* !! */ .getChar();
                v0 = var0_1 = var2_8.simpleKeyContext == false;
                if (var2_8.style == null) {
                    var4_12 = var0_1;
                    var3_11 = var2_8.analysis.scalar;
                    var0_2 = var2_8;
                    if (var0_2.rootContext) {
                        var0_2.openEnded = true;
                    }
                    if (var3_11.length() != 0) {
                        if (!var0_2.whitespace) {
                            ++var0_2.column;
                            var0_2.stream.write(Emitter.SPACE);
                        }
                        var0_2.whitespace = false;
                        var0_2.indention = false;
                        var5_14 = false;
                        var6_16 = false;
                        var7_18 = 0;
                        for (var8_21 = 0; var8_21 <= var3_11.length(); ++var8_21) {
                            var9_25 = '\u0000';
                            if (var8_21 < var3_11.length()) {
                                var9_25 = var3_11.charAt(var8_21);
                            }
                            if (var5_14) {
                                if (var9_25 != ' ') {
                                    if (var7_18 + 1 == var8_21 && var0_2.column > var0_2.bestWidth && var4_12) {
                                        var0_2.writeIndent();
                                        var0_2.whitespace = false;
                                        var0_2.indention = false;
                                    } else {
                                        var10_27 = var8_21 - var7_18;
                                        var0_2.column += var10_27;
                                        var0_2.stream.write((String)var3_11, var7_18, var10_27);
                                    }
                                    var7_18 = var8_21;
                                }
                            } else if (var6_16) {
                                if (Constant.LINEBR.hasNo(var9_25)) {
                                    if (var3_11.charAt(var7_18) == '\n') {
                                        super.writeLineBreak(null);
                                    }
                                    var10_28 = var3_11.substring(var7_18, var8_21);
                                    for (char var12_31 : var10_28.toCharArray()) {
                                        if (var12_31 == '\n') {
                                            super.writeLineBreak(null);
                                            continue;
                                        }
                                        super.writeLineBreak(String.valueOf(var12_31));
                                    }
                                    var0_2.writeIndent();
                                    var0_2.whitespace = false;
                                    var0_2.indention = false;
                                    var7_18 = var8_21;
                                }
                            } else if (var9_25 == '\u0000' || Constant.LINEBR.has(var9_25)) {
                                var10_27 = var8_21 - var7_18;
                                var0_2.column += var10_27;
                                var0_2.stream.write((String)var3_11, var7_18, var10_27);
                                var7_18 = var8_21;
                            }
                            if (var9_25 == '\u0000') continue;
                            var5_14 = var9_25 == ' ';
                            var6_16 = Constant.LINEBR.has(var9_25);
                        }
                    }
                } else {
                    switch (var2_8.style.charValue()) {
                        case '\"': {
                            var4_13 = var0_1;
                            var3_11 = var2_8.analysis.scalar;
                            var0_3 = var2_8;
                            var0_3.writeIndicator("\"", true, false, false);
                            var5_15 = 0;
                            for (var6_17 = 0; var6_17 <= var3_11.length(); ++var6_17) {
                                var7_20 = null;
                                if (var6_17 < var3_11.length()) {
                                    var7_20 = Character.valueOf(var3_11.charAt(var6_17));
                                }
                                if (var7_20 == null || "\"\\\u0085\u2028\u2029\ufeff".indexOf(var7_20.charValue()) != -1 || ' ' > var7_20.charValue() || var7_20.charValue() > '~') {
                                    if (var5_15 < var6_17) {
                                        var8_22 = var6_17 - var5_15;
                                        var0_3.column += var8_22;
                                        var0_3.stream.write((String)var3_11, var5_15, var8_22);
                                        var5_15 = var6_17;
                                    }
                                    if (var7_20 != null) {
                                        if (Emitter.ESCAPE_REPLACEMENTS.containsKey(var7_20)) {
                                            var8_23 = "\\" + Emitter.ESCAPE_REPLACEMENTS.get(var7_20);
                                        } else if (!var0_3.allowUnicode || !StreamReader.isPrintable(var7_20.charValue())) {
                                            if (var7_20.charValue() <= '\u00ff') {
                                                var9_26 = "0" + Integer.toString(var7_20.charValue(), 16);
                                                var8_23 = "\\x" + var9_26.substring(var9_26.length() - 2);
                                            } else if (var7_20.charValue() >= '\ud800' && var7_20.charValue() <= '\udbff') {
                                                if (var6_17 + 1 < var3_11.length()) {
                                                    var9_26 = Character.valueOf(var3_11.charAt(++var6_17));
                                                    var10_29 = "000" + Long.toHexString(Character.toCodePoint(var7_20.charValue(), var9_26.charValue()));
                                                    var8_23 = "\\U" + var10_29.substring(var10_29.length() - 8);
                                                } else {
                                                    var9_26 = "000" + Integer.toString(var7_20.charValue(), 16);
                                                    var8_23 = "\\u" + var9_26.substring(var9_26.length() - 4);
                                                }
                                            } else {
                                                var9_26 = "000" + Integer.toString(var7_20.charValue(), 16);
                                                var8_23 = "\\u" + var9_26.substring(var9_26.length() - 4);
                                            }
                                        } else {
                                            var8_23 = String.valueOf(var7_20);
                                        }
                                        var0_3.column += var8_23.length();
                                        var0_3.stream.write(var8_23);
                                        var5_15 = var6_17 + 1;
                                    }
                                }
                                if (var6_17 <= 0 || var6_17 >= var3_11.length() - 1 || var7_20.charValue() != ' ' && var5_15 < var6_17 || var0_3.column + (var6_17 - var5_15) <= var0_3.bestWidth || !var4_13) continue;
                                var8_24 = var5_15 >= var6_17 ? "\\" : var3_11.substring(var5_15, var6_17) + "\\";
                                if (var5_15 < var6_17) {
                                    var5_15 = var6_17;
                                }
                                var0_3.column += var8_24.length();
                                var0_3.stream.write(var8_24);
                                var0_3.writeIndent();
                                var0_3.whitespace = false;
                                var0_3.indention = false;
                                if (var3_11.charAt(var5_15) != ' ') continue;
                                var8_24 = "\\";
                                var0_3.column += var8_24.length();
                                var0_3.stream.write(var8_24);
                            }
                            var0_3.writeIndicator("\"", false, false, false);
                            break;
                        }
                        case '\'': {
                            super.writeSingleQuoted(var2_8.analysis.scalar, var0_1);
                            break;
                        }
                        case '>': {
                            super.writeFolded(var2_8.analysis.scalar);
                            break;
                        }
                        case '|': {
                            super.writeLiteral(var2_8.analysis.scalar);
                            break;
                        }
                        default: {
                            throw new YAMLException("Unexpected style: " + var2_8.style);
                        }
                    }
                }
                var2_8.analysis = null;
                var2_8.style = null;
                var1_6.indent = var1_6.indents.pop();
                var1_6.state = var1_6.states.pop();
                return;
            }
            if (var0 /* !! */ .event instanceof SequenceStartEvent) {
                if (var0 /* !! */ .flowLevel != 0 || var0 /* !! */ .canonical.booleanValue() || ((SequenceStartEvent)var0 /* !! */ .event).getFlowStyle().booleanValue() || var0 /* !! */ .checkEmptySequence()) {
                    var1_6 = var0 /* !! */ ;
                    var1_6.writeIndicator("[", true, true, false);
                    ++var1_6.flowLevel;
                    var1_6.increaseIndent(true, false);
                    if (var1_6.prettyFlow.booleanValue()) {
                        var1_6.writeIndent();
                    }
                    var1_6.state = new ExpectFirstFlowSequenceItem(var1_6, 0);
                    return;
                }
                var1_6 = var0 /* !! */ ;
                var2_9 = var1_6.mappingContext != false && var1_6.indention == false;
                var1_6.increaseIndent(false, var2_9);
                var1_6.state = new ExpectFirstBlockSequenceItem(var1_6, 0);
                return;
            }
            if (var0 /* !! */ .flowLevel != 0 || var0 /* !! */ .canonical.booleanValue() || ((MappingStartEvent)var0 /* !! */ .event).getFlowStyle().booleanValue() || var0 /* !! */ .checkEmptyMapping()) {
                var1_6 = var0 /* !! */ ;
                var1_6.writeIndicator("{", true, true, false);
                ++var1_6.flowLevel;
                var1_6.increaseIndent(true, false);
                if (var1_6.prettyFlow.booleanValue()) {
                    var1_6.writeIndent();
                }
                var1_6.state = new ExpectFirstFlowMappingKey(var1_6, 0);
                return;
            }
            var1_6 = var0 /* !! */ ;
            var1_6.increaseIndent(false, false);
            var1_6.state = new ExpectFirstBlockMappingKey(var1_6, 0);
            return;
        }
        throw new EmitterException("expected NodeEvent, but got " + var0 /* !! */ .event);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Integer access$1802(Emitter x0, Integer x1) {
        void var1_1;
        x0.indent = var1_1;
        return x0.indent;
    }

    static /* synthetic */ boolean access$2600(Emitter x0) {
        Emitter emitter = x0;
        int n = 0;
        if (emitter.event instanceof NodeEvent && ((NodeEvent)emitter.event).getAnchor() != null) {
            if (emitter.preparedAnchor == null) {
                emitter.preparedAnchor = Emitter.prepareAnchor(((NodeEvent)emitter.event).getAnchor());
            }
            n = 0 + emitter.preparedAnchor.length();
        }
        String string = null;
        if (emitter.event instanceof ScalarEvent) {
            string = ((ScalarEvent)emitter.event).getTag();
        } else if (emitter.event instanceof CollectionStartEvent) {
            string = ((CollectionStartEvent)emitter.event).getTag();
        }
        if (string != null) {
            if (emitter.preparedTag == null) {
                emitter.preparedTag = emitter.prepareTag(string);
            }
            n += emitter.preparedTag.length();
        }
        if (emitter.event instanceof ScalarEvent) {
            if (emitter.analysis == null) {
                emitter.analysis = emitter.analyzeScalar(((ScalarEvent)emitter.event).getValue());
            }
            n += emitter.analysis.scalar.length();
        }
        return n < 128 && (emitter.event instanceof AliasEvent || emitter.event instanceof ScalarEvent && !emitter.analysis.empty && !emitter.analysis.multiline || emitter.checkEmptySequence() || emitter.checkEmptyMapping());
    }

    static {
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u0000'), "0");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u0007'), "a");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\b'), "b");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\t'), "t");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\n'), "n");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u000b'), "v");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\f'), "f");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\r'), "r");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u001b'), "e");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\"'), "\"");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\\'), "\\");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u0085'), "N");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u00a0'), "_");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u2028'), "L");
        ESCAPE_REPLACEMENTS.put(Character.valueOf('\u2029'), "P");
        DEFAULT_TAG_PREFIXES = new LinkedHashMap<String, String>();
        DEFAULT_TAG_PREFIXES.put("!", "!");
        DEFAULT_TAG_PREFIXES.put("tag:yaml.org,2002:", "!!");
        HANDLE_FORMAT = Pattern.compile("^![-_\\w]*!$");
        ANCHOR_FORMAT = Pattern.compile("^[-_\\w]*$");
    }

    static class 1
    implements EmitterState {
        private boolean first;
        final /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public 1(Emitter emitter, boolean first) {
            void var2_2;
            this.this$0 = emitter;
            this.first = var2_2;
        }

        public void expect() throws IOException {
            if (!this.first && this.this$0.event instanceof MappingEndEvent) {
                Emitter.access$1802(this.this$0, (Integer)this.this$0.indents.pop());
                Emitter.access$202(this.this$0, (EmitterState)this.this$0.states.pop());
                return;
            }
            this.this$0.writeIndent();
            if (Emitter.access$2600(this.this$0)) {
                this.this$0.states.push(new ExpectBlockMappingSimpleValue(this.this$0, 0));
                Emitter.access$1600(this.this$0, false, true, true);
                return;
            }
            this.this$0.writeIndicator("?", true, false, true);
            this.this$0.states.push(new ExpectBlockMappingValue(this.this$0, 0));
            Emitter.access$1600(this.this$0, false, true, false);
        }
    }

    final class ExpectBlockMappingValue
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        private ExpectBlockMappingValue(Emitter emitter) {
            this.this$0 = emitter;
        }

        public final void expect() throws IOException {
            this.this$0.writeIndent();
            this.this$0.writeIndicator(":", true, false, true);
            this.this$0.states.push(new 1(this.this$0, false));
            Emitter.access$1600(this.this$0, false, true, false);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ExpectBlockMappingValue(Emitter x0, byte by) {
            this((Emitter)var1_1);
            void var1_1;
        }
    }

    final class ExpectBlockMappingSimpleValue
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        private ExpectBlockMappingSimpleValue(Emitter emitter) {
            this.this$0 = emitter;
        }

        public final void expect() throws IOException {
            this.this$0.writeIndicator(":", false, false, false);
            this.this$0.states.push(new 1(this.this$0, false));
            Emitter.access$1600(this.this$0, false, true, false);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ExpectBlockMappingSimpleValue(Emitter x0, byte by) {
            this((Emitter)var1_1);
            void var1_1;
        }
    }

    final class ExpectFirstBlockMappingKey
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        private ExpectFirstBlockMappingKey(Emitter emitter) {
            this.this$0 = emitter;
        }

        public final void expect() throws IOException {
            new 1(this.this$0, true).expect();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ExpectFirstBlockMappingKey(Emitter x0, byte by) {
            this((Emitter)var1_1);
            void var1_1;
        }
    }

    final class ExpectBlockSequenceItem
    implements EmitterState {
        private boolean first;
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectBlockSequenceItem(Emitter emitter, boolean first) {
            void var2_2;
            this.this$0 = emitter;
            this.first = var2_2;
        }

        public final void expect() throws IOException {
            if (!this.first && this.this$0.event instanceof SequenceEndEvent) {
                Emitter.access$1802(this.this$0, (Integer)this.this$0.indents.pop());
                Emitter.access$202(this.this$0, (EmitterState)this.this$0.states.pop());
                return;
            }
            this.this$0.writeIndent();
            this.this$0.writeIndicator("-", true, false, true);
            this.this$0.states.push(new ExpectBlockSequenceItem(this.this$0, false));
            Emitter.access$1600(this.this$0, false, false, false);
        }
    }

    final class ExpectFirstBlockSequenceItem
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        private ExpectFirstBlockSequenceItem(Emitter emitter) {
            this.this$0 = emitter;
        }

        public final void expect() throws IOException {
            new ExpectBlockSequenceItem(this.this$0, true).expect();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ExpectFirstBlockSequenceItem(Emitter x0, byte by) {
            this((Emitter)var1_1);
            void var1_1;
        }
    }

    final class ExpectFlowMappingValue
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        private ExpectFlowMappingValue(Emitter emitter) {
            this.this$0 = emitter;
        }

        public final void expect() throws IOException {
            if (this.this$0.canonical.booleanValue() || this.this$0.column > this.this$0.bestWidth || this.this$0.prettyFlow.booleanValue()) {
                this.this$0.writeIndent();
            }
            this.this$0.writeIndicator(":", true, false, false);
            this.this$0.states.push(new ExpectFlowMappingKey(this.this$0, 0));
            Emitter.access$1600(this.this$0, false, true, false);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ExpectFlowMappingValue(Emitter x0, byte by) {
            this((Emitter)var1_1);
            void var1_1;
        }
    }

    final class ExpectFlowMappingSimpleValue
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        private ExpectFlowMappingSimpleValue(Emitter emitter) {
            this.this$0 = emitter;
        }

        public final void expect() throws IOException {
            this.this$0.writeIndicator(":", false, false, false);
            this.this$0.states.push(new ExpectFlowMappingKey(this.this$0, 0));
            Emitter.access$1600(this.this$0, false, true, false);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ExpectFlowMappingSimpleValue(Emitter x0, byte by) {
            this((Emitter)var1_1);
            void var1_1;
        }
    }

    final class ExpectFlowMappingKey
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        private ExpectFlowMappingKey(Emitter emitter) {
            this.this$0 = emitter;
        }

        public final void expect() throws IOException {
            if (this.this$0.event instanceof MappingEndEvent) {
                Emitter.access$1802(this.this$0, (Integer)this.this$0.indents.pop());
                this.this$0.flowLevel--;
                if (this.this$0.canonical.booleanValue()) {
                    this.this$0.writeIndicator(",", false, false, false);
                    this.this$0.writeIndent();
                }
                if (this.this$0.prettyFlow.booleanValue()) {
                    this.this$0.writeIndent();
                }
                this.this$0.writeIndicator("}", false, false, false);
                Emitter.access$202(this.this$0, (EmitterState)this.this$0.states.pop());
                return;
            }
            this.this$0.writeIndicator(",", false, false, false);
            if (this.this$0.canonical.booleanValue() || this.this$0.column > this.this$0.bestWidth || this.this$0.prettyFlow.booleanValue()) {
                this.this$0.writeIndent();
            }
            if (!this.this$0.canonical.booleanValue() && Emitter.access$2600(this.this$0)) {
                this.this$0.states.push(new ExpectFlowMappingSimpleValue(this.this$0, 0));
                Emitter.access$1600(this.this$0, false, true, true);
                return;
            }
            this.this$0.writeIndicator("?", true, false, false);
            this.this$0.states.push(new ExpectFlowMappingValue(this.this$0, 0));
            Emitter.access$1600(this.this$0, false, true, false);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ExpectFlowMappingKey(Emitter x0, byte by) {
            this((Emitter)var1_1);
            void var1_1;
        }
    }

    final class ExpectFirstFlowMappingKey
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        private ExpectFirstFlowMappingKey(Emitter emitter) {
            this.this$0 = emitter;
        }

        public final void expect() throws IOException {
            if (this.this$0.event instanceof MappingEndEvent) {
                Emitter.access$1802(this.this$0, (Integer)this.this$0.indents.pop());
                this.this$0.flowLevel--;
                this.this$0.writeIndicator("}", false, false, false);
                Emitter.access$202(this.this$0, (EmitterState)this.this$0.states.pop());
                return;
            }
            if (this.this$0.canonical.booleanValue() || this.this$0.column > this.this$0.bestWidth || this.this$0.prettyFlow.booleanValue()) {
                this.this$0.writeIndent();
            }
            if (!this.this$0.canonical.booleanValue() && Emitter.access$2600(this.this$0)) {
                this.this$0.states.push(new ExpectFlowMappingSimpleValue(this.this$0, 0));
                Emitter.access$1600(this.this$0, false, true, true);
                return;
            }
            this.this$0.writeIndicator("?", true, false, false);
            this.this$0.states.push(new ExpectFlowMappingValue(this.this$0, 0));
            Emitter.access$1600(this.this$0, false, true, false);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ExpectFirstFlowMappingKey(Emitter x0, byte by) {
            this((Emitter)var1_1);
            void var1_1;
        }
    }

    final class ExpectFlowSequenceItem
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        private ExpectFlowSequenceItem(Emitter emitter) {
            this.this$0 = emitter;
        }

        public final void expect() throws IOException {
            if (this.this$0.event instanceof SequenceEndEvent) {
                Emitter.access$1802(this.this$0, (Integer)this.this$0.indents.pop());
                this.this$0.flowLevel--;
                if (this.this$0.canonical.booleanValue()) {
                    this.this$0.writeIndicator(",", false, false, false);
                    this.this$0.writeIndent();
                }
                this.this$0.writeIndicator("]", false, false, false);
                if (this.this$0.prettyFlow.booleanValue()) {
                    this.this$0.writeIndent();
                }
                Emitter.access$202(this.this$0, (EmitterState)this.this$0.states.pop());
                return;
            }
            this.this$0.writeIndicator(",", false, false, false);
            if (this.this$0.canonical.booleanValue() || this.this$0.column > this.this$0.bestWidth || this.this$0.prettyFlow.booleanValue()) {
                this.this$0.writeIndent();
            }
            this.this$0.states.push(new ExpectFlowSequenceItem(this.this$0));
            Emitter.access$1600(this.this$0, false, false, false);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ExpectFlowSequenceItem(Emitter x0, byte by) {
            this((Emitter)var1_1);
            void var1_1;
        }
    }

    final class ExpectFirstFlowSequenceItem
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        private ExpectFirstFlowSequenceItem(Emitter emitter) {
            this.this$0 = emitter;
        }

        public final void expect() throws IOException {
            if (this.this$0.event instanceof SequenceEndEvent) {
                Emitter.access$1802(this.this$0, (Integer)this.this$0.indents.pop());
                this.this$0.flowLevel--;
                this.this$0.writeIndicator("]", false, false, false);
                Emitter.access$202(this.this$0, (EmitterState)this.this$0.states.pop());
                return;
            }
            if (this.this$0.canonical.booleanValue() || this.this$0.column > this.this$0.bestWidth || this.this$0.prettyFlow.booleanValue()) {
                this.this$0.writeIndent();
            }
            this.this$0.states.push(new ExpectFlowSequenceItem(this.this$0, 0));
            Emitter.access$1600(this.this$0, false, false, false);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ExpectFirstFlowSequenceItem(Emitter x0, byte by) {
            this((Emitter)var1_1);
            void var1_1;
        }
    }

    final class ExpectDocumentRoot
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        private ExpectDocumentRoot(Emitter emitter) {
            this.this$0 = emitter;
        }

        public final void expect() throws IOException {
            this.this$0.states.push(new ExpectDocumentEnd(this.this$0, 0));
            Emitter.access$1600(this.this$0, true, false, false);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ExpectDocumentRoot(Emitter x0, byte by) {
            this((Emitter)var1_1);
            void var1_1;
        }
    }

    final class ExpectDocumentEnd
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        private ExpectDocumentEnd(Emitter emitter) {
            this.this$0 = emitter;
        }

        public final void expect() throws IOException {
            if (this.this$0.event instanceof DocumentEndEvent) {
                this.this$0.writeIndent();
                if (((DocumentEndEvent)this.this$0.event).getExplicit()) {
                    this.this$0.writeIndicator("...", true, false, false);
                    this.this$0.writeIndent();
                }
                this.this$0.flushStream();
                Emitter.access$202(this.this$0, new ExpectDocumentStart(this.this$0, false));
                return;
            }
            throw new EmitterException("expected DocumentEndEvent, but got " + this.this$0.event);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ExpectDocumentEnd(Emitter x0, byte by) {
            this((Emitter)var1_1);
            void var1_1;
        }
    }

    final class ExpectDocumentStart
    implements EmitterState {
        private boolean first;
        private /* synthetic */ Emitter this$0;

        /*
         * WARNING - void declaration
         */
        public ExpectDocumentStart(Emitter emitter, boolean first) {
            void var2_2;
            this.this$0 = emitter;
            this.first = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final void expect() throws IOException {
            if (this.this$0.event instanceof DocumentStartEvent) {
                void var1_1;
                boolean bl;
                Object versionText;
                DocumentStartEvent ev = (DocumentStartEvent)this.this$0.event;
                if ((ev.getVersion() != null || ev.getTags() != null) && this.this$0.openEnded) {
                    this.this$0.writeIndicator("...", true, false, false);
                    this.this$0.writeIndent();
                }
                if (ev.getVersion() != null) {
                    versionText = Emitter.access$500(this.this$0, ev.getVersion());
                    this.this$0.writeVersionDirective((String)versionText);
                }
                Emitter.access$602(this.this$0, new LinkedHashMap(DEFAULT_TAG_PREFIXES));
                if (ev.getTags() != null) {
                    versionText = new TreeSet<String>(ev.getTags().keySet());
                    Iterator i$ = versionText.iterator();
                    while (i$.hasNext()) {
                        void var3_4;
                        String handle = (String)i$.next();
                        String prefix = ev.getTags().get(handle);
                        this.this$0.tagPrefixes.put(prefix, handle);
                        String handleText = Emitter.access$800(this.this$0, handle);
                        String prefixText = Emitter.access$900(this.this$0, prefix);
                        this.this$0.writeTagDirective((String)var3_4, prefixText);
                    }
                }
                if (!(bl = this.first && !ev.getExplicit() && this.this$0.canonical == false && ev.getVersion() == null && (ev.getTags() == null || var1_1.getTags().isEmpty()) && !Emitter.access$1100(this.this$0))) {
                    this.this$0.writeIndent();
                    this.this$0.writeIndicator("---", true, false, false);
                    if (this.this$0.canonical.booleanValue()) {
                        this.this$0.writeIndent();
                    }
                }
                Emitter.access$202(this.this$0, new ExpectDocumentRoot(this.this$0, 0));
                return;
            }
            if (this.this$0.event instanceof StreamEndEvent) {
                this.this$0.writeStreamEnd();
                Emitter.access$202(this.this$0, new ExpectNothing(this.this$0, 0));
                return;
            }
            throw new EmitterException("expected DocumentStartEvent, but got " + this.this$0.event);
        }
    }

    final class ExpectFirstDocumentStart
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        private ExpectFirstDocumentStart(Emitter emitter) {
            this.this$0 = emitter;
        }

        public final void expect() throws IOException {
            new ExpectDocumentStart(this.this$0, true).expect();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ExpectFirstDocumentStart(Emitter x0, byte by) {
            this((Emitter)var1_1);
            void var1_1;
        }
    }

    final class ExpectNothing
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        private ExpectNothing(Emitter emitter) {
            this.this$0 = emitter;
        }

        public final void expect() throws IOException {
            throw new EmitterException("expecting nothing, but got " + this.this$0.event);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ExpectNothing(Emitter x0, byte by) {
            this((Emitter)var1_1);
            void var1_1;
        }
    }

    final class ExpectStreamStart
    implements EmitterState {
        private /* synthetic */ Emitter this$0;

        private ExpectStreamStart(Emitter emitter) {
            this.this$0 = emitter;
        }

        public final void expect() throws IOException {
            if (this.this$0.event instanceof StreamStartEvent) {
                ExpectStreamStart expectStreamStart = this;
                expectStreamStart.this$0.writeStreamStart();
                Emitter.access$202(this.this$0, new ExpectFirstDocumentStart(this.this$0, 0));
                return;
            }
            throw new EmitterException("expected StreamStartEvent, but got " + this.this$0.event);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ExpectStreamStart(Emitter x0, byte by) {
            this((Emitter)var1_1);
            void var1_1;
        }
    }
}

