/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.compress.PacketCompressor;
import net.md_5.bungee.compress.PacketDecompressor;
import net.md_5.bungee.netty.cipher.CipherEncoder;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.MinecraftDecoder;
import net.md_5.bungee.protocol.MinecraftEncoder;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.Varint21LengthFieldPrepender;
import net.md_5.bungee.protocol.packet.Kick;

public class ChannelWrapper {
    private final Channel ch;
    private SocketAddress remoteAddress;
    private volatile boolean closed;
    private volatile boolean closing;

    public ChannelWrapper(ChannelHandlerContext ctx) {
        this.ch = ctx.channel();
        this.remoteAddress = this.ch.remoteAddress() == null ? this.ch.parent().localAddress() : this.ch.remoteAddress();
    }

    public Protocol getDecodeProtocol() {
        return this.getMinecraftDecoder().getProtocol();
    }

    public void setDecodeProtocol(Protocol protocol) {
        this.getMinecraftDecoder().setProtocol(protocol);
    }

    public Protocol getEncodeProtocol() {
        return this.getMinecraftEncoder().getProtocol();
    }

    public void setEncodeProtocol(Protocol protocol) {
        this.getMinecraftEncoder().setProtocol(protocol);
    }

    public void setProtocol(Protocol protocol) {
        this.setDecodeProtocol(protocol);
        this.setEncodeProtocol(protocol);
    }

    public void setVersion(int protocol) {
        this.getMinecraftDecoder().setProtocolVersion(protocol);
        this.getMinecraftEncoder().setProtocolVersion(protocol);
    }

    public MinecraftDecoder getMinecraftDecoder() {
        return this.ch.pipeline().get(MinecraftDecoder.class);
    }

    public MinecraftEncoder getMinecraftEncoder() {
        return this.ch.pipeline().get(MinecraftEncoder.class);
    }

    public int getEncodeVersion() {
        return this.getMinecraftEncoder().getProtocolVersion();
    }

    public void write(Object packet) {
        if (!this.closed) {
            Protocol nextProtocol;
            DefinedPacket defined = null;
            if (packet instanceof PacketWrapper) {
                PacketWrapper wrapper = (PacketWrapper)packet;
                wrapper.setReleased(true);
                this.ch.writeAndFlush(wrapper.buf, this.ch.voidPromise());
                defined = wrapper.packet;
            } else {
                this.ch.writeAndFlush(packet, this.ch.voidPromise());
                if (packet instanceof DefinedPacket) {
                    defined = (DefinedPacket)packet;
                }
            }
            if (defined != null && (nextProtocol = defined.nextProtocol()) != null) {
                this.setEncodeProtocol(nextProtocol);
            }
        }
    }

    public void markClosed() {
        this.closing = true;
        this.closed = true;
    }

    public void close() {
        this.close(null);
    }

    public void close(Object packet) {
        if (!this.closed) {
            this.closing = true;
            this.closed = true;
            if (packet != null && this.ch.isActive()) {
                this.ch.writeAndFlush(packet).addListeners(new GenericFutureListener[]{ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE, ChannelFutureListener.CLOSE});
            } else {
                this.ch.flush();
                this.ch.close();
            }
        }
    }

    public void delayedClose(final Kick kick) {
        if (!this.closing) {
            this.closing = true;
            this.ch.eventLoop().schedule(new Runnable(){

                @Override
                public void run() {
                    ChannelWrapper.this.close(kick);
                }
            }, 250L, TimeUnit.MILLISECONDS);
        }
    }

    public void addBefore(String baseName, String name, ChannelHandler handler) {
        Preconditions.checkState(this.ch.eventLoop().inEventLoop(), "cannot add handler outside of event loop");
        this.ch.pipeline().flush();
        this.ch.pipeline().addBefore(baseName, name, handler);
    }

    public Channel getHandle() {
        return this.ch;
    }

    public void setCompressionThreshold(int compressionThreshold) {
        PacketCompressor compressor = this.ch.pipeline().get(PacketCompressor.class);
        PacketDecompressor decompressor = this.ch.pipeline().get(PacketDecompressor.class);
        if (compressionThreshold >= 0) {
            if (compressor == null) {
                compressor = new PacketCompressor();
                this.addBefore("packet-encoder", "compress", compressor);
            }
            compressor.setThreshold(compressionThreshold);
            if (decompressor == null) {
                decompressor = new PacketDecompressor();
                this.addBefore("packet-decoder", "decompress", decompressor);
            }
        } else {
            if (compressor != null) {
                this.ch.pipeline().remove("compress");
            }
            if (decompressor != null) {
                this.ch.pipeline().remove("decompress");
            }
        }
        this.updateComposite();
    }

    public void updateComposite() {
        boolean prependerCompose;
        CipherEncoder cipherEncoder = this.ch.pipeline().get(CipherEncoder.class);
        PacketCompressor packetCompressor = this.ch.pipeline().get(PacketCompressor.class);
        Varint21LengthFieldPrepender prepender = this.ch.pipeline().get(Varint21LengthFieldPrepender.class);
        boolean compressorCompose = cipherEncoder == null || cipherEncoder.getCipher().allowComposite();
        boolean bl = prependerCompose = compressorCompose && (packetCompressor == null || packetCompressor.getZlib().allowComposite());
        if (prepender != null) {
            ProxyServer.getInstance().getLogger().log(Level.FINE, "set prepender compose to {0} for {1}", new Object[]{prependerCompose, this.ch});
            prepender.setCompose(prependerCompose);
        }
        if (packetCompressor != null) {
            ProxyServer.getInstance().getLogger().log(Level.FINE, "set packetCompressor compose to {0} for {1}", new Object[]{compressorCompose, this.ch});
            packetCompressor.setCompose(compressorCompose);
        }
    }

    public void scheduleIfNecessary(Runnable task) {
        if (this.ch.eventLoop().inEventLoop()) {
            task.run();
            return;
        }
        this.ch.eventLoop().execute(task);
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isClosing() {
        return this.closing;
    }
}

