/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.chat;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.ComponentStyle;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;

public abstract class BaseComponent {
    BaseComponent parent;
    private ComponentStyle style = new ComponentStyle();
    private String insertion;
    private List<BaseComponent> extra;
    private ClickEvent clickEvent;
    private HoverEvent hoverEvent;
    private transient boolean reset;

    @Deprecated
    public BaseComponent() {
    }

    BaseComponent(BaseComponent old) {
        this.copyFormatting(old, ComponentBuilder.FormatRetention.ALL, true);
        if (old.getExtra() != null) {
            for (BaseComponent extra : old.getExtra()) {
                this.addExtra(extra.duplicate());
            }
        }
    }

    public void copyFormatting(BaseComponent component) {
        this.copyFormatting(component, ComponentBuilder.FormatRetention.ALL, true);
    }

    public void copyFormatting(BaseComponent component, boolean replace) {
        this.copyFormatting(component, ComponentBuilder.FormatRetention.ALL, replace);
    }

    public void copyFormatting(BaseComponent component, ComponentBuilder.FormatRetention retention, boolean replace) {
        if (retention == ComponentBuilder.FormatRetention.EVENTS || retention == ComponentBuilder.FormatRetention.ALL) {
            if (replace || this.clickEvent == null) {
                this.setClickEvent(component.getClickEvent());
            }
            if (replace || this.hoverEvent == null) {
                this.setHoverEvent(component.getHoverEvent());
            }
        }
        if (retention == ComponentBuilder.FormatRetention.FORMATTING || retention == ComponentBuilder.FormatRetention.ALL) {
            if (replace || !this.style.hasColor()) {
                this.setColor(component.getColorRaw());
            }
            if (replace || !this.style.hasShadowColor()) {
                this.setShadowColor(component.getShadowColorRaw());
            }
            if (replace || !this.style.hasFont()) {
                this.setFont(component.getFontRaw());
            }
            if (replace || this.style.isBoldRaw() == null) {
                this.setBold(component.isBoldRaw());
            }
            if (replace || this.style.isItalicRaw() == null) {
                this.setItalic(component.isItalicRaw());
            }
            if (replace || this.style.isUnderlinedRaw() == null) {
                this.setUnderlined(component.isUnderlinedRaw());
            }
            if (replace || this.style.isStrikethroughRaw() == null) {
                this.setStrikethrough(component.isStrikethroughRaw());
            }
            if (replace || this.style.isObfuscatedRaw() == null) {
                this.setObfuscated(component.isObfuscatedRaw());
            }
            if (replace || this.insertion == null) {
                this.setInsertion(component.getInsertion());
            }
        }
    }

    public void retain(ComponentBuilder.FormatRetention retention) {
        if (retention == ComponentBuilder.FormatRetention.FORMATTING || retention == ComponentBuilder.FormatRetention.NONE) {
            this.setClickEvent(null);
            this.setHoverEvent(null);
        }
        if (retention == ComponentBuilder.FormatRetention.EVENTS || retention == ComponentBuilder.FormatRetention.NONE) {
            this.setColor(null);
            this.setShadowColor(null);
            this.setBold(null);
            this.setItalic(null);
            this.setUnderlined(null);
            this.setStrikethrough(null);
            this.setObfuscated(null);
            this.setInsertion(null);
        }
    }

    public abstract BaseComponent duplicate();

    @Deprecated
    public BaseComponent duplicateWithoutFormatting() {
        BaseComponent component = this.duplicate();
        component.retain(ComponentBuilder.FormatRetention.NONE);
        return component;
    }

    public static String toLegacyText(BaseComponent ... components) {
        StringBuilder builder = new StringBuilder();
        for (BaseComponent msg : components) {
            builder.append(msg.toLegacyText());
        }
        return builder.toString();
    }

    public static String toPlainText(BaseComponent ... components) {
        StringBuilder builder = new StringBuilder();
        for (BaseComponent msg : components) {
            builder.append(msg.toPlainText());
        }
        return builder.toString();
    }

    public void setStyle(ComponentStyle style) {
        this.style = style != null ? style.clone() : new ComponentStyle();
    }

    public void setColor(ChatColor color) {
        this.style.setColor(color);
    }

    public ChatColor getColor() {
        if (!this.style.hasColor()) {
            if (this.parent == null) {
                return ChatColor.WHITE;
            }
            return this.parent.getColor();
        }
        return this.style.getColor();
    }

    public ChatColor getColorRaw() {
        return this.style.getColor();
    }

    public void setShadowColor(Color color) {
        this.style.setShadowColor(color);
    }

    public Color getShadowColor() {
        if (!this.style.hasShadowColor()) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getShadowColor();
        }
        return this.style.getShadowColor();
    }

    public Color getShadowColorRaw() {
        return this.style.getShadowColor();
    }

    public void setFont(String font) {
        this.style.setFont(font);
    }

    public String getFont() {
        if (!this.style.hasFont()) {
            if (this.parent == null) {
                return null;
            }
            return this.parent.getFont();
        }
        return this.style.getFont();
    }

    public String getFontRaw() {
        return this.style.getFont();
    }

    public void setBold(Boolean bold) {
        this.style.setBold(bold);
    }

    public boolean isBold() {
        if (this.style.isBoldRaw() == null) {
            return this.parent != null && this.parent.isBold();
        }
        return this.style.isBold();
    }

    public Boolean isBoldRaw() {
        return this.style.isBoldRaw();
    }

    public void setItalic(Boolean italic) {
        this.style.setItalic(italic);
    }

    public boolean isItalic() {
        if (this.style.isItalicRaw() == null) {
            return this.parent != null && this.parent.isItalic();
        }
        return this.style.isItalic();
    }

    public Boolean isItalicRaw() {
        return this.style.isItalicRaw();
    }

    public void setUnderlined(Boolean underlined) {
        this.style.setUnderlined(underlined);
    }

    public boolean isUnderlined() {
        if (this.style.isUnderlinedRaw() == null) {
            return this.parent != null && this.parent.isUnderlined();
        }
        return this.style.isUnderlined();
    }

    public Boolean isUnderlinedRaw() {
        return this.style.isUnderlinedRaw();
    }

    public void setStrikethrough(Boolean strikethrough) {
        this.style.setStrikethrough(strikethrough);
    }

    public boolean isStrikethrough() {
        if (this.style.isStrikethroughRaw() == null) {
            return this.parent != null && this.parent.isStrikethrough();
        }
        return this.style.isStrikethrough();
    }

    public Boolean isStrikethroughRaw() {
        return this.style.isStrikethroughRaw();
    }

    public void setObfuscated(Boolean obfuscated) {
        this.style.setObfuscated(obfuscated);
    }

    public boolean isObfuscated() {
        if (this.style.isObfuscatedRaw() == null) {
            return this.parent != null && this.parent.isObfuscated();
        }
        return this.style.isObfuscated();
    }

    public Boolean isObfuscatedRaw() {
        return this.style.isObfuscatedRaw();
    }

    public void applyStyle(ComponentStyle style) {
        if (style.hasColor()) {
            this.setColor(style.getColor());
        }
        if (style.hasShadowColor()) {
            this.setShadowColor(style.getShadowColor());
        }
        if (style.hasFont()) {
            this.setFont(style.getFont());
        }
        if (style.isBoldRaw() != null) {
            this.setBold(style.isBoldRaw());
        }
        if (style.isItalicRaw() != null) {
            this.setItalic(style.isItalicRaw());
        }
        if (style.isUnderlinedRaw() != null) {
            this.setUnderlined(style.isUnderlinedRaw());
        }
        if (style.isStrikethroughRaw() != null) {
            this.setStrikethrough(style.isStrikethroughRaw());
        }
        if (style.isObfuscatedRaw() != null) {
            this.setObfuscated(style.isObfuscatedRaw());
        }
    }

    public void setExtra(List<BaseComponent> components) {
        for (BaseComponent component : components) {
            component.parent = this;
        }
        this.extra = components;
    }

    public void addExtra(String text) {
        this.addExtra(new TextComponent(text));
    }

    public void addExtra(BaseComponent component) {
        if (this.extra == null) {
            this.extra = new ArrayList<BaseComponent>();
        }
        component.parent = this;
        this.extra.add(component);
    }

    public boolean hasStyle() {
        return !this.style.isEmpty();
    }

    public boolean hasFormatting() {
        return this.hasStyle() || this.insertion != null || this.hoverEvent != null || this.clickEvent != null;
    }

    public String toPlainText() {
        StringBuilder builder = new StringBuilder();
        this.toPlainText(builder);
        return builder.toString();
    }

    void toPlainText(StringBuilder builder) {
        if (this.extra != null) {
            for (BaseComponent e : this.extra) {
                e.toPlainText(builder);
            }
        }
    }

    public String toLegacyText() {
        StringBuilder builder = new StringBuilder();
        this.toLegacyText(builder);
        return builder.toString();
    }

    void toLegacyText(StringBuilder builder) {
        if (this.extra != null) {
            for (BaseComponent e : this.extra) {
                e.toLegacyText(builder);
            }
        }
    }

    void addFormat(StringBuilder builder) {
        builder.append(this.getColor());
        if (this.isBold()) {
            builder.append(ChatColor.BOLD);
        }
        if (this.isItalic()) {
            builder.append(ChatColor.ITALIC);
        }
        if (this.isUnderlined()) {
            builder.append(ChatColor.UNDERLINE);
        }
        if (this.isStrikethrough()) {
            builder.append(ChatColor.STRIKETHROUGH);
        }
        if (this.isObfuscated()) {
            builder.append(ChatColor.MAGIC);
        }
    }

    public void setInsertion(String insertion) {
        this.insertion = insertion;
    }

    public void setClickEvent(ClickEvent clickEvent) {
        this.clickEvent = clickEvent;
    }

    public void setHoverEvent(HoverEvent hoverEvent) {
        this.hoverEvent = hoverEvent;
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }

    public String toString() {
        return "BaseComponent(style=" + this.getStyle() + ", insertion=" + this.getInsertion() + ", extra=" + this.getExtra() + ", clickEvent=" + this.getClickEvent() + ", hoverEvent=" + this.getHoverEvent() + ", reset=" + this.isReset() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseComponent)) {
            return false;
        }
        BaseComponent other = (BaseComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ComponentStyle this$style = this.getStyle();
        ComponentStyle other$style = other.getStyle();
        if (this$style == null ? other$style != null : !((Object)this$style).equals(other$style)) {
            return false;
        }
        String this$insertion = this.getInsertion();
        String other$insertion = other.getInsertion();
        if (this$insertion == null ? other$insertion != null : !this$insertion.equals(other$insertion)) {
            return false;
        }
        List<BaseComponent> this$extra = this.getExtra();
        List<BaseComponent> other$extra = other.getExtra();
        if (this$extra == null ? other$extra != null : !((Object)this$extra).equals(other$extra)) {
            return false;
        }
        ClickEvent this$clickEvent = this.getClickEvent();
        ClickEvent other$clickEvent = other.getClickEvent();
        if (this$clickEvent == null ? other$clickEvent != null : !((Object)this$clickEvent).equals(other$clickEvent)) {
            return false;
        }
        HoverEvent this$hoverEvent = this.getHoverEvent();
        HoverEvent other$hoverEvent = other.getHoverEvent();
        return !(this$hoverEvent == null ? other$hoverEvent != null : !((Object)this$hoverEvent).equals(other$hoverEvent));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseComponent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ComponentStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)$style).hashCode());
        String $insertion = this.getInsertion();
        result = result * 59 + ($insertion == null ? 43 : $insertion.hashCode());
        List<BaseComponent> $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : ((Object)$extra).hashCode());
        ClickEvent $clickEvent = this.getClickEvent();
        result = result * 59 + ($clickEvent == null ? 43 : ((Object)$clickEvent).hashCode());
        HoverEvent $hoverEvent = this.getHoverEvent();
        result = result * 59 + ($hoverEvent == null ? 43 : ((Object)$hoverEvent).hashCode());
        return result;
    }

    public ComponentStyle getStyle() {
        return this.style;
    }

    public String getInsertion() {
        return this.insertion;
    }

    public List<BaseComponent> getExtra() {
        return this.extra;
    }

    public ClickEvent getClickEvent() {
        return this.clickEvent;
    }

    public HoverEvent getHoverEvent() {
        return this.hoverEvent;
    }

    public boolean isReset() {
        return this.reset;
    }
}

