/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.module.cmd.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.TabExecutor;

public class CommandList
extends Command
implements TabExecutor {
    public CommandList() {
        super("glist", "bungeecord.command.list", new String[0]);
    }

    public void execute(CommandSender sender, String[] args) {
        boolean hideEmptyServers = args.length == 0 || !args[0].equalsIgnoreCase("all");
        boolean moduleLoaded = ProxyServer.getInstance().getPluginManager().getPlugin("cmd_server") != null;
        for (ServerInfo server : ProxyServer.getInstance().getServers().values()) {
            if (!server.canAccess(sender)) continue;
            Collection serverPlayers = server.getPlayers();
            if (hideEmptyServers && serverPlayers.isEmpty()) continue;
            ArrayList<String> players = new ArrayList<String>();
            for (ProxiedPlayer player : serverPlayers) {
                players.add(player.getDisplayName());
            }
            Collections.sort(players, String.CASE_INSENSITIVE_ORDER);
            BaseComponent baseComponent = new ComponentBuilder().appendLegacy(ProxyServer.getInstance().getTranslation("command_list", new Object[]{server.getName(), players.size(), String.join((CharSequence)(ChatColor.RESET + ", "), players)})).build();
            if (moduleLoaded) {
                baseComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(new ComponentBuilder().appendLegacy(ProxyServer.getInstance().getTranslation("click_to_connect", new Object[0])).create())}));
                baseComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/server " + server.getName()));
            }
            sender.sendMessage(baseComponent);
        }
        sender.sendMessage(ProxyServer.getInstance().getTranslation("total_players", new Object[]{ProxyServer.getInstance().getOnlineCount()}));
    }

    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        return args.length > 1 ? Collections.emptyList() : Collections.singletonList("all");
    }
}

