/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.packet;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.md_5.bungee.Util;
import net.md_5.bungee.packet.Packet0KeepAlive;
import net.md_5.bungee.packet.Packet1Login;
import net.md_5.bungee.packet.Packet2Handshake;
import net.md_5.bungee.packet.Packet3Chat;
import net.md_5.bungee.packet.Packet9Respawn;
import net.md_5.bungee.packet.PacketC9PlayerListItem;
import net.md_5.bungee.packet.PacketCDClientStatus;
import net.md_5.bungee.packet.PacketFAPluginMessage;
import net.md_5.bungee.packet.PacketFCEncryptionResponse;
import net.md_5.bungee.packet.PacketFEPing;
import net.md_5.bungee.packet.PacketFFKick;
import net.md_5.bungee.packet.PacketHandler;

public abstract class DefinedPacket
implements DataOutput {
    private ByteArrayInputStream bin;
    private DataInputStream input;
    private ByteArrayDataOutput out;
    public final int id;
    private byte[] packet;
    private static Class<? extends DefinedPacket>[] classes = new Class[256];

    public DefinedPacket(int id, byte[] buf) {
        this.bin = new ByteArrayInputStream(buf);
        this.input = new DataInputStream(this.bin);
        if (this.readUnsignedByte() != id) {
            throw new IllegalArgumentException("Wasn't expecting packet id " + Util.hex(id));
        }
        this.id = id;
        this.packet = buf;
    }

    public DefinedPacket(int id) {
        this.out = ByteStreams.newDataOutput();
        this.id = id;
        this.writeByte(id);
    }

    public byte[] getPacket() {
        return this.packet == null ? (this.packet = this.out.toByteArray()) : this.packet;
    }

    @Override
    public void writeUTF(String s) {
        this.writeShort(s.length());
        this.writeChars(s);
    }

    public String readUTF() {
        int len = this.readShort();
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = this.readChar();
        }
        return new String(chars);
    }

    public void writeArray(byte[] b) {
        this.writeShort(b.length);
        this.write(b);
    }

    public byte[] readArray() {
        short len = this.readShort();
        byte[] ret = new byte[len];
        this.readFully(ret);
        return ret;
    }

    public final int available() {
        return this.bin.available();
    }

    public final void readFully(byte[] b) {
        try {
            this.input.readFully(b);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public final boolean readBoolean() {
        try {
            return this.input.readBoolean();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public final byte readByte() {
        try {
            return this.input.readByte();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public final int readUnsignedByte() {
        try {
            return this.input.readUnsignedByte();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public final short readShort() {
        try {
            return this.input.readShort();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public final char readChar() {
        try {
            return this.input.readChar();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public final int readInt() {
        try {
            return this.input.readInt();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    public abstract void handle(PacketHandler var1) throws Exception;

    public static DefinedPacket packet(byte[] buf) {
        int id = Util.getId(buf);
        Class<? extends DefinedPacket> clazz = classes[id];
        DefinedPacket ret = null;
        if (clazz != null) {
            try {
                Constructor<? extends DefinedPacket> constructor = clazz.getDeclaredConstructor(byte[].class);
                if (constructor != null) {
                    ret = constructor.newInstance(new Object[]{buf});
                }
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public void write(int arg0) {
        this.out.write(arg0);
    }

    @Override
    public void write(byte[] arg0) {
        this.out.write(arg0);
    }

    @Override
    public void write(byte[] arg0, int arg1, int arg2) {
        this.out.write(arg0, arg1, arg2);
    }

    @Override
    public void writeBoolean(boolean arg0) {
        this.out.writeBoolean(arg0);
    }

    @Override
    public void writeByte(int arg0) {
        this.out.writeByte(arg0);
    }

    @Override
    public void writeShort(int arg0) {
        this.out.writeShort(arg0);
    }

    @Override
    public void writeChar(int arg0) {
        this.out.writeChar(arg0);
    }

    @Override
    public void writeInt(int arg0) {
        this.out.writeInt(arg0);
    }

    @Override
    public void writeLong(long arg0) {
        this.out.writeLong(arg0);
    }

    @Override
    public void writeFloat(float arg0) {
        this.out.writeFloat(arg0);
    }

    @Override
    public void writeDouble(double arg0) {
        this.out.writeDouble(arg0);
    }

    @Override
    public void writeChars(String arg0) {
        this.out.writeChars(arg0);
    }

    @Override
    @Deprecated
    public void writeBytes(String arg0) {
        this.out.writeBytes(arg0);
    }

    public byte[] toByteArray() {
        return this.out.toByteArray();
    }

    static {
        DefinedPacket.classes[0] = Packet0KeepAlive.class;
        DefinedPacket.classes[1] = Packet1Login.class;
        DefinedPacket.classes[2] = Packet2Handshake.class;
        DefinedPacket.classes[3] = Packet3Chat.class;
        DefinedPacket.classes[9] = Packet9Respawn.class;
        DefinedPacket.classes[201] = PacketC9PlayerListItem.class;
        DefinedPacket.classes[205] = PacketCDClientStatus.class;
        DefinedPacket.classes[250] = PacketFAPluginMessage.class;
        DefinedPacket.classes[252] = PacketFCEncryptionResponse.class;
        DefinedPacket.classes[254] = PacketFEPing.class;
        DefinedPacket.classes[255] = PacketFFKick.class;
    }

    private static interface Overriden {
        public void readUTF();

        public void writeUTF(String var1);
    }
}

