/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.EnumSet;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PlayerPublicKey;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.packet.PlayerListItem;

public class PlayerListItemUpdate
extends DefinedPacket {
    private EnumSet<Action> actions;
    private PlayerListItem.Item[] items;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.actions = PlayerListItemUpdate.readEnumSet(Action.class, buf);
        this.items = new PlayerListItem.Item[DefinedPacket.readVarInt(buf)];
        for (int i = 0; i < this.items.length; ++i) {
            PlayerListItem.Item item = this.items[i] = new PlayerListItem.Item();
            item.setUuid(DefinedPacket.readUUID(buf));
            for (Action action : this.actions) {
                switch (action) {
                    case ADD_PLAYER: {
                        item.username = DefinedPacket.readString(buf);
                        item.properties = DefinedPacket.readProperties(buf);
                        break;
                    }
                    case INITIALIZE_CHAT: {
                        if (!buf.readBoolean()) break;
                        item.chatSessionId = PlayerListItemUpdate.readUUID(buf);
                        item.publicKey = new PlayerPublicKey(buf.readLong(), PlayerListItemUpdate.readArray(buf, 512), PlayerListItemUpdate.readArray(buf, 4096));
                        break;
                    }
                    case UPDATE_GAMEMODE: {
                        item.gamemode = DefinedPacket.readVarInt(buf);
                        break;
                    }
                    case UPDATE_LISTED: {
                        item.listed = buf.readBoolean();
                        break;
                    }
                    case UPDATE_LATENCY: {
                        item.ping = DefinedPacket.readVarInt(buf);
                        break;
                    }
                    case UPDATE_DISPLAY_NAME: {
                        if (!buf.readBoolean()) break;
                        item.displayName = DefinedPacket.readBaseComponent(buf, protocolVersion);
                        break;
                    }
                    case UPDATE_LIST_ORDER: {
                        item.listOrder = DefinedPacket.readVarInt(buf);
                    }
                }
            }
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        DefinedPacket.writeEnumSet(this.actions, Action.class, buf);
        DefinedPacket.writeVarInt(this.items.length, buf);
        for (PlayerListItem.Item item : this.items) {
            DefinedPacket.writeUUID(item.uuid, buf);
            for (Action action : this.actions) {
                switch (action) {
                    case ADD_PLAYER: {
                        DefinedPacket.writeString(item.username, buf);
                        DefinedPacket.writeProperties(item.properties, buf);
                        break;
                    }
                    case INITIALIZE_CHAT: {
                        buf.writeBoolean(item.chatSessionId != null);
                        if (item.chatSessionId == null) break;
                        PlayerListItemUpdate.writeUUID(item.chatSessionId, buf);
                        buf.writeLong(item.publicKey.getExpiry());
                        PlayerListItemUpdate.writeArray(item.publicKey.getKey(), buf);
                        PlayerListItemUpdate.writeArray(item.publicKey.getSignature(), buf);
                        break;
                    }
                    case UPDATE_GAMEMODE: {
                        DefinedPacket.writeVarInt(item.gamemode, buf);
                        break;
                    }
                    case UPDATE_LISTED: {
                        buf.writeBoolean(item.listed);
                        break;
                    }
                    case UPDATE_LATENCY: {
                        DefinedPacket.writeVarInt(item.ping, buf);
                        break;
                    }
                    case UPDATE_DISPLAY_NAME: {
                        buf.writeBoolean(item.displayName != null);
                        if (item.displayName == null) break;
                        DefinedPacket.writeBaseComponent(item.displayName, buf, protocolVersion);
                        break;
                    }
                    case UPDATE_LIST_ORDER: {
                        DefinedPacket.writeVarInt(item.listOrder, buf);
                    }
                }
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public EnumSet<Action> getActions() {
        return this.actions;
    }

    public PlayerListItem.Item[] getItems() {
        return this.items;
    }

    public void setActions(EnumSet<Action> actions) {
        this.actions = actions;
    }

    public void setItems(PlayerListItem.Item[] items) {
        this.items = items;
    }

    @Override
    public String toString() {
        return "PlayerListItemUpdate(actions=" + this.getActions() + ", items=" + Arrays.deepToString(this.getItems()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerListItemUpdate)) {
            return false;
        }
        PlayerListItemUpdate other = (PlayerListItemUpdate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EnumSet<Action> this$actions = this.getActions();
        EnumSet<Action> other$actions = other.getActions();
        if (this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions)) {
            return false;
        }
        return Arrays.deepEquals(this.getItems(), other.getItems());
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerListItemUpdate;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EnumSet<Action> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getItems());
        return result;
    }

    public static enum Action {
        ADD_PLAYER,
        INITIALIZE_CHAT,
        UPDATE_GAMEMODE,
        UPDATE_LISTED,
        UPDATE_LATENCY,
        UPDATE_DISPLAY_NAME,
        UPDATE_LIST_ORDER;

    }
}

