/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.chat;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Map;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.ComponentStyle;
import net.md_5.bungee.api.chat.ComponentStyleBuilder;

public class ComponentStyleSerializer
implements JsonSerializer<ComponentStyle>,
JsonDeserializer<ComponentStyle> {
    private static boolean getAsBoolean(JsonElement el) {
        if (el.isJsonPrimitive()) {
            Number number;
            JsonPrimitive primitive = (JsonPrimitive)el;
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isNumber() && (number = primitive.getAsNumber()) instanceof Byte) {
                return number.byteValue() != 0;
            }
        }
        return false;
    }

    static void serializeTo(ComponentStyle style, JsonObject object) {
        if (style.isBoldRaw() != null) {
            object.addProperty("bold", style.isBoldRaw());
        }
        if (style.isItalicRaw() != null) {
            object.addProperty("italic", style.isItalicRaw());
        }
        if (style.isUnderlinedRaw() != null) {
            object.addProperty("underlined", style.isUnderlinedRaw());
        }
        if (style.isStrikethroughRaw() != null) {
            object.addProperty("strikethrough", style.isStrikethroughRaw());
        }
        if (style.isObfuscatedRaw() != null) {
            object.addProperty("obfuscated", style.isObfuscatedRaw());
        }
        if (style.hasColor() && style.getColor().getColor() != null) {
            object.addProperty("color", style.getColor().getName());
        }
        if (style.hasFont()) {
            object.addProperty("font", style.getFont());
        }
    }

    @Override
    public ComponentStyle deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ComponentStyleBuilder builder = ComponentStyle.builder();
        JsonObject object = json.getAsJsonObject();
        for (Map.Entry<String, JsonElement> entry : object.entrySet()) {
            String name = entry.getKey();
            JsonElement value = entry.getValue();
            switch (name) {
                case "bold": {
                    builder.bold(ComponentStyleSerializer.getAsBoolean(value));
                    break;
                }
                case "italic": {
                    builder.italic(ComponentStyleSerializer.getAsBoolean(value));
                    break;
                }
                case "underlined": {
                    builder.underlined(ComponentStyleSerializer.getAsBoolean(value));
                    break;
                }
                case "strikethrough": {
                    builder.strikethrough(ComponentStyleSerializer.getAsBoolean(value));
                    break;
                }
                case "obfuscated": {
                    builder.obfuscated(ComponentStyleSerializer.getAsBoolean(value));
                    break;
                }
                case "color": {
                    builder.color(ChatColor.of(value.getAsString()));
                    break;
                }
                case "font": {
                    builder.font(value.getAsString());
                }
            }
        }
        return builder.build();
    }

    @Override
    public JsonElement serialize(ComponentStyle src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        ComponentStyleSerializer.serializeTo(src, object);
        return object;
    }
}

