/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.NumberFormat;
import net.md_5.bungee.protocol.ProtocolConstants;

public class ScoreboardScore
extends DefinedPacket {
    private String itemName;
    private byte action;
    private String scoreName;
    private int value;
    private BaseComponent displayName;
    private NumberFormat numberFormat;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.itemName = ScoreboardScore.readString(buf);
        this.action = protocolVersion >= 765 ? (byte)0 : buf.readByte();
        this.scoreName = ScoreboardScore.readString(buf);
        if (this.action != 1) {
            this.value = ScoreboardScore.readVarInt(buf);
        }
        if (protocolVersion >= 765) {
            this.displayName = (BaseComponent)this.readNullable(b -> ScoreboardScore.readBaseComponent(b, protocolVersion), buf);
            this.numberFormat = (NumberFormat)this.readNullable(b -> ScoreboardScore.readNumberFormat(b, protocolVersion), buf);
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        ScoreboardScore.writeString(this.itemName, buf);
        if (protocolVersion < 765) {
            buf.writeByte(this.action);
        }
        ScoreboardScore.writeString(this.scoreName, buf);
        if (this.action != 1 || protocolVersion >= 765) {
            ScoreboardScore.writeVarInt(this.value, buf);
        }
        if (protocolVersion >= 765) {
            this.writeNullable(this.displayName, (s2, b) -> DefinedPacket.writeBaseComponent(s2, b, protocolVersion), buf);
            this.writeNullable(this.numberFormat, (s2, b) -> DefinedPacket.writeNumberFormat(s2, b, protocolVersion), buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public String getItemName() {
        return this.itemName;
    }

    public byte getAction() {
        return this.action;
    }

    public String getScoreName() {
        return this.scoreName;
    }

    public int getValue() {
        return this.value;
    }

    public BaseComponent getDisplayName() {
        return this.displayName;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public void setAction(byte action) {
        this.action = action;
    }

    public void setScoreName(String scoreName) {
        this.scoreName = scoreName;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public void setDisplayName(BaseComponent displayName) {
        this.displayName = displayName;
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
    }

    @Override
    public String toString() {
        return "ScoreboardScore(itemName=" + this.getItemName() + ", action=" + this.getAction() + ", scoreName=" + this.getScoreName() + ", value=" + this.getValue() + ", displayName=" + this.getDisplayName() + ", numberFormat=" + this.getNumberFormat() + ")";
    }

    public ScoreboardScore() {
    }

    public ScoreboardScore(String itemName, byte action, String scoreName, int value, BaseComponent displayName, NumberFormat numberFormat) {
        this.itemName = itemName;
        this.action = action;
        this.scoreName = scoreName;
        this.value = value;
        this.displayName = displayName;
        this.numberFormat = numberFormat;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScoreboardScore)) {
            return false;
        }
        ScoreboardScore other = (ScoreboardScore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAction() != other.getAction()) {
            return false;
        }
        if (this.getValue() != other.getValue()) {
            return false;
        }
        String this$itemName = this.getItemName();
        String other$itemName = other.getItemName();
        if (this$itemName == null ? other$itemName != null : !this$itemName.equals(other$itemName)) {
            return false;
        }
        String this$scoreName = this.getScoreName();
        String other$scoreName = other.getScoreName();
        if (this$scoreName == null ? other$scoreName != null : !this$scoreName.equals(other$scoreName)) {
            return false;
        }
        BaseComponent this$displayName = this.getDisplayName();
        BaseComponent other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !((Object)this$displayName).equals(other$displayName)) {
            return false;
        }
        NumberFormat this$numberFormat = this.getNumberFormat();
        NumberFormat other$numberFormat = other.getNumberFormat();
        return !(this$numberFormat == null ? other$numberFormat != null : !((Object)this$numberFormat).equals(other$numberFormat));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScoreboardScore;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAction();
        result = result * 59 + this.getValue();
        String $itemName = this.getItemName();
        result = result * 59 + ($itemName == null ? 43 : $itemName.hashCode());
        String $scoreName = this.getScoreName();
        result = result * 59 + ($scoreName == null ? 43 : $scoreName.hashCode());
        BaseComponent $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : ((Object)$displayName).hashCode());
        NumberFormat $numberFormat = this.getNumberFormat();
        result = result * 59 + ($numberFormat == null ? 43 : ((Object)$numberFormat).hashCode());
        return result;
    }
}

