/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.nbt;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import se.llbit.nbt.ErrorTag;
import se.llbit.nbt.SpecificTag;

public class IntTag
extends SpecificTag {
    public final int value;

    public static SpecificTag read(DataInputStream in) {
        try {
            return new IntTag(in.readInt());
        }
        catch (IOException e) {
            return new ErrorTag("IOException while reading TAG_Int:\n" + e.getMessage());
        }
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeInt(this.value);
    }

    public IntTag(boolean boolValue) {
        this(boolValue ? 1 : 0);
    }

    public IntTag(int value) {
        this.value = value;
    }

    public int getData() {
        return this.value;
    }

    @Override
    public String extraInfo() {
        return ": " + this.getData();
    }

    public String type() {
        return "TAG_Int";
    }

    @Override
    public String tagName() {
        return "TAG_Int";
    }

    @Override
    public int tagType() {
        return 3;
    }

    @Override
    public boolean boolValue() {
        return this.getData() != 0;
    }

    @Override
    public boolean boolValue(boolean defaultValue) {
        return this.getData() != 0;
    }

    @Override
    public int intValue() {
        return this.getData();
    }

    @Override
    public int intValue(int defaultValue) {
        return this.getData();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof IntTag && ((IntTag)obj).value == this.value;
    }

    public int hashCode() {
        return this.value;
    }
}

