/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.crypto.SecretKey;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.EncryptionUtil;
import net.md_5.bungee.KickException;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.packet.DefinedPacket;
import net.md_5.bungee.packet.Packet1Login;
import net.md_5.bungee.packet.Packet2Handshake;
import net.md_5.bungee.packet.PacketCDClientStatus;
import net.md_5.bungee.packet.PacketFAPluginMessage;
import net.md_5.bungee.packet.PacketFCEncryptionResponse;
import net.md_5.bungee.packet.PacketFDEncryptionRequest;
import net.md_5.bungee.packet.PacketFEPing;
import net.md_5.bungee.packet.PacketFFKick;
import net.md_5.bungee.packet.PacketHandler;
import net.md_5.bungee.packet.PacketStream;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.io.CipherOutputStream;

public class InitialHandler
extends PacketHandler
implements Runnable,
PendingConnection {
    private final Socket socket;
    private final ListenerInfo listener;
    private PacketStream stream;
    private Packet2Handshake handshake;
    private PacketFDEncryptionRequest request;
    private State thisState = State.HANDSHAKE;
    private int protocol = 0;

    public InitialHandler(Socket socket, ListenerInfo info) throws IOException {
        this.socket = socket;
        this.listener = info;
        this.stream = new PacketStream(socket.getInputStream(), socket.getOutputStream(), this.protocol);
    }

    @Override
    public void handle(Packet1Login login) throws Exception {
    }

    @Override
    public void handle(PacketFAPluginMessage pluginMessage) throws Exception {
    }

    @Override
    public void handle(PacketFEPing ping) throws Exception {
        this.socket.setSoTimeout(100);
        boolean newPing = false;
        try {
            this.socket.getInputStream().read();
            newPing = true;
        }
        catch (IOException ex) {
            // empty catch block
        }
        ServerPing pingevent = new ServerPing(51, "1.4.6", this.listener.getMotd(), ProxyServer.getInstance().getPlayers().size(), this.listener.getMaxPlayers());
        pingevent = ProxyServer.getInstance().getPluginManager().callEvent(new ProxyPingEvent(this, pingevent)).getResponse();
        String response = newPing ? "\u00a71\u0000" + pingevent.getProtocolVersion() + "\u0000" + pingevent.getGameVersion() + "\u0000" + pingevent.getMotd() + "\u0000" + pingevent.getCurrentPlayers() + "\u0000" + pingevent.getMaxPlayers() : pingevent.getMotd() + '\u00a7' + pingevent.getCurrentPlayers() + '\u00a7' + pingevent.getMaxPlayers();
        this.disconnect(response);
    }

    @Override
    public void handle(Packet2Handshake handshake) throws Exception {
        Preconditions.checkState(this.thisState == State.HANDSHAKE, "Not expecting HANDSHAKE");
        this.handshake = handshake;
        this.request = EncryptionUtil.encryptRequest();
        this.stream.write(this.request);
        this.thisState = State.ENCRYPT;
    }

    @Override
    public void handle(PacketFCEncryptionResponse encryptResponse) throws Exception {
        LoginEvent event;
        Preconditions.checkState(this.thisState == State.ENCRYPT, "Not expecting ENCRYPT");
        SecretKey shared = EncryptionUtil.getSecret(encryptResponse, this.request);
        if (!EncryptionUtil.isAuthenticated(this.handshake.username, this.request.serverId, shared)) {
            throw new KickException("Not authenticated with minecraft.net");
        }
        ProxiedPlayer old = ProxyServer.getInstance().getPlayer(this.handshake.username);
        if (old != null) {
            old.disconnect("You are already connected to the server");
        }
        if ((event = new LoginEvent(this)).isCancelled()) {
            this.disconnect(event.getCancelReason());
        }
        this.stream.write(new PacketFCEncryptionResponse());
        this.stream = new PacketStream(new CipherInputStream(this.socket.getInputStream(), EncryptionUtil.getCipher(false, shared)), new CipherOutputStream(this.socket.getOutputStream(), EncryptionUtil.getCipher(true, shared)), this.protocol);
        this.thisState = State.LOGIN;
    }

    @Override
    public void handle(PacketCDClientStatus clientStatus) throws Exception {
        Preconditions.checkState(this.thisState == State.LOGIN, "Not expecting LOGIN");
        UserConnection userCon = new UserConnection(this.socket, this, this.stream, this.handshake);
        String server = ProxyServer.getInstance().getReconnectHandler().getServer(userCon);
        ServerInfo s = BungeeCord.getInstance().config.getServers().get(server);
        userCon.connect(s, true);
        this.thisState = State.FINISHED;
    }

    @Override
    public void run() {
        try {
            while (this.thisState != State.FINISHED) {
                byte[] buf = this.stream.readPacket();
                DefinedPacket packet = DefinedPacket.packet(buf);
                packet.handle(this);
            }
        }
        catch (Exception ex) {
            this.disconnect("[Proxy Error] " + Util.exception(ex));
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(String reason) {
        this.thisState = State.FINISHED;
        try {
            this.stream.write(new PacketFFKick(reason));
        }
        catch (IOException ioe) {
        }
        finally {
            try {
                this.socket.shutdownOutput();
                this.socket.close();
            }
            catch (IOException ioe2) {}
        }
    }

    @Override
    public String getName() {
        return this.handshake == null ? null : this.handshake.username;
    }

    @Override
    public byte getVersion() {
        return this.handshake == null ? (byte)-1 : this.handshake.procolVersion;
    }

    @Override
    public InetSocketAddress getVirtualHost() {
        return this.handshake == null ? null : new InetSocketAddress(this.handshake.host, this.handshake.port);
    }

    @Override
    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.socket.getRemoteSocketAddress();
    }

    @Override
    public ListenerInfo getListener() {
        return this.listener;
    }

    private static enum State {
        HANDSHAKE,
        ENCRYPT,
        LOGIN,
        FINISHED;

    }
}

