/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.beans.ConstructorProperties;
import java.io.IOException;
import java.net.Socket;
import net.md_5.bungee.Logger;
import net.md_5.bungee.packet.PacketFFKick;
import net.md_5.bungee.packet.PacketStream;

public class GenericConnection {
    protected final Socket socket;
    protected final PacketStream stream;
    public String name;
    public String displayName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(String reason) {
        if (this.socket.isClosed()) {
            return;
        }
        this.log("disconnected with " + reason);
        try {
            this.stream.write(new PacketFFKick("[Proxy] " + reason));
        }
        catch (IOException ex) {
        }
        finally {
            try {
                this.socket.shutdownOutput();
                this.socket.close();
            }
            catch (IOException ioe) {}
        }
    }

    public void log(String message) {
        Logger.$().info(this.socket.getInetAddress() + (this.name == null ? " " : " [" + this.name + "] ") + message);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericConnection)) {
            return false;
        }
        GenericConnection other = (GenericConnection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Socket this$socket = this.socket;
        Socket other$socket = other.socket;
        if (this$socket == null ? other$socket != null : !this$socket.equals(other$socket)) {
            return false;
        }
        PacketStream this$stream = this.stream;
        PacketStream other$stream = other.stream;
        if (this$stream == null ? other$stream != null : !this$stream.equals(other$stream)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
    }

    public boolean canEqual(Object other) {
        return other instanceof GenericConnection;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        Socket $socket = this.socket;
        result = result * 31 + ($socket == null ? 0 : $socket.hashCode());
        PacketStream $stream = this.stream;
        result = result * 31 + ($stream == null ? 0 : $stream.hashCode());
        String $name = this.getName();
        result = result * 31 + ($name == null ? 0 : $name.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 31 + ($displayName == null ? 0 : $displayName.hashCode());
        return result;
    }

    @ConstructorProperties(value={"socket", "stream"})
    public GenericConnection(Socket socket, PacketStream stream) {
        this.socket = socket;
        this.stream = stream;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

