/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class ServerData
extends DefinedPacket {
    private BaseComponent motd;
    private Object icon;
    private boolean preview;
    private boolean enforceSecure;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 762 || buf.readBoolean()) {
            this.motd = ServerData.readBaseComponent(buf, protocolVersion);
        }
        if (buf.readBoolean()) {
            this.icon = protocolVersion >= 762 ? (Object)ServerData.readArray(buf) : ServerData.readString(buf);
        }
        if (protocolVersion < 761) {
            this.preview = buf.readBoolean();
        }
        if (protocolVersion >= 760 && protocolVersion < 0x400000B0) {
            this.enforceSecure = buf.readBoolean();
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (this.motd != null) {
            if (protocolVersion >= 762) {
                buf.writeBoolean(true);
            }
            ServerData.writeBaseComponent(this.motd, buf, protocolVersion);
        } else {
            if (protocolVersion >= 762) {
                throw new IllegalArgumentException("MOTD required for this version");
            }
            buf.writeBoolean(false);
        }
        if (this.icon != null) {
            buf.writeBoolean(true);
            if (protocolVersion >= 762) {
                ServerData.writeArray((byte[])this.icon, buf);
            } else {
                ServerData.writeString((String)this.icon, buf);
            }
        } else {
            buf.writeBoolean(false);
        }
        if (protocolVersion < 761) {
            buf.writeBoolean(this.preview);
        }
        if (protocolVersion >= 760 && protocolVersion < 0x400000B0) {
            buf.writeBoolean(this.enforceSecure);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public BaseComponent getMotd() {
        return this.motd;
    }

    public Object getIcon() {
        return this.icon;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public boolean isEnforceSecure() {
        return this.enforceSecure;
    }

    public void setMotd(BaseComponent motd) {
        this.motd = motd;
    }

    public void setIcon(Object icon) {
        this.icon = icon;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public void setEnforceSecure(boolean enforceSecure) {
        this.enforceSecure = enforceSecure;
    }

    @Override
    public String toString() {
        return "ServerData(motd=" + this.getMotd() + ", icon=" + this.getIcon() + ", preview=" + this.isPreview() + ", enforceSecure=" + this.isEnforceSecure() + ")";
    }

    public ServerData() {
    }

    public ServerData(BaseComponent motd, Object icon, boolean preview, boolean enforceSecure) {
        this.motd = motd;
        this.icon = icon;
        this.preview = preview;
        this.enforceSecure = enforceSecure;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerData)) {
            return false;
        }
        ServerData other = (ServerData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPreview() != other.isPreview()) {
            return false;
        }
        if (this.isEnforceSecure() != other.isEnforceSecure()) {
            return false;
        }
        BaseComponent this$motd = this.getMotd();
        BaseComponent other$motd = other.getMotd();
        if (this$motd == null ? other$motd != null : !((Object)this$motd).equals(other$motd)) {
            return false;
        }
        Object this$icon = this.getIcon();
        Object other$icon = other.getIcon();
        return !(this$icon == null ? other$icon != null : !this$icon.equals(other$icon));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPreview() ? 79 : 97);
        result = result * 59 + (this.isEnforceSecure() ? 79 : 97);
        BaseComponent $motd = this.getMotd();
        result = result * 59 + ($motd == null ? 43 : ((Object)$motd).hashCode());
        Object $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        return result;
    }
}

