/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.module;

public class ModuleVersion {
    private final String build;
    private final String git;

    public static ModuleVersion parse(String version) {
        int lastColon = version.lastIndexOf(58);
        int secondLastColon = version.lastIndexOf(58, lastColon - 1);
        if (lastColon == -1 || secondLastColon == -1) {
            return null;
        }
        String buildNumber = version.substring(lastColon + 1, version.length());
        String gitCommit = version.substring(secondLastColon + 1, lastColon).replaceAll("\"", "");
        if ("unknown".equals(buildNumber) || "unknown".equals(gitCommit)) {
            return null;
        }
        return new ModuleVersion(buildNumber, gitCommit);
    }

    public String getBuild() {
        return this.build;
    }

    public String getGit() {
        return this.git;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModuleVersion)) {
            return false;
        }
        ModuleVersion other = (ModuleVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$build = this.getBuild();
        String other$build = other.getBuild();
        if (this$build == null ? other$build != null : !this$build.equals(other$build)) {
            return false;
        }
        String this$git = this.getGit();
        String other$git = other.getGit();
        return !(this$git == null ? other$git != null : !this$git.equals(other$git));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModuleVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $build = this.getBuild();
        result = result * 59 + ($build == null ? 43 : $build.hashCode());
        String $git = this.getGit();
        result = result * 59 + ($git == null ? 43 : $git.hashCode());
        return result;
    }

    public String toString() {
        return "ModuleVersion(build=" + this.getBuild() + ", git=" + this.getGit() + ")";
    }

    private ModuleVersion(String build, String git) {
        this.build = build;
        this.git = git;
    }
}

