/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.compress.PacketCompressor;
import net.md_5.bungee.compress.PacketDecompressor;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.MinecraftDecoder;
import net.md_5.bungee.protocol.MinecraftEncoder;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.Kick;

public class ChannelWrapper {
    private final Channel ch;
    private SocketAddress remoteAddress;
    private volatile boolean closed;
    private volatile boolean closing;

    public ChannelWrapper(ChannelHandlerContext ctx) {
        this.ch = ctx.channel();
        this.remoteAddress = this.ch.remoteAddress() == null ? this.ch.parent().localAddress() : this.ch.remoteAddress();
    }

    public Protocol getDecodeProtocol() {
        return this.ch.pipeline().get(MinecraftDecoder.class).getProtocol();
    }

    public void setDecodeProtocol(Protocol protocol) {
        this.ch.pipeline().get(MinecraftDecoder.class).setProtocol(protocol);
    }

    public Protocol getEncodeProtocol() {
        return this.ch.pipeline().get(MinecraftEncoder.class).getProtocol();
    }

    public void setEncodeProtocol(Protocol protocol) {
        this.ch.pipeline().get(MinecraftEncoder.class).setProtocol(protocol);
    }

    public void setProtocol(Protocol protocol) {
        this.setDecodeProtocol(protocol);
        this.setEncodeProtocol(protocol);
    }

    public void setVersion(int protocol) {
        this.ch.pipeline().get(MinecraftDecoder.class).setProtocolVersion(protocol);
        this.ch.pipeline().get(MinecraftEncoder.class).setProtocolVersion(protocol);
    }

    public int getEncodeVersion() {
        return this.ch.pipeline().get(MinecraftEncoder.class).getProtocolVersion();
    }

    public void write(Object packet) {
        if (!this.closed) {
            Protocol nextProtocol;
            DefinedPacket defined = null;
            if (packet instanceof PacketWrapper) {
                PacketWrapper wrapper = (PacketWrapper)packet;
                wrapper.setReleased(true);
                this.ch.writeAndFlush(wrapper.buf, this.ch.voidPromise());
                defined = wrapper.packet;
            } else {
                this.ch.writeAndFlush(packet, this.ch.voidPromise());
                if (packet instanceof DefinedPacket) {
                    defined = (DefinedPacket)packet;
                }
            }
            if (defined != null && (nextProtocol = defined.nextProtocol()) != null) {
                this.setEncodeProtocol(nextProtocol);
            }
        }
    }

    public void markClosed() {
        this.closing = true;
        this.closed = true;
    }

    public void close() {
        this.close(null);
    }

    public void close(Object packet) {
        if (!this.closed) {
            this.closing = true;
            this.closed = true;
            if (packet != null && this.ch.isActive()) {
                this.ch.writeAndFlush(packet).addListeners(new GenericFutureListener[]{ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE, ChannelFutureListener.CLOSE});
            } else {
                this.ch.flush();
                this.ch.close();
            }
        }
    }

    public void delayedClose(final Kick kick) {
        if (!this.closing) {
            this.closing = true;
            this.ch.eventLoop().schedule(new Runnable(){

                @Override
                public void run() {
                    ChannelWrapper.this.close(kick);
                }
            }, 250L, TimeUnit.MILLISECONDS);
        }
    }

    public void addBefore(String baseName, String name, ChannelHandler handler) {
        Preconditions.checkState(this.ch.eventLoop().inEventLoop(), "cannot add handler outside of event loop");
        this.ch.pipeline().flush();
        this.ch.pipeline().addBefore(baseName, name, handler);
    }

    public Channel getHandle() {
        return this.ch;
    }

    public void setCompressionThreshold(int compressionThreshold) {
        if (this.ch.pipeline().get(PacketCompressor.class) == null && compressionThreshold >= 0) {
            this.addBefore("packet-encoder", "compress", new PacketCompressor());
        }
        if (compressionThreshold >= 0) {
            this.ch.pipeline().get(PacketCompressor.class).setThreshold(compressionThreshold);
        } else {
            this.ch.pipeline().remove("compress");
        }
        if (this.ch.pipeline().get(PacketDecompressor.class) == null && compressionThreshold >= 0) {
            this.addBefore("packet-decoder", "decompress", new PacketDecompressor());
        }
        if (compressionThreshold < 0) {
            this.ch.pipeline().remove("decompress");
        }
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isClosing() {
        return this.closing;
    }
}

