/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class SystemChat
extends DefinedPacket {
    private BaseComponent message;
    private int position;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.message = SystemChat.readBaseComponent(buf, protocolVersion);
        this.position = protocolVersion >= 760 ? (buf.readBoolean() ? ChatMessageType.ACTION_BAR.ordinal() : 0) : SystemChat.readVarInt(buf);
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        SystemChat.writeBaseComponent(this.message, buf, protocolVersion);
        if (protocolVersion >= 760) {
            buf.writeBoolean(this.position == ChatMessageType.ACTION_BAR.ordinal());
        } else {
            SystemChat.writeVarInt(this.position, buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public BaseComponent getMessage() {
        return this.message;
    }

    public int getPosition() {
        return this.position;
    }

    public void setMessage(BaseComponent message) {
        this.message = message;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    @Override
    public String toString() {
        return "SystemChat(message=" + this.getMessage() + ", position=" + this.getPosition() + ")";
    }

    public SystemChat() {
    }

    public SystemChat(BaseComponent message, int position) {
        this.message = message;
        this.position = position;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SystemChat)) {
            return false;
        }
        SystemChat other = (SystemChat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPosition() != other.getPosition()) {
            return false;
        }
        BaseComponent this$message = this.getMessage();
        BaseComponent other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SystemChat;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPosition();
        BaseComponent $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        return result;
    }
}

