/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import lombok.NonNull;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.PlayerSkinConfiguration;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.ServerConnector;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ServerConnectRequest;
import net.md_5.bungee.api.SkinConfiguration;
import net.md_5.bungee.api.Title;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PermissionCheckEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.score.Scoreboard;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.entitymap.EntityMap;
import net.md_5.bungee.forge.ForgeClientHandler;
import net.md_5.bungee.forge.ForgeServerHandler;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.MinecraftDecoder;
import net.md_5.bungee.protocol.MinecraftEncoder;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.ClientSettings;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.PlayerListHeaderFooter;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.SetCompression;
import net.md_5.bungee.protocol.packet.SystemChat;
import net.md_5.bungee.protocol.packet.Title;
import net.md_5.bungee.tab.ServerUnique;
import net.md_5.bungee.tab.TabList;
import net.md_5.bungee.util.CaseInsensitiveSet;
import net.md_5.bungee.util.ChatComponentTransformer;

public final class UserConnection
implements ProxiedPlayer {
    @NonNull
    private final ProxyServer bungee;
    @NonNull
    private final ChannelWrapper ch;
    @NonNull
    private final String name;
    private final InitialHandler pendingConnection;
    private ServerConnection server;
    private Object dimension;
    private boolean dimensionChange = true;
    private final Collection<ServerInfo> pendingConnects = new HashSet<ServerInfo>();
    private int ping = 100;
    private ServerInfo reconnectServer;
    private TabList tabListHandler;
    private int gamemode;
    private int compressionThreshold = -1;
    private Queue<String> serverJoinQueue;
    private final Collection<String> groups = new CaseInsensitiveSet();
    private final Collection<String> permissions = new CaseInsensitiveSet();
    private int clientEntityId;
    private int serverEntityId;
    private ClientSettings settings;
    private final Scoreboard serverSentScoreboard = new Scoreboard();
    private final Collection<UUID> sentBossBars = new HashSet<UUID>();
    private String lastCommandTabbed;
    private String displayName;
    private EntityMap entityRewrite;
    private Locale locale;
    private ForgeClientHandler forgeClientHandler;
    private ForgeServerHandler forgeServerHandler;
    private final Queue<DefinedPacket> packetQueue = new ConcurrentLinkedQueue<DefinedPacket>();
    private final Connection.Unsafe unsafe = new Connection.Unsafe(){

        @Override
        public void sendPacket(DefinedPacket packet) {
            UserConnection.this.ch.write(packet);
        }
    };

    public void init() {
        this.entityRewrite = EntityMap.getEntityMap(this.getPendingConnection().getVersion());
        this.displayName = this.name;
        this.tabListHandler = new ServerUnique(this);
        Collection<String> g2 = this.bungee.getConfigurationAdapter().getGroups(this.name);
        g2.addAll(this.bungee.getConfigurationAdapter().getGroups(this.getUniqueId().toString()));
        for (String s2 : g2) {
            this.addGroups(s2);
        }
        this.forgeClientHandler = new ForgeClientHandler(this);
        this.forgeClientHandler.setFmlTokenInHandshake(this.getPendingConnection().getExtraDataInHandshake().contains("\u0000FML\u0000"));
    }

    public void sendPacket(PacketWrapper packet) {
        this.ch.write(packet);
    }

    public void sendPacketQueued(DefinedPacket packet) {
        Protocol encodeProtocol = this.ch.getEncodeProtocol();
        if (!encodeProtocol.TO_CLIENT.hasPacket(packet.getClass(), this.getPendingConnection().getVersion())) {
            this.packetQueue.add(packet);
        } else {
            this.unsafe().sendPacket(packet);
        }
    }

    public void sendQueuedPackets() {
        DefinedPacket packet;
        while ((packet = this.packetQueue.poll()) != null) {
            this.unsafe().sendPacket(packet);
        }
    }

    @Deprecated
    public boolean isActive() {
        return !this.ch.isClosed();
    }

    @Override
    public void setDisplayName(String name) {
        Preconditions.checkNotNull(name, "displayName");
        this.displayName = name;
    }

    @Override
    public void connect(ServerInfo target) {
        this.connect(target, null, ServerConnectEvent.Reason.PLUGIN);
    }

    @Override
    public void connect(ServerInfo target, ServerConnectEvent.Reason reason) {
        this.connect(target, null, false, reason);
    }

    @Override
    public void connect(ServerInfo target, Callback<Boolean> callback) {
        this.connect(target, callback, false, ServerConnectEvent.Reason.PLUGIN);
    }

    @Override
    public void connect(ServerInfo target, Callback<Boolean> callback, ServerConnectEvent.Reason reason) {
        this.connect(target, callback, false, reason);
    }

    @Deprecated
    public void connectNow(ServerInfo target) {
        this.connectNow(target, ServerConnectEvent.Reason.UNKNOWN);
    }

    public void connectNow(ServerInfo target, ServerConnectEvent.Reason reason) {
        this.dimensionChange = true;
        this.connect(target, reason);
    }

    public ServerInfo updateAndGetNextServer(ServerInfo currentTarget) {
        if (this.serverJoinQueue == null) {
            this.serverJoinQueue = new LinkedList<String>(this.getPendingConnection().getListener().getServerPriority());
        }
        ServerInfo next = null;
        while (!this.serverJoinQueue.isEmpty()) {
            ServerInfo candidate = ProxyServer.getInstance().getServerInfo(this.serverJoinQueue.remove());
            if (Objects.equals(currentTarget, candidate)) continue;
            next = candidate;
            break;
        }
        return next;
    }

    public void connect(ServerInfo info, Callback<Boolean> callback, boolean retry) {
        this.connect(info, callback, retry, ServerConnectEvent.Reason.PLUGIN);
    }

    public void connect(ServerInfo info, final Callback<Boolean> callback, boolean retry, ServerConnectEvent.Reason reason) {
        Preconditions.checkNotNull(info, "info");
        ServerConnectRequest.Builder builder = ServerConnectRequest.builder().retry(retry).reason(reason).target(info);
        if (callback != null) {
            builder.callback(new Callback<ServerConnectRequest.Result>(){

                @Override
                public void done(ServerConnectRequest.Result result, Throwable error) {
                    callback.done(result == ServerConnectRequest.Result.SUCCESS ? Boolean.TRUE : Boolean.FALSE, error);
                }
            });
        }
        this.connect(builder.build());
    }

    @Override
    public void connect(final ServerConnectRequest request) {
        Preconditions.checkNotNull(request, "request");
        final Callback<ServerConnectRequest.Result> callback = request.getCallback();
        ServerConnectEvent event = new ServerConnectEvent(this, request.getTarget(), request.getReason(), request);
        if (this.bungee.getPluginManager().callEvent(event).isCancelled()) {
            if (callback != null) {
                callback.done(ServerConnectRequest.Result.EVENT_CANCEL, null);
            }
            if (this.getServer() == null && !this.ch.isClosing()) {
                throw new IllegalStateException("Cancelled ServerConnectEvent with no server or disconnect.");
            }
            return;
        }
        final BungeeServerInfo target = (BungeeServerInfo)event.getTarget();
        if (this.getServer() != null && Objects.equals(this.getServer().getInfo(), target)) {
            if (callback != null) {
                callback.done(ServerConnectRequest.Result.ALREADY_CONNECTED, null);
            }
            this.sendMessage(this.bungee.getTranslation("already_connected", new Object[0]));
            return;
        }
        if (this.pendingConnects.contains(target)) {
            if (callback != null) {
                callback.done(ServerConnectRequest.Result.ALREADY_CONNECTING, null);
            }
            this.sendMessage(this.bungee.getTranslation("already_connecting", new Object[0]));
            return;
        }
        this.pendingConnects.add(target);
        ChannelInitializer initializer = new ChannelInitializer(){

            protected void initChannel(Channel ch) throws Exception {
                PipelineUtils.BASE_SERVERSIDE.initChannel(ch);
                ch.pipeline().addAfter("frame-decoder", "packet-decoder", new MinecraftDecoder(Protocol.HANDSHAKE, false, UserConnection.this.getPendingConnection().getVersion()));
                ch.pipeline().addAfter("frame-prepender", "packet-encoder", new MinecraftEncoder(Protocol.HANDSHAKE, false, UserConnection.this.getPendingConnection().getVersion()));
                ch.pipeline().get(HandlerBoss.class).setHandler(new ServerConnector(UserConnection.this.bungee, UserConnection.this, target));
            }
        };
        ChannelFutureListener listener = new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (callback != null) {
                    callback.done(future.isSuccess() ? ServerConnectRequest.Result.SUCCESS : ServerConnectRequest.Result.FAIL, future.cause());
                }
                if (!future.isSuccess()) {
                    future.channel().close();
                    UserConnection.this.pendingConnects.remove(target);
                    ServerInfo def = UserConnection.this.updateAndGetNextServer(target);
                    if (request.isRetry() && def != null && (UserConnection.this.getServer() == null || def != UserConnection.this.getServer().getInfo())) {
                        UserConnection.this.sendMessage(UserConnection.this.bungee.getTranslation("fallback_lobby", new Object[0]));
                        UserConnection.this.connect(def, null, true, ServerConnectEvent.Reason.LOBBY_FALLBACK);
                    } else if (UserConnection.this.dimensionChange) {
                        UserConnection.this.disconnect(UserConnection.this.bungee.getTranslation("fallback_kick", UserConnection.this.connectionFailMessage(future.cause())));
                    } else {
                        UserConnection.this.sendMessage(UserConnection.this.bungee.getTranslation("fallback_kick", UserConnection.this.connectionFailMessage(future.cause())));
                    }
                }
            }
        };
        Bootstrap b = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(PipelineUtils.getChannel(target.getAddress()))).group(this.ch.getHandle().eventLoop())).handler(initializer)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, request.getConnectTimeout())).remoteAddress(target.getAddress());
        if (this.getPendingConnection().getListener().isSetLocalAddress() && !PlatformDependent.isWindows() && this.getPendingConnection().getListener().getSocketAddress() instanceof InetSocketAddress) {
            b.localAddress(this.getPendingConnection().getListener().getHost().getHostString(), 0);
        }
        b.connect().addListener(listener);
    }

    private String connectionFailMessage(Throwable cause) {
        return this.groups.contains("admin") ? Util.exception(cause, false) : cause.getClass().getName();
    }

    @Override
    public void disconnect(String reason) {
        this.disconnect(TextComponent.fromLegacy(reason));
    }

    @Override
    public void disconnect(BaseComponent ... reason) {
        this.disconnect(TextComponent.fromArray(reason));
    }

    @Override
    public void disconnect(BaseComponent reason) {
        this.disconnect0(reason);
    }

    public void disconnect0(BaseComponent reason) {
        if (!this.ch.isClosing()) {
            this.bungee.getLogger().log(Level.INFO, "[{0}] disconnected with: {1}", new Object[]{this.getName(), BaseComponent.toLegacyText(reason)});
            this.ch.close(new Kick(reason));
            if (this.server != null) {
                this.server.setObsolete(true);
                this.server.disconnect("Quitting");
            }
        }
    }

    @Override
    public void chat(String message) {
        Preconditions.checkState(this.server != null, "Not connected to server");
        if (this.getPendingConnection().getVersion() >= 759) {
            throw new UnsupportedOperationException("Cannot spoof chat on this client version!");
        }
        this.server.getCh().write(new Chat(message));
    }

    @Override
    public void sendMessage(String message) {
        this.sendMessage(TextComponent.fromLegacy(message));
    }

    @Override
    public void sendMessages(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public void sendMessage(BaseComponent ... message) {
        this.sendMessage(ChatMessageType.SYSTEM, message);
    }

    @Override
    public void sendMessage(BaseComponent message) {
        this.sendMessage(ChatMessageType.SYSTEM, message);
    }

    @Override
    public void sendMessage(ChatMessageType position, BaseComponent ... message) {
        this.sendMessage(position, (UUID)null, TextComponent.fromArray(message));
    }

    @Override
    public void sendMessage(ChatMessageType position, BaseComponent message) {
        this.sendMessage(position, (UUID)null, message);
    }

    @Override
    public void sendMessage(UUID sender, BaseComponent ... message) {
        this.sendMessage(ChatMessageType.CHAT, sender, TextComponent.fromArray(message));
    }

    @Override
    public void sendMessage(UUID sender, BaseComponent message) {
        this.sendMessage(ChatMessageType.CHAT, sender, message);
    }

    private void sendMessage(ChatMessageType position, UUID sender, BaseComponent message) {
        message = ChatComponentTransformer.getInstance().transform(this, true, message);
        if (position == ChatMessageType.ACTION_BAR && this.getPendingConnection().getVersion() < 755) {
            if (this.getPendingConnection().getVersion() <= 210) {
                message = new TextComponent(BaseComponent.toLegacyText(message));
            } else {
                net.md_5.bungee.protocol.packet.Title title = new net.md_5.bungee.protocol.packet.Title();
                title.setAction(Title.Action.ACTIONBAR);
                title.setText(message);
                this.sendPacketQueued(title);
                return;
            }
        }
        if (this.getPendingConnection().getVersion() >= 759) {
            if (position == ChatMessageType.CHAT) {
                position = ChatMessageType.SYSTEM;
            }
            this.sendPacketQueued(new SystemChat(message, position.ordinal()));
        } else {
            this.sendPacketQueued(new Chat(ComponentSerializer.toString(message), (byte)position.ordinal(), sender));
        }
    }

    @Override
    public void sendData(String channel, byte[] data) {
        this.sendPacketQueued(new PluginMessage(channel, data, this.forgeClientHandler.isForgeUser()));
    }

    @Override
    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.getSocketAddress();
    }

    @Override
    public SocketAddress getSocketAddress() {
        return this.ch.getRemoteAddress();
    }

    @Override
    public Collection<String> getGroups() {
        return Collections.unmodifiableCollection(this.groups);
    }

    @Override
    public void addGroups(String ... groups) {
        for (String group : groups) {
            this.groups.add(group);
            for (String permission : this.bungee.getConfigurationAdapter().getPermissions(group)) {
                this.setPermission(permission, true);
            }
        }
    }

    @Override
    public void removeGroups(String ... groups) {
        for (String group : groups) {
            this.groups.remove(group);
            for (String permission : this.bungee.getConfigurationAdapter().getPermissions(group)) {
                this.setPermission(permission, false);
            }
        }
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.bungee.getPluginManager().callEvent(new PermissionCheckEvent(this, permission, this.permissions.contains(permission))).hasPermission();
    }

    @Override
    public void setPermission(String permission, boolean value) {
        if (value) {
            this.permissions.add(permission);
        } else {
            this.permissions.remove(permission);
        }
    }

    @Override
    public Collection<String> getPermissions() {
        return Collections.unmodifiableCollection(this.permissions);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Connection.Unsafe unsafe() {
        return this.unsafe;
    }

    @Override
    public String getUUID() {
        return this.getPendingConnection().getUUID();
    }

    @Override
    public UUID getUniqueId() {
        return this.getPendingConnection().getUniqueId();
    }

    public void setSettings(ClientSettings settings) {
        this.settings = settings;
        this.locale = null;
    }

    @Override
    public Locale getLocale() {
        return this.locale == null && this.settings != null ? (this.locale = Locale.forLanguageTag(this.settings.getLocale().replace('_', '-'))) : this.locale;
    }

    @Override
    public byte getViewDistance() {
        return this.settings != null ? this.settings.getViewDistance() : (byte)10;
    }

    @Override
    public ProxiedPlayer.ChatMode getChatMode() {
        if (this.settings == null) {
            return ProxiedPlayer.ChatMode.SHOWN;
        }
        switch (this.settings.getChatFlags()) {
            default: {
                return ProxiedPlayer.ChatMode.SHOWN;
            }
            case 1: {
                return ProxiedPlayer.ChatMode.COMMANDS_ONLY;
            }
            case 2: 
        }
        return ProxiedPlayer.ChatMode.HIDDEN;
    }

    @Override
    public boolean hasChatColors() {
        return this.settings == null || this.settings.isChatColours();
    }

    @Override
    public SkinConfiguration getSkinParts() {
        return this.settings != null ? new PlayerSkinConfiguration(this.settings.getSkinParts()) : PlayerSkinConfiguration.SKIN_SHOW_ALL;
    }

    @Override
    public ProxiedPlayer.MainHand getMainHand() {
        return this.settings == null || this.settings.getMainHand() == 1 ? ProxiedPlayer.MainHand.RIGHT : ProxiedPlayer.MainHand.LEFT;
    }

    @Override
    public boolean isForgeUser() {
        return this.forgeClientHandler.isForgeUser();
    }

    @Override
    public Map<String, String> getModList() {
        if (this.forgeClientHandler.getClientModList() == null) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf(this.forgeClientHandler.getClientModList());
    }

    @Override
    public void setTabHeader(BaseComponent header, BaseComponent footer) {
        header = ChatComponentTransformer.getInstance().transform(this, true, header);
        footer = ChatComponentTransformer.getInstance().transform(this, true, footer);
        this.sendPacketQueued(new PlayerListHeaderFooter(header, footer));
    }

    @Override
    public void setTabHeader(BaseComponent[] header, BaseComponent[] footer) {
        this.setTabHeader(TextComponent.fromArray(header), TextComponent.fromArray(footer));
    }

    @Override
    public void resetTabHeader() {
        this.setTabHeader((BaseComponent)null, null);
    }

    @Override
    public void sendTitle(Title title) {
        title.send(this);
    }

    public String getExtraDataInHandshake() {
        return this.getPendingConnection().getExtraDataInHandshake();
    }

    public void setCompressionThreshold(int compressionThreshold) {
        if (!this.ch.isClosing() && this.compressionThreshold == -1 && compressionThreshold >= 0) {
            this.compressionThreshold = compressionThreshold;
            this.unsafe.sendPacket(new SetCompression(compressionThreshold));
            this.ch.setCompressionThreshold(compressionThreshold);
        }
    }

    @Override
    public boolean isConnected() {
        return !this.ch.isClosed();
    }

    @Override
    public Scoreboard getScoreboard() {
        return this.serverSentScoreboard;
    }

    public UserConnection(@NonNull ProxyServer bungee, @NonNull ChannelWrapper ch, @NonNull String name, InitialHandler pendingConnection) {
        if (bungee == null) {
            throw new NullPointerException("bungee is marked non-null but is null");
        }
        if (ch == null) {
            throw new NullPointerException("ch is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.bungee = bungee;
        this.ch = ch;
        this.name = name;
        this.pendingConnection = pendingConnection;
    }

    @NonNull
    public ChannelWrapper getCh() {
        return this.ch;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    public InitialHandler getPendingConnection() {
        return this.pendingConnection;
    }

    @Override
    public ServerConnection getServer() {
        return this.server;
    }

    public void setServer(ServerConnection server) {
        this.server = server;
    }

    public Object getDimension() {
        return this.dimension;
    }

    public void setDimension(Object dimension) {
        this.dimension = dimension;
    }

    public boolean isDimensionChange() {
        return this.dimensionChange;
    }

    public void setDimensionChange(boolean dimensionChange) {
        this.dimensionChange = dimensionChange;
    }

    public Collection<ServerInfo> getPendingConnects() {
        return this.pendingConnects;
    }

    @Override
    public int getPing() {
        return this.ping;
    }

    public void setPing(int ping) {
        this.ping = ping;
    }

    @Override
    public ServerInfo getReconnectServer() {
        return this.reconnectServer;
    }

    @Override
    public void setReconnectServer(ServerInfo reconnectServer) {
        this.reconnectServer = reconnectServer;
    }

    public TabList getTabListHandler() {
        return this.tabListHandler;
    }

    public int getGamemode() {
        return this.gamemode;
    }

    public void setGamemode(int gamemode) {
        this.gamemode = gamemode;
    }

    public int getCompressionThreshold() {
        return this.compressionThreshold;
    }

    public void setServerJoinQueue(Queue<String> serverJoinQueue) {
        this.serverJoinQueue = serverJoinQueue;
    }

    public int getClientEntityId() {
        return this.clientEntityId;
    }

    public void setClientEntityId(int clientEntityId) {
        this.clientEntityId = clientEntityId;
    }

    public int getServerEntityId() {
        return this.serverEntityId;
    }

    public void setServerEntityId(int serverEntityId) {
        this.serverEntityId = serverEntityId;
    }

    public ClientSettings getSettings() {
        return this.settings;
    }

    public Scoreboard getServerSentScoreboard() {
        return this.serverSentScoreboard;
    }

    public Collection<UUID> getSentBossBars() {
        return this.sentBossBars;
    }

    public String getLastCommandTabbed() {
        return this.lastCommandTabbed;
    }

    public void setLastCommandTabbed(String lastCommandTabbed) {
        this.lastCommandTabbed = lastCommandTabbed;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public EntityMap getEntityRewrite() {
        return this.entityRewrite;
    }

    public ForgeClientHandler getForgeClientHandler() {
        return this.forgeClientHandler;
    }

    public void setForgeClientHandler(ForgeClientHandler forgeClientHandler) {
        this.forgeClientHandler = forgeClientHandler;
    }

    public ForgeServerHandler getForgeServerHandler() {
        return this.forgeServerHandler;
    }

    public void setForgeServerHandler(ForgeServerHandler forgeServerHandler) {
        this.forgeServerHandler = forgeServerHandler;
    }
}

