/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.nbt;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import se.llbit.nbt.ErrorTag;
import se.llbit.nbt.SpecificTag;

public class FloatTag
extends SpecificTag {
    public final float value;

    public static SpecificTag read(DataInputStream in) {
        try {
            return new FloatTag(in.readFloat());
        }
        catch (IOException e) {
            return new ErrorTag("IOException while reading TAG_Float:\n" + e.getMessage());
        }
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeFloat(this.getData());
    }

    public FloatTag(float value) {
        this.value = value;
    }

    public float getData() {
        return this.value;
    }

    @Override
    public String extraInfo() {
        return ": " + this.getData();
    }

    public String type() {
        return "TAG_Float";
    }

    @Override
    public String tagName() {
        return "TAG_Float";
    }

    @Override
    public int tagType() {
        return 5;
    }

    @Override
    public float floatValue() {
        return this.getData();
    }

    @Override
    public float floatValue(float defaultValue) {
        return this.getData();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof FloatTag && ((FloatTag)obj).value == this.value;
    }

    public int hashCode() {
        return Float.floatToRawIntBits(this.value);
    }
}

