/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.UUID;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class PlayerListItemRemove
extends DefinedPacket {
    private UUID[] uuids;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.uuids = new UUID[DefinedPacket.readVarInt(buf)];
        for (int i = 0; i < this.uuids.length; ++i) {
            this.uuids[i] = DefinedPacket.readUUID(buf);
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        DefinedPacket.writeVarInt(this.uuids.length, buf);
        for (UUID uuid : this.uuids) {
            DefinedPacket.writeUUID(uuid, buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public UUID[] getUuids() {
        return this.uuids;
    }

    public void setUuids(UUID[] uuids) {
        this.uuids = uuids;
    }

    @Override
    public String toString() {
        return "PlayerListItemRemove(uuids=" + Arrays.deepToString(this.getUuids()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerListItemRemove)) {
            return false;
        }
        PlayerListItemRemove other = (PlayerListItemRemove)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getUuids(), other.getUuids());
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerListItemRemove;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getUuids());
        return result;
    }
}

