/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.UUID;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Property;
import net.md_5.bungee.protocol.ProtocolConstants;

public class LoginSuccess
extends DefinedPacket {
    private UUID uuid;
    private String username;
    private Property[] properties;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.uuid = protocolVersion >= 735 ? LoginSuccess.readUUID(buf) : UUID.fromString(LoginSuccess.readString(buf));
        this.username = LoginSuccess.readString(buf);
        if (protocolVersion >= 759) {
            this.properties = LoginSuccess.readProperties(buf);
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 735) {
            LoginSuccess.writeUUID(this.uuid, buf);
        } else {
            LoginSuccess.writeString(this.uuid.toString(), buf);
        }
        LoginSuccess.writeString(this.username, buf);
        if (protocolVersion >= 759) {
            LoginSuccess.writeProperties(this.properties, buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getUsername() {
        return this.username;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setProperties(Property[] properties) {
        this.properties = properties;
    }

    @Override
    public String toString() {
        return "LoginSuccess(uuid=" + this.getUuid() + ", username=" + this.getUsername() + ", properties=" + Arrays.deepToString(this.getProperties()) + ")";
    }

    public LoginSuccess() {
    }

    public LoginSuccess(UUID uuid, String username, Property[] properties) {
        this.uuid = uuid;
        this.username = username;
        this.properties = properties;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginSuccess)) {
            return false;
        }
        LoginSuccess other = (LoginSuccess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        return Arrays.deepEquals(this.getProperties(), other.getProperties());
    }

    protected boolean canEqual(Object other) {
        return other instanceof LoginSuccess;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getProperties());
        return result;
    }
}

