/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.nbt;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import se.llbit.nbt.ErrorTag;
import se.llbit.nbt.SpecificTag;

public class StringTag
extends SpecificTag {
    public final String value;

    public static SpecificTag read(DataInputStream in) {
        try {
            return new StringTag(in.readUTF());
        }
        catch (IOException e) {
            return new ErrorTag("IOException while reading TAG_String:\n" + e.getMessage());
        }
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        StringTag.write(out, this.value);
    }

    static void write(DataOutputStream out, String data) throws IOException {
        out.writeUTF(data);
    }

    static void skip(DataInputStream in) {
        try {
            short length = in.readShort();
            in.skipBytes(length);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public StringTag(String value) {
        this.value = value;
    }

    public String getData() {
        return this.value != null ? this.value : "";
    }

    @Override
    public String extraInfo() {
        return ": \"" + this.getData() + '\"';
    }

    public String type() {
        return "TAG_String";
    }

    @Override
    public String tagName() {
        return "TAG_String";
    }

    @Override
    public int tagType() {
        return 8;
    }

    @Override
    public String stringValue() {
        return this.getData();
    }

    @Override
    public String stringValue(String defaultValue) {
        return this.getData();
    }

    @Override
    public boolean same(String name) {
        return this.getData().equals(name);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof StringTag && ((StringTag)obj).value.equals(this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

