/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.ListenThread;
import net.md_5.bungee.Logger;
import net.md_5.bungee.Metrics;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.YamlReconnectHandler;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ReconnectHandler;
import net.md_5.bungee.api.TabListHandler;
import net.md_5.bungee.api.config.ConfigurationAdapter;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginManager;
import net.md_5.bungee.command.CommandAlert;
import net.md_5.bungee.command.CommandBungee;
import net.md_5.bungee.command.CommandEnd;
import net.md_5.bungee.command.CommandIP;
import net.md_5.bungee.command.CommandList;
import net.md_5.bungee.command.CommandReload;
import net.md_5.bungee.command.CommandServer;
import net.md_5.bungee.command.ConsoleCommandSender;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.YamlConfig;
import net.md_5.bungee.packet.DefinedPacket;
import net.md_5.bungee.packet.PacketFAPluginMessage;

public class BungeeCord
extends ProxyServer {
    public static final byte PROTOCOL_VERSION = 51;
    public static final String GAME_VERSION = "1.4.6";
    public volatile boolean isRunning;
    public final Configuration config = new Configuration();
    public final ExecutorService threadPool = Executors.newCachedThreadPool();
    private final Timer saveThread = new Timer("Reconnect Saver");
    private Collection<ListenThread> listeners = new HashSet<ListenThread>();
    public Map<String, UserConnection> connections = new ConcurrentHashMap<String, UserConnection>();
    public TabListHandler tabListHandler;
    public final PluginManager pluginManager = new PluginManager();
    private ReconnectHandler reconnectHandler;
    private ConfigurationAdapter configurationAdapter = new YamlConfig();
    private final Collection<String> pluginChannels = new HashSet<String>();

    public BungeeCord() {
        this.getPluginManager().registerCommand((Command)new CommandReload());
        this.getPluginManager().registerCommand((Command)new CommandEnd());
        this.getPluginManager().registerCommand((Command)new CommandList());
        this.getPluginManager().registerCommand((Command)new CommandServer());
        this.getPluginManager().registerCommand((Command)new CommandIP());
        this.getPluginManager().registerCommand((Command)new CommandAlert());
        this.getPluginManager().registerCommand((Command)new CommandBungee());
        this.registerChannel("BungeeCord");
    }

    public static BungeeCord getInstance() {
        return (BungeeCord)ProxyServer.getInstance();
    }

    public static void main(String[] args) throws IOException {
        BungeeCord bungee = new BungeeCord();
        ProxyServer.setInstance((ProxyServer)bungee);
        Logger.$().info("Enabled BungeeCord version " + bungee.getVersion());
        bungee.start();
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (bungee.isRunning) {
            boolean handled;
            String line = br.readLine();
            if (line == null || (handled = BungeeCord.getInstance().getPluginManager().dispatchCommand((CommandSender)ConsoleCommandSender.getInstance(), line))) continue;
            System.err.println("Command not found");
        }
    }

    public void start() throws IOException {
        File plugins = new File("plugins");
        plugins.mkdir();
        this.pluginManager.loadPlugins(plugins);
        this.config.load();
        this.reconnectHandler = new YamlReconnectHandler();
        this.isRunning = true;
        this.pluginManager.enablePlugins();
        for (ListenerInfo info : this.config.getListeners()) {
            Logger.$().info("Listening on " + info.getHost());
            ListenThread listener = new ListenThread(info);
            listener.start();
            this.listeners.add(listener);
        }
        this.saveThread.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                BungeeCord.this.getReconnectHandler().save();
            }
        }, 0L, TimeUnit.MINUTES.toMillis(5L));
        new Metrics().start();
    }

    public void stop() {
        this.isRunning = false;
        Logger.$().info("Disabling plugins");
        for (Plugin plugin : this.pluginManager.getPlugins()) {
            plugin.onDisable();
        }
        for (ListenThread listener : this.listeners) {
            Logger.$().log(Level.INFO, "Closing listen thread {0}", listener.socket);
            try {
                listener.socket.close();
                listener.join();
            }
            catch (IOException | InterruptedException ex) {
                Logger.$().severe("Could not close listen thread");
            }
        }
        Logger.$().info("Closing pending connections");
        this.threadPool.shutdown();
        Logger.$().info("Disconnecting " + this.connections.size() + " connections");
        for (UserConnection user : this.connections.values()) {
            user.disconnect("Proxy restarting, brb.");
        }
        Logger.$().info("Saving reconnect locations");
        this.reconnectHandler.save();
        this.saveThread.cancel();
        Logger.$().info("Thank you and goodbye");
        System.exit(0);
    }

    public void setSocketOptions(Socket socket) throws IOException {
        socket.setSoTimeout(this.config.getTimeout());
        socket.setTrafficClass(24);
        socket.setTcpNoDelay(true);
    }

    public void broadcast(DefinedPacket packet) {
        for (UserConnection con : this.connections.values()) {
            con.packetQueue.add(packet);
        }
    }

    public String getName() {
        return "BungeeCord";
    }

    public String getVersion() {
        return BungeeCord.class.getPackage().getImplementationVersion() == null ? "unknown" : BungeeCord.class.getPackage().getImplementationVersion();
    }

    public java.util.logging.Logger getLogger() {
        return Logger.$();
    }

    public Collection<ProxiedPlayer> getPlayers() {
        return this.connections.values();
    }

    public ProxiedPlayer getPlayer(String name) {
        return this.connections.get(name);
    }

    public Server getServer(String name) {
        Collection users = this.getServers().get(name).getPlayers();
        return users != null && !users.isEmpty() ? ((ProxiedPlayer)users.iterator().next()).getServer() : null;
    }

    public Map<String, ServerInfo> getServers() {
        return this.config.getServers();
    }

    public ServerInfo getServerInfo(String name) {
        return this.getServers().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChannel(String channel) {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            this.pluginChannels.add(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterChannel(String channel) {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            this.pluginChannels.remove(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getChannels() {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            return Collections.unmodifiableCollection(this.pluginChannels);
        }
    }

    public PacketFAPluginMessage registerChannels() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.getChannels()) {
            sb.append(s);
            sb.append('\u0000');
        }
        byte[] payload = sb.substring(0, sb.length() - 1).getBytes();
        return new PacketFAPluginMessage("REGISTER", payload);
    }

    public byte getProtocolVersion() {
        return 51;
    }

    public String getGameVersion() {
        return GAME_VERSION;
    }

    public ServerInfo constructServerInfo(String name, InetSocketAddress address) {
        return new BungeeServerInfo(name, address);
    }

    public TabListHandler getTabListHandler() {
        return this.tabListHandler;
    }

    public void setTabListHandler(TabListHandler tabListHandler) {
        this.tabListHandler = tabListHandler;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public ReconnectHandler getReconnectHandler() {
        return this.reconnectHandler;
    }

    public void setReconnectHandler(ReconnectHandler reconnectHandler) {
        this.reconnectHandler = reconnectHandler;
    }

    public ConfigurationAdapter getConfigurationAdapter() {
        return this.configurationAdapter;
    }

    public void setConfigurationAdapter(ConfigurationAdapter configurationAdapter) {
        this.configurationAdapter = configurationAdapter;
    }
}

