/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.packet;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.md_5.bungee.packet.DefinedPacket;
import net.md_5.mendax.datainput.DataInputPacketReader;

public class PacketStream
implements AutoCloseable {
    private final DataInputStream dataInput;
    private OutputStream out;
    private final TrackingInputStream tracker;
    private final byte[] buffer = new byte[262144];

    public PacketStream(InputStream in) {
        this(in, null);
    }

    public PacketStream(InputStream in, OutputStream out) {
        this.tracker = new TrackingInputStream(in);
        this.dataInput = new DataInputStream(this.tracker);
        this.out = out;
    }

    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    public void write(DefinedPacket packet) throws IOException {
        this.out.write(packet.getPacket());
    }

    public byte[] readPacket() throws IOException {
        this.tracker.out.reset();
        DataInputPacketReader.readPacket((DataInput)this.dataInput, (byte[])this.buffer);
        return this.tracker.out.toByteArray();
    }

    @Override
    public void close() throws Exception {
        this.dataInput.close();
    }

    public OutputStream getOut() {
        return this.out;
    }

    private class TrackingInputStream
    extends FilterInputStream {
        private final ByteArrayOutputStream out;

        public TrackingInputStream(InputStream in) {
            super(in);
            this.out = new ByteArrayOutputStream();
        }

        @Override
        public int read() throws IOException {
            int ret = this.in.read();
            this.out.write(ret);
            return ret;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int ret = this.in.read(b, off, len);
            this.out.write(b, off, ret);
            return ret;
        }
    }
}

