/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.OverflowPacketException;
import net.md_5.bungee.protocol.PlayerPublicKey;
import net.md_5.bungee.protocol.Property;
import net.md_5.bungee.protocol.ProtocolConstants;
import se.llbit.nbt.NamedTag;
import se.llbit.nbt.Tag;

public abstract class DefinedPacket {
    public static void writeString(String s2, ByteBuf buf) {
        DefinedPacket.writeString(s2, buf, Short.MAX_VALUE);
    }

    public static void writeString(String s2, ByteBuf buf, int maxLength) {
        if (s2.length() > maxLength) {
            throw new OverflowPacketException("Cannot send string longer than " + maxLength + " (got " + s2.length() + " characters)");
        }
        byte[] b = s2.getBytes(Charsets.UTF_8);
        if (b.length > maxLength * 3) {
            throw new OverflowPacketException("Cannot send string longer than " + maxLength * 3 + " (got " + b.length + " bytes)");
        }
        DefinedPacket.writeVarInt(b.length, buf);
        buf.writeBytes(b);
    }

    public static String readString(ByteBuf buf) {
        return DefinedPacket.readString(buf, Short.MAX_VALUE);
    }

    public static String readString(ByteBuf buf, int maxLen) {
        int len = DefinedPacket.readVarInt(buf);
        if (len > maxLen * 3) {
            throw new OverflowPacketException("Cannot receive string longer than " + maxLen * 3 + " (got " + len + " bytes)");
        }
        String s2 = buf.toString(buf.readerIndex(), len, Charsets.UTF_8);
        buf.readerIndex(buf.readerIndex() + len);
        if (s2.length() > maxLen) {
            throw new OverflowPacketException("Cannot receive string longer than " + maxLen + " (got " + s2.length() + " characters)");
        }
        return s2;
    }

    public static void writeArray(byte[] b, ByteBuf buf) {
        if (b.length > Short.MAX_VALUE) {
            throw new OverflowPacketException("Cannot send byte array longer than Short.MAX_VALUE (got " + b.length + " bytes)");
        }
        DefinedPacket.writeVarInt(b.length, buf);
        buf.writeBytes(b);
    }

    public static byte[] toArray(ByteBuf buf) {
        byte[] ret = new byte[buf.readableBytes()];
        buf.readBytes(ret);
        return ret;
    }

    public static byte[] readArray(ByteBuf buf) {
        return DefinedPacket.readArray(buf, buf.readableBytes());
    }

    public static byte[] readArray(ByteBuf buf, int limit) {
        int len = DefinedPacket.readVarInt(buf);
        if (len > limit) {
            throw new OverflowPacketException("Cannot receive byte array longer than " + limit + " (got " + len + " bytes)");
        }
        byte[] ret = new byte[len];
        buf.readBytes(ret);
        return ret;
    }

    public static int[] readVarIntArray(ByteBuf buf) {
        int len = DefinedPacket.readVarInt(buf);
        int[] ret = new int[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = DefinedPacket.readVarInt(buf);
        }
        return ret;
    }

    public static void writeStringArray(List<String> s2, ByteBuf buf) {
        DefinedPacket.writeVarInt(s2.size(), buf);
        for (String str : s2) {
            DefinedPacket.writeString(str, buf);
        }
    }

    public static List<String> readStringArray(ByteBuf buf) {
        int len = DefinedPacket.readVarInt(buf);
        ArrayList<String> ret = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            ret.add(DefinedPacket.readString(buf));
        }
        return ret;
    }

    public static int readVarInt(ByteBuf input) {
        return DefinedPacket.readVarInt(input, 5);
    }

    public static int readVarInt(ByteBuf input, int maxBytes) {
        byte in;
        int out = 0;
        int bytes = 0;
        do {
            in = input.readByte();
            out |= (in & 0x7F) << bytes++ * 7;
            if (bytes <= maxBytes) continue;
            throw new RuntimeException("VarInt too big");
        } while ((in & 0x80) == 128);
        return out;
    }

    public static void writeVarInt(int value, ByteBuf output) {
        do {
            int part = value & 0x7F;
            if ((value >>>= 7) != 0) {
                part |= 0x80;
            }
            output.writeByte(part);
        } while (value != 0);
    }

    public static int readVarShort(ByteBuf buf) {
        int low = buf.readUnsignedShort();
        int high = 0;
        if ((low & 0x8000) != 0) {
            low &= Short.MAX_VALUE;
            high = buf.readUnsignedByte();
        }
        return (high & 0xFF) << 15 | low;
    }

    public static void writeVarShort(ByteBuf buf, int toWrite) {
        int low = toWrite & Short.MAX_VALUE;
        int high = (toWrite & 0x7F8000) >> 15;
        if (high != 0) {
            low |= 0x8000;
        }
        buf.writeShort(low);
        if (high != 0) {
            buf.writeByte(high);
        }
    }

    public static void writeUUID(UUID value, ByteBuf output) {
        output.writeLong(value.getMostSignificantBits());
        output.writeLong(value.getLeastSignificantBits());
    }

    public static UUID readUUID(ByteBuf input) {
        return new UUID(input.readLong(), input.readLong());
    }

    public static void writeProperties(Property[] properties, ByteBuf buf) {
        if (properties == null) {
            DefinedPacket.writeVarInt(0, buf);
            return;
        }
        DefinedPacket.writeVarInt(properties.length, buf);
        for (Property prop : properties) {
            DefinedPacket.writeString(prop.getName(), buf);
            DefinedPacket.writeString(prop.getValue(), buf);
            if (prop.getSignature() != null) {
                buf.writeBoolean(true);
                DefinedPacket.writeString(prop.getSignature(), buf);
                continue;
            }
            buf.writeBoolean(false);
        }
    }

    public static Property[] readProperties(ByteBuf buf) {
        Property[] properties = new Property[DefinedPacket.readVarInt(buf)];
        for (int j = 0; j < properties.length; ++j) {
            String name = DefinedPacket.readString(buf);
            String value = DefinedPacket.readString(buf);
            properties[j] = buf.readBoolean() ? new Property(name, value, DefinedPacket.readString(buf)) : new Property(name, value);
        }
        return properties;
    }

    public static void writePublicKey(PlayerPublicKey publicKey, ByteBuf buf) {
        if (publicKey != null) {
            buf.writeBoolean(true);
            buf.writeLong(publicKey.getExpiry());
            DefinedPacket.writeArray(publicKey.getKey(), buf);
            DefinedPacket.writeArray(publicKey.getSignature(), buf);
        } else {
            buf.writeBoolean(false);
        }
    }

    public static PlayerPublicKey readPublicKey(ByteBuf buf) {
        if (buf.readBoolean()) {
            return new PlayerPublicKey(buf.readLong(), DefinedPacket.readArray(buf, 512), DefinedPacket.readArray(buf, 4096));
        }
        return null;
    }

    public static Tag readTag(ByteBuf input) {
        Tag tag = NamedTag.read(new DataInputStream(new ByteBufInputStream(input)));
        Preconditions.checkArgument(!tag.isError(), "Error reading tag: %s", (Object)tag.error());
        return tag;
    }

    public static void writeTag(Tag tag, ByteBuf output) {
        try {
            tag.write(new DataOutputStream(new ByteBufOutputStream(output)));
        }
        catch (IOException ex) {
            throw new RuntimeException("Exception writing tag", ex);
        }
    }

    public void read(ByteBuf buf) {
        throw new UnsupportedOperationException("Packet must implement read method");
    }

    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.read(buf);
    }

    public void write(ByteBuf buf) {
        throw new UnsupportedOperationException("Packet must implement write method");
    }

    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.write(buf);
    }

    public abstract void handle(AbstractPacketHandler var1) throws Exception;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();
}

