/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.UUID;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PlayerPublicKey;
import net.md_5.bungee.protocol.Property;
import net.md_5.bungee.protocol.ProtocolConstants;

public class PlayerListItem
extends DefinedPacket {
    private Action action;
    private Item[] items;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.action = Action.values()[DefinedPacket.readVarInt(buf)];
        this.items = new Item[DefinedPacket.readVarInt(buf)];
        block6: for (int i = 0; i < this.items.length; ++i) {
            Item item = this.items[i] = new Item();
            item.setUuid(DefinedPacket.readUUID(buf));
            switch (this.action) {
                case ADD_PLAYER: {
                    item.username = DefinedPacket.readString(buf);
                    Item.access$102(item, DefinedPacket.readProperties(buf));
                    item.gamemode = DefinedPacket.readVarInt(buf);
                    item.ping = DefinedPacket.readVarInt(buf);
                    if (buf.readBoolean()) {
                        item.displayName = DefinedPacket.readString(buf);
                    }
                    if (protocolVersion < 759) continue block6;
                    item.publicKey = PlayerListItem.readPublicKey(buf);
                    continue block6;
                }
                case UPDATE_GAMEMODE: {
                    item.gamemode = DefinedPacket.readVarInt(buf);
                    continue block6;
                }
                case UPDATE_LATENCY: {
                    item.ping = DefinedPacket.readVarInt(buf);
                    continue block6;
                }
                case UPDATE_DISPLAY_NAME: {
                    if (!buf.readBoolean()) continue block6;
                    item.displayName = DefinedPacket.readString(buf);
                }
            }
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        DefinedPacket.writeVarInt(this.action.ordinal(), buf);
        DefinedPacket.writeVarInt(this.items.length, buf);
        block6: for (Item item : this.items) {
            DefinedPacket.writeUUID(item.uuid, buf);
            switch (this.action) {
                case ADD_PLAYER: {
                    DefinedPacket.writeString(item.username, buf);
                    DefinedPacket.writeProperties(item.properties, buf);
                    DefinedPacket.writeVarInt(item.gamemode, buf);
                    DefinedPacket.writeVarInt(item.ping, buf);
                    buf.writeBoolean(item.displayName != null);
                    if (item.displayName != null) {
                        DefinedPacket.writeString(item.displayName, buf);
                    }
                    if (protocolVersion < 759) continue block6;
                    PlayerListItem.writePublicKey(item.publicKey, buf);
                    continue block6;
                }
                case UPDATE_GAMEMODE: {
                    DefinedPacket.writeVarInt(item.gamemode, buf);
                    continue block6;
                }
                case UPDATE_LATENCY: {
                    DefinedPacket.writeVarInt(item.ping, buf);
                    continue block6;
                }
                case UPDATE_DISPLAY_NAME: {
                    buf.writeBoolean(item.displayName != null);
                    if (item.displayName == null) continue block6;
                    DefinedPacket.writeString(item.displayName, buf);
                }
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public Action getAction() {
        return this.action;
    }

    public Item[] getItems() {
        return this.items;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setItems(Item[] items) {
        this.items = items;
    }

    @Override
    public String toString() {
        return "PlayerListItem(action=" + (Object)((Object)this.getAction()) + ", items=" + Arrays.deepToString(this.getItems()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerListItem)) {
            return false;
        }
        PlayerListItem other = (PlayerListItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        return Arrays.deepEquals(this.getItems(), other.getItems());
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerListItem;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getItems());
        return result;
    }

    public static class Item {
        private UUID uuid;
        private String username;
        private Property[] properties;
        private PlayerPublicKey publicKey;
        private int gamemode;
        private int ping;
        private String displayName;

        public UUID getUuid() {
            return this.uuid;
        }

        public String getUsername() {
            return this.username;
        }

        public Property[] getProperties() {
            return this.properties;
        }

        public PlayerPublicKey getPublicKey() {
            return this.publicKey;
        }

        public int getGamemode() {
            return this.gamemode;
        }

        public int getPing() {
            return this.ping;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setUuid(UUID uuid) {
            this.uuid = uuid;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setProperties(Property[] properties) {
            this.properties = properties;
        }

        public void setPublicKey(PlayerPublicKey publicKey) {
            this.publicKey = publicKey;
        }

        public void setGamemode(int gamemode) {
            this.gamemode = gamemode;
        }

        public void setPing(int ping) {
            this.ping = ping;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item other = (Item)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getGamemode() != other.getGamemode()) {
                return false;
            }
            if (this.getPing() != other.getPing()) {
                return false;
            }
            UUID this$uuid = this.getUuid();
            UUID other$uuid = other.getUuid();
            if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
                return false;
            }
            String this$username = this.getUsername();
            String other$username = other.getUsername();
            if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getProperties(), other.getProperties())) {
                return false;
            }
            PlayerPublicKey this$publicKey = this.getPublicKey();
            PlayerPublicKey other$publicKey = other.getPublicKey();
            if (this$publicKey == null ? other$publicKey != null : !((Object)this$publicKey).equals(other$publicKey)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Item;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getGamemode();
            result = result * 59 + this.getPing();
            UUID $uuid = this.getUuid();
            result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
            String $username = this.getUsername();
            result = result * 59 + ($username == null ? 43 : $username.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getProperties());
            PlayerPublicKey $publicKey = this.getPublicKey();
            result = result * 59 + ($publicKey == null ? 43 : ((Object)$publicKey).hashCode());
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            return result;
        }

        public String toString() {
            return "PlayerListItem.Item(uuid=" + this.getUuid() + ", username=" + this.getUsername() + ", properties=" + Arrays.deepToString(this.getProperties()) + ", publicKey=" + this.getPublicKey() + ", gamemode=" + this.getGamemode() + ", ping=" + this.getPing() + ", displayName=" + this.getDisplayName() + ")";
        }

        static /* synthetic */ Property[] access$102(Item x0, Property[] x1) {
            x0.properties = x1;
            return x1;
        }
    }

    public static enum Action {
        ADD_PLAYER,
        UPDATE_GAMEMODE,
        UPDATE_LATENCY,
        UPDATE_DISPLAY_NAME,
        REMOVE_PLAYER;

    }
}

