/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.tablist;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.packet.PacketC9PlayerListItem;
import net.md_5.bungee.tablist.GlobalTabList;

public class GlobalPingTabList
extends GlobalTabList {
    private static final int PING_THRESHOLD = 20;
    private final Map<ProxiedPlayer, Integer> lastPings = new ConcurrentHashMap<ProxiedPlayer, Integer>();

    @Override
    public void onDisconnect(ProxiedPlayer player) {
        this.lastPings.remove(player);
        super.onDisconnect(player);
    }

    @Override
    public void onPingChange(ProxiedPlayer player, int ping) {
        Integer lastPing = this.lastPings.get(player);
        if (lastPing == null || ping - 20 > lastPing && ping + 20 < lastPing) {
            BungeeCord.getInstance().broadcast(new PacketC9PlayerListItem(player.getDisplayName(), true, ping));
            this.lastPings.put(player, ping);
        }
    }
}

