/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.UUID;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class PlayerChat
extends DefinedPacket {
    private static final UUID EMPTY_UUID = new UUID(0L, 0L);
    private String signedContent;
    private String unsignedContent;
    private UUID sender;
    private int typeId;
    private String displayName;
    private String teamName;
    private long timestamp;
    private long salt;
    private byte[] signature;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.signedContent = PlayerChat.readString(buf, 262144);
        if (buf.readBoolean()) {
            this.unsignedContent = PlayerChat.readString(buf, 262144);
        }
        this.typeId = PlayerChat.readVarInt(buf);
        this.sender = PlayerChat.readUUID(buf);
        this.displayName = PlayerChat.readString(buf, 262144);
        if (buf.readBoolean()) {
            this.teamName = PlayerChat.readString(buf, 262144);
        }
        this.timestamp = buf.readLong();
        this.salt = buf.readLong();
        this.signature = PlayerChat.readArray(buf);
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        PlayerChat.writeString(this.signedContent, buf);
        if (this.unsignedContent != null) {
            buf.writeBoolean(true);
            PlayerChat.writeString(this.unsignedContent, buf);
        } else {
            buf.writeBoolean(false);
        }
        PlayerChat.writeVarInt(this.typeId, buf);
        PlayerChat.writeUUID(this.sender, buf);
        PlayerChat.writeString(this.displayName, buf);
        if (this.teamName != null) {
            buf.writeBoolean(true);
            PlayerChat.writeString(this.teamName, buf);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeLong(this.timestamp);
        buf.writeLong(this.salt);
        PlayerChat.writeArray(this.signature, buf);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public String getSignedContent() {
        return this.signedContent;
    }

    public String getUnsignedContent() {
        return this.unsignedContent;
    }

    public UUID getSender() {
        return this.sender;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getSalt() {
        return this.salt;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignedContent(String signedContent) {
        this.signedContent = signedContent;
    }

    public void setUnsignedContent(String unsignedContent) {
        this.unsignedContent = unsignedContent;
    }

    public void setSender(UUID sender) {
        this.sender = sender;
    }

    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setSalt(long salt) {
        this.salt = salt;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    @Override
    public String toString() {
        return "PlayerChat(signedContent=" + this.getSignedContent() + ", unsignedContent=" + this.getUnsignedContent() + ", sender=" + this.getSender() + ", typeId=" + this.getTypeId() + ", displayName=" + this.getDisplayName() + ", teamName=" + this.getTeamName() + ", timestamp=" + this.getTimestamp() + ", salt=" + this.getSalt() + ", signature=" + Arrays.toString(this.getSignature()) + ")";
    }

    public PlayerChat() {
    }

    public PlayerChat(String signedContent, String unsignedContent, UUID sender, int typeId, String displayName, String teamName, long timestamp, long salt, byte[] signature) {
        this.signedContent = signedContent;
        this.unsignedContent = unsignedContent;
        this.sender = sender;
        this.typeId = typeId;
        this.displayName = displayName;
        this.teamName = teamName;
        this.timestamp = timestamp;
        this.salt = salt;
        this.signature = signature;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerChat)) {
            return false;
        }
        PlayerChat other = (PlayerChat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTypeId() != other.getTypeId()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getSalt() != other.getSalt()) {
            return false;
        }
        String this$signedContent = this.getSignedContent();
        String other$signedContent = other.getSignedContent();
        if (this$signedContent == null ? other$signedContent != null : !this$signedContent.equals(other$signedContent)) {
            return false;
        }
        String this$unsignedContent = this.getUnsignedContent();
        String other$unsignedContent = other.getUnsignedContent();
        if (this$unsignedContent == null ? other$unsignedContent != null : !this$unsignedContent.equals(other$unsignedContent)) {
            return false;
        }
        UUID this$sender = this.getSender();
        UUID other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !((Object)this$sender).equals(other$sender)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$teamName = this.getTeamName();
        String other$teamName = other.getTeamName();
        if (this$teamName == null ? other$teamName != null : !this$teamName.equals(other$teamName)) {
            return false;
        }
        return Arrays.equals(this.getSignature(), other.getSignature());
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerChat;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTypeId();
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $salt = this.getSalt();
        result = result * 59 + (int)($salt >>> 32 ^ $salt);
        String $signedContent = this.getSignedContent();
        result = result * 59 + ($signedContent == null ? 43 : $signedContent.hashCode());
        String $unsignedContent = this.getUnsignedContent();
        result = result * 59 + ($unsignedContent == null ? 43 : $unsignedContent.hashCode());
        UUID $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : ((Object)$sender).hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $teamName = this.getTeamName();
        result = result * 59 + ($teamName == null ? 43 : $teamName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSignature());
        return result;
    }
}

