/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class Chat
extends DefinedPacket {
    private static final UUID EMPTY_UUID = new UUID(0L, 0L);
    private String message;
    private byte position;
    private UUID sender;

    public Chat(String message) {
        this(message, 0);
    }

    public Chat(String message, byte position) {
        this(message, position, EMPTY_UUID);
    }

    public Chat(String message, byte position, UUID sender) {
        this.message = message;
        this.position = position;
        this.sender = sender == null ? EMPTY_UUID : sender;
    }

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.message = Chat.readString(buf, direction == ProtocolConstants.Direction.TO_CLIENT ? 262144 : (protocolVersion >= 315 ? 256 : 100));
        if (direction == ProtocolConstants.Direction.TO_CLIENT) {
            this.position = buf.readByte();
            if (protocolVersion >= 735) {
                this.sender = Chat.readUUID(buf);
            }
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        Chat.writeString(this.message, buf);
        if (direction == ProtocolConstants.Direction.TO_CLIENT) {
            buf.writeByte(this.position);
            if (protocolVersion >= 735) {
                Chat.writeUUID(this.sender, buf);
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public String getMessage() {
        return this.message;
    }

    public byte getPosition() {
        return this.position;
    }

    public UUID getSender() {
        return this.sender;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setPosition(byte position) {
        this.position = position;
    }

    public void setSender(UUID sender) {
        this.sender = sender;
    }

    @Override
    public String toString() {
        return "Chat(message=" + this.getMessage() + ", position=" + this.getPosition() + ", sender=" + this.getSender() + ")";
    }

    public Chat() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Chat)) {
            return false;
        }
        Chat other = (Chat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPosition() != other.getPosition()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        UUID this$sender = this.getSender();
        UUID other$sender = other.getSender();
        return !(this$sender == null ? other$sender != null : !((Object)this$sender).equals(other$sender));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Chat;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPosition();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        UUID $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : ((Object)$sender).hashCode());
        return result;
    }
}

