/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import se.llbit.nbt.Tag;

public class Login
extends DefinedPacket {
    private int entityId;
    private boolean hardcore;
    private short gameMode;
    private short previousGameMode;
    private Set<String> worldNames;
    private Tag dimensions;
    private Object dimension;
    private String worldName;
    private long seed;
    private short difficulty;
    private int maxPlayers;
    private String levelType;
    private int viewDistance;
    private int simulationDistance;
    private boolean reducedDebugInfo;
    private boolean normalRespawn;
    private boolean debug;
    private boolean flat;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.entityId = buf.readInt();
        if (protocolVersion >= 751) {
            this.hardcore = buf.readBoolean();
        }
        this.gameMode = buf.readUnsignedByte();
        if (protocolVersion >= 735) {
            this.previousGameMode = buf.readUnsignedByte();
            this.worldNames = new HashSet<String>();
            int worldCount = Login.readVarInt(buf);
            for (int i = 0; i < worldCount; ++i) {
                this.worldNames.add(Login.readString(buf));
            }
            this.dimensions = Login.readTag(buf);
        }
        if (protocolVersion >= 735) {
            this.dimension = protocolVersion >= 751 ? Login.readTag(buf) : Login.readString(buf);
            this.worldName = Login.readString(buf);
        } else {
            this.dimension = protocolVersion > 107 ? Integer.valueOf(buf.readInt()) : Integer.valueOf(buf.readByte());
        }
        if (protocolVersion >= 573) {
            this.seed = buf.readLong();
        }
        if (protocolVersion < 477) {
            this.difficulty = buf.readUnsignedByte();
        }
        this.maxPlayers = protocolVersion >= 751 ? Login.readVarInt(buf) : (int)buf.readUnsignedByte();
        if (protocolVersion < 735) {
            this.levelType = Login.readString(buf);
        }
        if (protocolVersion >= 477) {
            this.viewDistance = Login.readVarInt(buf);
        }
        if (protocolVersion >= 1073741883) {
            this.simulationDistance = Login.readVarInt(buf);
        }
        if (protocolVersion >= 29) {
            this.reducedDebugInfo = buf.readBoolean();
        }
        if (protocolVersion >= 573) {
            this.normalRespawn = buf.readBoolean();
        }
        if (protocolVersion >= 735) {
            this.debug = buf.readBoolean();
            this.flat = buf.readBoolean();
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        buf.writeInt(this.entityId);
        if (protocolVersion >= 751) {
            buf.writeBoolean(this.hardcore);
        }
        buf.writeByte(this.gameMode);
        if (protocolVersion >= 735) {
            buf.writeByte(this.previousGameMode);
            Login.writeVarInt(this.worldNames.size(), buf);
            for (String world : this.worldNames) {
                Login.writeString(world, buf);
            }
            Login.writeTag(this.dimensions, buf);
        }
        if (protocolVersion >= 735) {
            if (protocolVersion >= 751) {
                Login.writeTag((Tag)this.dimension, buf);
            } else {
                Login.writeString((String)this.dimension, buf);
            }
            Login.writeString(this.worldName, buf);
        } else if (protocolVersion > 107) {
            buf.writeInt((Integer)this.dimension);
        } else {
            buf.writeByte((Integer)this.dimension);
        }
        if (protocolVersion >= 573) {
            buf.writeLong(this.seed);
        }
        if (protocolVersion < 477) {
            buf.writeByte(this.difficulty);
        }
        if (protocolVersion >= 751) {
            Login.writeVarInt(this.maxPlayers, buf);
        } else {
            buf.writeByte(this.maxPlayers);
        }
        if (protocolVersion < 735) {
            Login.writeString(this.levelType, buf);
        }
        if (protocolVersion >= 477) {
            Login.writeVarInt(this.viewDistance, buf);
        }
        if (protocolVersion >= 1073741883) {
            Login.writeVarInt(this.simulationDistance, buf);
        }
        if (protocolVersion >= 29) {
            buf.writeBoolean(this.reducedDebugInfo);
        }
        if (protocolVersion >= 573) {
            buf.writeBoolean(this.normalRespawn);
        }
        if (protocolVersion >= 735) {
            buf.writeBoolean(this.debug);
            buf.writeBoolean(this.flat);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public boolean isHardcore() {
        return this.hardcore;
    }

    public short getGameMode() {
        return this.gameMode;
    }

    public short getPreviousGameMode() {
        return this.previousGameMode;
    }

    public Set<String> getWorldNames() {
        return this.worldNames;
    }

    public Tag getDimensions() {
        return this.dimensions;
    }

    public Object getDimension() {
        return this.dimension;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public long getSeed() {
        return this.seed;
    }

    public short getDifficulty() {
        return this.difficulty;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public String getLevelType() {
        return this.levelType;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public int getSimulationDistance() {
        return this.simulationDistance;
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public boolean isNormalRespawn() {
        return this.normalRespawn;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void setHardcore(boolean hardcore) {
        this.hardcore = hardcore;
    }

    public void setGameMode(short gameMode) {
        this.gameMode = gameMode;
    }

    public void setPreviousGameMode(short previousGameMode) {
        this.previousGameMode = previousGameMode;
    }

    public void setWorldNames(Set<String> worldNames) {
        this.worldNames = worldNames;
    }

    public void setDimensions(Tag dimensions) {
        this.dimensions = dimensions;
    }

    public void setDimension(Object dimension) {
        this.dimension = dimension;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setDifficulty(short difficulty) {
        this.difficulty = difficulty;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public void setLevelType(String levelType) {
        this.levelType = levelType;
    }

    public void setViewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
    }

    public void setSimulationDistance(int simulationDistance) {
        this.simulationDistance = simulationDistance;
    }

    public void setReducedDebugInfo(boolean reducedDebugInfo) {
        this.reducedDebugInfo = reducedDebugInfo;
    }

    public void setNormalRespawn(boolean normalRespawn) {
        this.normalRespawn = normalRespawn;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setFlat(boolean flat) {
        this.flat = flat;
    }

    @Override
    public String toString() {
        return "Login(entityId=" + this.getEntityId() + ", hardcore=" + this.isHardcore() + ", gameMode=" + this.getGameMode() + ", previousGameMode=" + this.getPreviousGameMode() + ", worldNames=" + this.getWorldNames() + ", dimensions=" + this.getDimensions() + ", dimension=" + this.getDimension() + ", worldName=" + this.getWorldName() + ", seed=" + this.getSeed() + ", difficulty=" + this.getDifficulty() + ", maxPlayers=" + this.getMaxPlayers() + ", levelType=" + this.getLevelType() + ", viewDistance=" + this.getViewDistance() + ", simulationDistance=" + this.getSimulationDistance() + ", reducedDebugInfo=" + this.isReducedDebugInfo() + ", normalRespawn=" + this.isNormalRespawn() + ", debug=" + this.isDebug() + ", flat=" + this.isFlat() + ")";
    }

    public Login() {
    }

    public Login(int entityId, boolean hardcore, short gameMode, short previousGameMode, Set<String> worldNames, Tag dimensions, Object dimension, String worldName, long seed, short difficulty, int maxPlayers, String levelType, int viewDistance, int simulationDistance, boolean reducedDebugInfo, boolean normalRespawn, boolean debug, boolean flat) {
        this.entityId = entityId;
        this.hardcore = hardcore;
        this.gameMode = gameMode;
        this.previousGameMode = previousGameMode;
        this.worldNames = worldNames;
        this.dimensions = dimensions;
        this.dimension = dimension;
        this.worldName = worldName;
        this.seed = seed;
        this.difficulty = difficulty;
        this.maxPlayers = maxPlayers;
        this.levelType = levelType;
        this.viewDistance = viewDistance;
        this.simulationDistance = simulationDistance;
        this.reducedDebugInfo = reducedDebugInfo;
        this.normalRespawn = normalRespawn;
        this.debug = debug;
        this.flat = flat;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Login)) {
            return false;
        }
        Login other = (Login)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.isHardcore() != other.isHardcore()) {
            return false;
        }
        if (this.getGameMode() != other.getGameMode()) {
            return false;
        }
        if (this.getPreviousGameMode() != other.getPreviousGameMode()) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        if (this.getDifficulty() != other.getDifficulty()) {
            return false;
        }
        if (this.getMaxPlayers() != other.getMaxPlayers()) {
            return false;
        }
        if (this.getViewDistance() != other.getViewDistance()) {
            return false;
        }
        if (this.getSimulationDistance() != other.getSimulationDistance()) {
            return false;
        }
        if (this.isReducedDebugInfo() != other.isReducedDebugInfo()) {
            return false;
        }
        if (this.isNormalRespawn() != other.isNormalRespawn()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        if (this.isFlat() != other.isFlat()) {
            return false;
        }
        Set<String> this$worldNames = this.getWorldNames();
        Set<String> other$worldNames = other.getWorldNames();
        if (this$worldNames == null ? other$worldNames != null : !((Object)this$worldNames).equals(other$worldNames)) {
            return false;
        }
        Tag this$dimensions = this.getDimensions();
        Tag other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !this$dimensions.equals(other$dimensions)) {
            return false;
        }
        Object this$dimension = this.getDimension();
        Object other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        String this$worldName = this.getWorldName();
        String other$worldName = other.getWorldName();
        if (this$worldName == null ? other$worldName != null : !this$worldName.equals(other$worldName)) {
            return false;
        }
        String this$levelType = this.getLevelType();
        String other$levelType = other.getLevelType();
        return !(this$levelType == null ? other$levelType != null : !this$levelType.equals(other$levelType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Login;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + (this.isHardcore() ? 79 : 97);
        result = result * 59 + this.getGameMode();
        result = result * 59 + this.getPreviousGameMode();
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        result = result * 59 + this.getDifficulty();
        result = result * 59 + this.getMaxPlayers();
        result = result * 59 + this.getViewDistance();
        result = result * 59 + this.getSimulationDistance();
        result = result * 59 + (this.isReducedDebugInfo() ? 79 : 97);
        result = result * 59 + (this.isNormalRespawn() ? 79 : 97);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isFlat() ? 79 : 97);
        Set<String> $worldNames = this.getWorldNames();
        result = result * 59 + ($worldNames == null ? 43 : ((Object)$worldNames).hashCode());
        Tag $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : $dimensions.hashCode());
        Object $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        String $worldName = this.getWorldName();
        result = result * 59 + ($worldName == null ? 43 : $worldName.hashCode());
        String $levelType = this.getLevelType();
        result = result * 59 + ($levelType == null ? 43 : $levelType.hashCode());
        return result;
    }
}

