/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessControlException;
import java.security.Permission;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.scheduler.GroupedThreadFactory;

public class BungeeSecurityManager
extends SecurityManager {
    private static final boolean ENFORCE = false;
    private final Set<String> seen = new HashSet<String>();

    private void checkRestricted(String text) {
        block1: {
            ClassLoader loader;
            int i = 2;
            Class<?>[] context = this.getClassContext();
            if (i >= context.length || (loader = context[i].getClassLoader()) == ClassLoader.getSystemClassLoader() || loader == null) break block1;
            AccessControlException ex = new AccessControlException("Plugin violation: " + text);
            StringWriter stack = new StringWriter();
            ex.printStackTrace(new PrintWriter(stack));
            if (this.seen.add(stack.toString())) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "Plugin performed restricted action, please inform them to use proper API methods: " + text, ex);
            }
        }
    }

    @Override
    public void checkExit(int status) {
        this.checkRestricted("Exit: Cannot close VM");
    }

    @Override
    public void checkAccess(ThreadGroup g) {
        if (!(g instanceof GroupedThreadFactory.BungeeGroup)) {
            this.checkRestricted("Illegal thread group access");
        }
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
        this.checkPermission(perm);
    }

    @Override
    public void checkPermission(Permission perm) {
        switch (perm.getName()) {
            case "setSecurityManager": {
                throw new AccessControlException("Restricted Action", perm);
            }
        }
    }
}

