/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.connection;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.SettingsChangedEvent;
import net.md_5.bungee.api.event.TabCompleteEvent;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.entitymap.EntityMap;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.ClientSettings;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.TabCompleteRequest;
import net.md_5.bungee.protocol.packet.TabCompleteResponse;

public class UpstreamBridge
extends PacketHandler {
    private final ProxyServer bungee;
    private final UserConnection con;

    public UpstreamBridge(ProxyServer bungee, UserConnection con) {
        this.bungee = bungee;
        this.con = con;
        BungeeCord.getInstance().addConnection(con);
        con.getTabListHandler().onConnect();
        con.unsafe().sendPacket(BungeeCord.getInstance().registerChannels(con.getPendingConnection().getVersion()));
    }

    @Override
    public void exception(Throwable t) throws Exception {
        this.con.disconnect(Util.exception(t));
    }

    @Override
    public void disconnected(ChannelWrapper channel) throws Exception {
        PlayerDisconnectEvent event = new PlayerDisconnectEvent(this.con);
        this.bungee.getPluginManager().callEvent(event);
        this.con.getTabListHandler().onDisconnect();
        BungeeCord.getInstance().removeConnection(this.con);
        if (this.con.getServer() != null) {
            PlayerListItem packet = new PlayerListItem();
            packet.setAction(PlayerListItem.Action.REMOVE_PLAYER);
            PlayerListItem.Item item = new PlayerListItem.Item();
            item.setUuid(this.con.getUniqueId());
            packet.setItems(new PlayerListItem.Item[]{item});
            for (ProxiedPlayer player : this.con.getServer().getInfo().getPlayers()) {
                player.unsafe().sendPacket(packet);
            }
            this.con.getServer().disconnect("Quitting");
        }
    }

    @Override
    public void writabilityChanged(ChannelWrapper channel) throws Exception {
        if (this.con.getServer() != null) {
            Channel server = this.con.getServer().getCh().getHandle();
            if (channel.getHandle().isWritable()) {
                server.config().setAutoRead(true);
            } else {
                server.config().setAutoRead(false);
            }
        }
    }

    @Override
    public boolean shouldHandle(PacketWrapper packet) throws Exception {
        return this.con.getServer() != null || packet.packet instanceof PluginMessage;
    }

    @Override
    public void handle(PacketWrapper packet) throws Exception {
        if (this.con.getServer() != null) {
            EntityMap rewrite = this.con.getEntityRewrite();
            if (rewrite != null) {
                rewrite.rewriteServerbound(packet.buf, this.con.getClientEntityId(), this.con.getServerEntityId(), this.con.getPendingConnection().getVersion());
            }
            this.con.getServer().getCh().write(packet);
        }
    }

    @Override
    public void handle(KeepAlive alive) throws Exception {
        ServerConnection.KeepAliveData keepAliveData = this.con.getServer().getKeepAlives().peek();
        if (keepAliveData == null || alive.getRandomId() != keepAliveData.getId()) {
            throw CancelSendSignal.INSTANCE;
        }
        Preconditions.checkState(keepAliveData == this.con.getServer().getKeepAlives().poll(), "keepalive queue mismatch");
        int newPing = (int)(System.currentTimeMillis() - keepAliveData.getTime());
        this.con.getTabListHandler().onPingChange(newPing);
        this.con.setPing(newPing);
    }

    @Override
    public void handle(Chat chat) throws Exception {
        int length = chat.getMessage().length();
        for (int index = 0; index < length; ++index) {
            char c = chat.getMessage().charAt(index);
            if (c != '\u00a7' && c >= ' ' && c != '\u007f') continue;
            this.con.disconnect(this.bungee.getTranslation("illegal_chat_characters", String.format("\\u%04x", c)));
            throw CancelSendSignal.INSTANCE;
        }
        ChatEvent chatEvent = new ChatEvent(this.con, this.con.getServer(), chat.getMessage());
        if (!this.bungee.getPluginManager().callEvent(chatEvent).isCancelled()) {
            chat.setMessage(chatEvent.getMessage());
            if (!chatEvent.isCommand() || !this.bungee.getPluginManager().dispatchCommand(this.con, chat.getMessage().substring(1))) {
                this.con.getServer().unsafe().sendPacket(chat);
            }
        }
        throw CancelSendSignal.INSTANCE;
    }

    @Override
    public void handle(TabCompleteRequest tabComplete) throws Exception {
        ArrayList<String> suggestions = new ArrayList<String>();
        if (tabComplete.getCursor().startsWith("/")) {
            this.bungee.getPluginManager().dispatchCommand(this.con, tabComplete.getCursor().substring(1), suggestions);
        }
        TabCompleteEvent tabCompleteEvent = new TabCompleteEvent(this.con, this.con.getServer(), tabComplete.getCursor(), suggestions);
        this.bungee.getPluginManager().callEvent(tabCompleteEvent);
        if (tabCompleteEvent.isCancelled()) {
            throw CancelSendSignal.INSTANCE;
        }
        List<String> results = tabCompleteEvent.getSuggestions();
        if (!results.isEmpty()) {
            if (this.con.getPendingConnection().getVersion() < 393) {
                this.con.unsafe().sendPacket(new TabCompleteResponse(results));
            } else {
                int start = tabComplete.getCursor().lastIndexOf(32) + 1;
                int end = tabComplete.getCursor().length();
                StringRange range = StringRange.between(start, end);
                LinkedList<Suggestion> brigadier = new LinkedList<Suggestion>();
                for (String s : results) {
                    brigadier.add(new Suggestion(range, s));
                }
                this.con.unsafe().sendPacket(new TabCompleteResponse(tabComplete.getTransactionId(), new Suggestions(range, brigadier)));
            }
            throw CancelSendSignal.INSTANCE;
        }
    }

    @Override
    public void handle(ClientSettings settings) throws Exception {
        this.con.setSettings(settings);
        SettingsChangedEvent settingsEvent = new SettingsChangedEvent(this.con);
        this.bungee.getPluginManager().callEvent(settingsEvent);
    }

    @Override
    public void handle(PluginMessage pluginMessage) throws Exception {
        if (pluginMessage.getTag().equals("BungeeCord")) {
            throw CancelSendSignal.INSTANCE;
        }
        if (BungeeCord.getInstance().config.isForgeSupport()) {
            if (pluginMessage.getTag().equals("FML") && pluginMessage.getStream().readUnsignedByte() == 1) {
                throw CancelSendSignal.INSTANCE;
            }
            if (pluginMessage.getTag().equals("FML|HS")) {
                this.con.getForgeClientHandler().handle(pluginMessage);
                throw CancelSendSignal.INSTANCE;
            }
            if (this.con.getServer() != null && !this.con.getServer().isForgeServer() && pluginMessage.getData().length > Short.MAX_VALUE) {
                throw CancelSendSignal.INSTANCE;
            }
        }
        PluginMessageEvent event = new PluginMessageEvent(this.con, this.con.getServer(), pluginMessage.getTag(), (byte[])pluginMessage.getData().clone());
        if (this.bungee.getPluginManager().callEvent(event).isCancelled()) {
            throw CancelSendSignal.INSTANCE;
        }
        if (PluginMessage.SHOULD_RELAY.apply(pluginMessage)) {
            this.con.getPendingConnection().getRelayMessages().add(pluginMessage);
        }
    }

    @Override
    public String toString() {
        return "[" + this.con.getName() + "] -> UpstreamBridge";
    }
}

