/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Locale;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class ScoreboardObjective
extends DefinedPacket {
    private String name;
    private String value;
    private HealthDisplay type;
    private byte action;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.name = ScoreboardObjective.readString(buf);
        this.action = buf.readByte();
        if (this.action == 0 || this.action == 2) {
            this.value = ScoreboardObjective.readString(buf);
            this.type = protocolVersion >= 393 ? HealthDisplay.values()[ScoreboardObjective.readVarInt(buf)] : HealthDisplay.fromString(ScoreboardObjective.readString(buf));
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        ScoreboardObjective.writeString(this.name, buf);
        buf.writeByte(this.action);
        if (this.action == 0 || this.action == 2) {
            ScoreboardObjective.writeString(this.value, buf);
            if (protocolVersion >= 393) {
                ScoreboardObjective.writeVarInt(this.type.ordinal(), buf);
            } else {
                ScoreboardObjective.writeString(this.type.toString(), buf);
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public HealthDisplay getType() {
        return this.type;
    }

    public byte getAction() {
        return this.action;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setType(HealthDisplay type) {
        this.type = type;
    }

    public void setAction(byte action) {
        this.action = action;
    }

    @Override
    public String toString() {
        return "ScoreboardObjective(name=" + this.getName() + ", value=" + this.getValue() + ", type=" + (Object)((Object)this.getType()) + ", action=" + this.getAction() + ")";
    }

    public ScoreboardObjective() {
    }

    public ScoreboardObjective(String name, String value, HealthDisplay type, byte action) {
        this.name = name;
        this.value = value;
        this.type = type;
        this.action = action;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScoreboardObjective)) {
            return false;
        }
        ScoreboardObjective other = (ScoreboardObjective)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getAction() != other.getAction()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        HealthDisplay this$type = this.getType();
        HealthDisplay other$type = other.getType();
        return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScoreboardObjective;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAction();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        HealthDisplay $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        return result;
    }

    public static enum HealthDisplay {
        INTEGER,
        HEARTS;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public static HealthDisplay fromString(String s) {
            return HealthDisplay.valueOf(s.toUpperCase(Locale.ROOT));
        }
    }
}

