/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.chat;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;

public final class ItemTag {
    private BaseComponent name;
    private List<Enchantment> enchantments = new ArrayList<Enchantment>();
    private List<BaseComponent[]> lore = new ArrayList<BaseComponent[]>();
    private Boolean unbreakable;

    private ItemTag() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ItemTag(super=" + super.toString() + ", name=" + this.name + ", enchantments=" + this.enchantments + ", lore=" + this.lore + ", unbreakable=" + this.unbreakable + ")";
    }

    public void setName(BaseComponent name) {
        this.name = name;
    }

    public void setEnchantments(List<Enchantment> enchantments) {
        this.enchantments = enchantments;
    }

    public void setLore(List<BaseComponent[]> lore) {
        this.lore = lore;
    }

    public void setUnbreakable(Boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    public ItemTag(BaseComponent name, List<Enchantment> enchantments, List<BaseComponent[]> lore, Boolean unbreakable) {
        this.name = name;
        this.enchantments = enchantments;
        this.lore = lore;
        this.unbreakable = unbreakable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemTag)) {
            return false;
        }
        ItemTag other = (ItemTag)o;
        BaseComponent this$name = this.name;
        BaseComponent other$name = other.name;
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        List<Enchantment> this$enchantments = this.enchantments;
        List<Enchantment> other$enchantments = other.enchantments;
        if (this$enchantments == null ? other$enchantments != null : !((Object)this$enchantments).equals(other$enchantments)) {
            return false;
        }
        List<BaseComponent[]> this$lore = this.lore;
        List<BaseComponent[]> other$lore = other.lore;
        if (this$lore == null ? other$lore != null : !((Object)this$lore).equals(other$lore)) {
            return false;
        }
        Boolean this$unbreakable = this.unbreakable;
        Boolean other$unbreakable = other.unbreakable;
        return !(this$unbreakable == null ? other$unbreakable != null : !((Object)this$unbreakable).equals(other$unbreakable));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BaseComponent $name = this.name;
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        List<Enchantment> $enchantments = this.enchantments;
        result = result * 59 + ($enchantments == null ? 43 : ((Object)$enchantments).hashCode());
        List<BaseComponent[]> $lore = this.lore;
        result = result * 59 + ($lore == null ? 43 : ((Object)$lore).hashCode());
        Boolean $unbreakable = this.unbreakable;
        result = result * 59 + ($unbreakable == null ? 43 : ((Object)$unbreakable).hashCode());
        return result;
    }

    public static class Builder {
        private BaseComponent name;
        private ArrayList<Enchantment> enchantments;
        private ArrayList<BaseComponent[]> lore;
        private Boolean unbreakable;

        Builder() {
        }

        public Builder name(BaseComponent name) {
            this.name = name;
            return this;
        }

        public Builder ench(Enchantment ench) {
            if (this.enchantments == null) {
                this.enchantments = new ArrayList();
            }
            this.enchantments.add(ench);
            return this;
        }

        public Builder enchantments(Collection<? extends Enchantment> enchantments) {
            if (this.enchantments == null) {
                this.enchantments = new ArrayList();
            }
            this.enchantments.addAll(enchantments);
            return this;
        }

        public Builder clearEnchantments() {
            if (this.enchantments != null) {
                this.enchantments.clear();
            }
            return this;
        }

        public Builder lore(BaseComponent[] lore) {
            if (this.lore == null) {
                this.lore = new ArrayList();
            }
            this.lore.add(lore);
            return this;
        }

        public Builder lore(Collection<? extends BaseComponent[]> lore) {
            if (this.lore == null) {
                this.lore = new ArrayList();
            }
            this.lore.addAll(lore);
            return this;
        }

        public Builder clearLore() {
            if (this.lore != null) {
                this.lore.clear();
            }
            return this;
        }

        public Builder unbreakable(Boolean unbreakable) {
            this.unbreakable = unbreakable;
            return this;
        }

        public ItemTag build() {
            List<BaseComponent[]> lore;
            List<Enchantment> enchantments;
            switch (this.enchantments == null ? 0 : this.enchantments.size()) {
                case 0: {
                    enchantments = Collections.emptyList();
                    break;
                }
                case 1: {
                    enchantments = Collections.singletonList(this.enchantments.get(0));
                    break;
                }
                default: {
                    enchantments = Collections.unmodifiableList(new ArrayList<Enchantment>(this.enchantments));
                }
            }
            switch (this.lore == null ? 0 : this.lore.size()) {
                case 0: {
                    lore = Collections.emptyList();
                    break;
                }
                case 1: {
                    lore = Collections.singletonList(this.lore.get(0));
                    break;
                }
                default: {
                    lore = Collections.unmodifiableList(new ArrayList<BaseComponent[]>(this.lore));
                }
            }
            return new ItemTag(this.name, enchantments, lore, this.unbreakable);
        }

        public String toString() {
            return "ItemTag.Builder(name=" + this.name + ", enchantments=" + this.enchantments + ", lore=" + this.lore + ", unbreakable=" + this.unbreakable + ")";
        }
    }

    public static class Serializer
    implements JsonSerializer<ItemTag>,
    JsonDeserializer<ItemTag> {
        @Override
        public ItemTag deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            ItemTag itemTag = new ItemTag();
            JsonObject object = element.getAsJsonObject();
            if (object.has("ench")) {
                for (JsonElement jsonElement : object.get("ench").getAsJsonArray()) {
                    JsonObject next = jsonElement.getAsJsonObject();
                    itemTag.enchantments.add(new Enchantment(next.get("id").getAsInt(), next.get("lvl").getAsInt()));
                }
            }
            if (object.has("Unbreakable")) {
                int status = object.get("Unbreakable").getAsInt();
                if (status == 1) {
                    itemTag.unbreakable = true;
                } else if (status == 0) {
                    itemTag.unbreakable = false;
                }
            }
            if (object.has("display")) {
                JsonObject display = object.get("display").getAsJsonObject();
                if (display.has("Name")) {
                    itemTag.name = (BaseComponent)context.deserialize(display.get("Name").getAsJsonObject(), (Type)((Object)BaseComponent.class));
                }
                if (display.has("Lore")) {
                    JsonElement lore = display.get("Lore");
                    if (lore.isJsonArray()) {
                        for (JsonElement loreIt : lore.getAsJsonArray()) {
                            if (loreIt.isJsonArray()) {
                                itemTag.lore.add(context.deserialize(loreIt, (Type)((Object)BaseComponent[].class)));
                                continue;
                            }
                            itemTag.lore.add(new BaseComponent[]{(BaseComponent)context.deserialize(loreIt, (Type)((Object)BaseComponent.class))});
                        }
                    } else {
                        itemTag.lore.add(context.deserialize(display.get("Lore"), (Type)((Object)BaseComponent[].class)));
                    }
                }
            }
            return itemTag;
        }

        @Override
        public JsonElement serialize(ItemTag itemTag, Type type, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            if (!itemTag.enchantments.isEmpty()) {
                JsonArray enchArray = new JsonArray();
                for (Enchantment ench : itemTag.enchantments) {
                    JsonObject enchObj = new JsonObject();
                    enchObj.addProperty("id", ench.id);
                    enchObj.addProperty("lvl", ench.level);
                    enchArray.add(enchObj);
                }
                object.add("ench", enchArray);
            }
            if (itemTag.unbreakable != null) {
                object.addProperty("Unbreakable", itemTag.unbreakable != false ? 1 : 0);
            }
            JsonObject display = new JsonObject();
            if (itemTag.name != null) {
                display.add("Name", context.serialize(itemTag.name));
            }
            if (!itemTag.lore.isEmpty()) {
                display.add("Lore", context.serialize(itemTag.lore));
            }
            if (display.size() != 0) {
                object.add("display", display);
            }
            return object;
        }
    }

    public static class Enchantment {
        private final int level;
        private final int id;

        public Enchantment(int level, int id) {
            this.level = level;
            this.id = id;
        }
    }
}

