/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.chat;

import com.google.common.base.Preconditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ItemTag;

public final class HoverEvent {
    private final Action action;
    private final List<Content> contents;
    private boolean legacy = false;

    public HoverEvent(Action action, Content ... contents) {
        Preconditions.checkArgument(contents.length != 0, "Must contain at least one content");
        this.action = action;
        this.contents = new ArrayList<Content>();
        for (Content it : contents) {
            this.addContent(it);
        }
    }

    @Deprecated
    public HoverEvent(Action action, BaseComponent[] value) {
        this.action = action;
        this.contents = new ArrayList<ContentText>(Collections.singletonList(new ContentText(value)));
        this.legacy = true;
    }

    public void addContent(Content content) throws UnsupportedOperationException {
        Preconditions.checkArgument(!this.legacy || this.contents.size() == 0, "Legacy HoverEvent may not have more than one content");
        content.assertAction(this.action);
        this.contents.add(content);
    }

    public static Class<?> getClass(Action action, boolean array) {
        Preconditions.checkArgument(action != null, "action");
        switch (action) {
            case SHOW_TEXT: {
                return array ? ContentText[].class : ContentText.class;
            }
            case SHOW_ENTITY: {
                return array ? ContentEntity[].class : ContentEntity.class;
            }
            case SHOW_ITEM: {
                return array ? ContentItem[].class : ContentItem.class;
            }
        }
        throw new UnsupportedOperationException("Action '" + action.name() + " not supported");
    }

    public Action getAction() {
        return this.action;
    }

    public List<Content> getContents() {
        return this.contents;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public String toString() {
        return "HoverEvent(action=" + (Object)((Object)this.getAction()) + ", contents=" + this.getContents() + ", legacy=" + this.isLegacy() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HoverEvent)) {
            return false;
        }
        HoverEvent other = (HoverEvent)o;
        Action this$action = this.getAction();
        Action other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        List<Content> this$contents = this.getContents();
        List<Content> other$contents = other.getContents();
        if (this$contents == null ? other$contents != null : !((Object)this$contents).equals(other$contents)) {
            return false;
        }
        return this.isLegacy() == other.isLegacy();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Action $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        List<Content> $contents = this.getContents();
        result = result * 59 + ($contents == null ? 43 : ((Object)$contents).hashCode());
        result = result * 59 + (this.isLegacy() ? 79 : 97);
        return result;
    }

    public HoverEvent(Action action, List<Content> contents) {
        this.action = action;
        this.contents = contents;
    }

    public void setLegacy(boolean legacy) {
        this.legacy = legacy;
    }

    public static enum Action {
        SHOW_TEXT,
        SHOW_ITEM,
        SHOW_ENTITY,
        SHOW_ACHIEVEMENT;

    }

    public static class ContentItem
    extends Content {
        private String id;
        private int count = -1;
        private ItemTag tag;

        @Override
        Action requiredAction() {
            return Action.SHOW_ITEM;
        }

        public String getId() {
            return this.id;
        }

        public int getCount() {
            return this.count;
        }

        public ItemTag getTag() {
            return this.tag;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void setTag(ItemTag tag) {
            this.tag = tag;
        }

        public ContentItem() {
        }

        public ContentItem(String id, int count, ItemTag tag) {
            this.id = id;
            this.count = count;
            this.tag = tag;
        }

        @Override
        public String toString() {
            return "HoverEvent.ContentItem(id=" + this.getId() + ", count=" + this.getCount() + ", tag=" + this.getTag() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContentItem)) {
                return false;
            }
            ContentItem other = (ContentItem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            if (this.getCount() != other.getCount()) {
                return false;
            }
            ItemTag this$tag = this.getTag();
            ItemTag other$tag = other.getTag();
            return !(this$tag == null ? other$tag != null : !((Object)this$tag).equals(other$tag));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ContentItem;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            result = result * 59 + this.getCount();
            ItemTag $tag = this.getTag();
            result = result * 59 + ($tag == null ? 43 : ((Object)$tag).hashCode());
            return result;
        }

        public static class Serializer
        implements JsonSerializer<ContentItem>,
        JsonDeserializer<ContentItem> {
            @Override
            public ContentItem deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
                JsonObject value = element.getAsJsonObject();
                return new ContentItem(value.has("id") ? value.get("id").getAsString() : null, value.has("Count") ? value.get("Count").getAsInt() : -1, value.has("tag") ? (ItemTag)context.deserialize(value.get("tag"), (Type)((Object)ItemTag.class)) : null);
            }

            @Override
            public JsonElement serialize(ContentItem content, Type type, JsonSerializationContext context) {
                JsonObject object = new JsonObject();
                object.addProperty("id", content.getId() == null ? "minecraft:air" : content.getId());
                if (content.getCount() != -1) {
                    object.addProperty("Count", content.getCount());
                }
                if (content.getTag() != null) {
                    object.add("tag", context.serialize(content.getTag()));
                }
                return object;
            }
        }
    }

    public static class ContentEntity
    extends Content {
        private String type;
        @NonNull
        private String id;
        private BaseComponent name;

        @Override
        Action requiredAction() {
            return Action.SHOW_ENTITY;
        }

        public String getType() {
            return this.type;
        }

        @NonNull
        public String getId() {
            return this.id;
        }

        public BaseComponent getName() {
            return this.name;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setId(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
        }

        public void setName(BaseComponent name) {
            this.name = name;
        }

        public ContentEntity() {
        }

        public ContentEntity(String type, @NonNull String id, BaseComponent name) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.type = type;
            this.id = id;
            this.name = name;
        }

        @Override
        public String toString() {
            return "HoverEvent.ContentEntity(type=" + this.getType() + ", id=" + this.getId() + ", name=" + this.getName() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContentEntity)) {
                return false;
            }
            ContentEntity other = (ContentEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            BaseComponent this$name = this.getName();
            BaseComponent other$name = other.getName();
            return !(this$name == null ? other$name != null : !((Object)this$name).equals(other$name));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof ContentEntity;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            BaseComponent $name = this.getName();
            result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
            return result;
        }

        public static class Serializer
        implements JsonSerializer<ContentEntity>,
        JsonDeserializer<ContentEntity> {
            @Override
            public ContentEntity deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
                JsonObject value = element.getAsJsonObject();
                return new ContentEntity(value.has("type") ? value.get("type").getAsString() : null, value.get("id").getAsString(), value.has("name") ? (BaseComponent)context.deserialize(value.get("name"), (Type)((Object)BaseComponent.class)) : null);
            }

            @Override
            public JsonElement serialize(ContentEntity content, Type type, JsonSerializationContext context) {
                JsonObject object = new JsonObject();
                object.addProperty("type", content.getType() != null ? content.getType() : "minecraft:pig");
                object.addProperty("id", content.getId());
                if (content.getName() != null) {
                    object.add("name", context.serialize(content.getName()));
                }
                return object;
            }
        }
    }

    public static class ContentText
    extends Content {
        private Object value;

        public ContentText(BaseComponent[] value) {
            this.value = value;
        }

        public ContentText(String value) {
            this.value = value;
        }

        @Override
        Action requiredAction() {
            return Action.SHOW_TEXT;
        }

        @Override
        public boolean equals(Object o) {
            if (this.value instanceof BaseComponent[]) {
                return o instanceof ContentText && ((ContentText)o).value instanceof BaseComponent[] && Arrays.equals((BaseComponent[])this.value, (BaseComponent[])((ContentText)o).value);
            }
            return this.value.equals(o);
        }

        @Override
        public int hashCode() {
            return this.value instanceof BaseComponent[] ? Arrays.hashCode((BaseComponent[])this.value) : this.value.hashCode();
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return "HoverEvent.ContentText(value=" + this.getValue() + ")";
        }

        public static class Serializer
        implements JsonSerializer<ContentText>,
        JsonDeserializer<ContentText> {
            @Override
            public ContentText deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
                if (element.isJsonArray()) {
                    return new ContentText((BaseComponent[])context.deserialize(element, (Type)((Object)BaseComponent[].class)));
                }
                if (element.getAsJsonObject().isJsonPrimitive()) {
                    return new ContentText(element.getAsJsonObject().getAsJsonPrimitive().getAsString());
                }
                return new ContentText(new BaseComponent[]{(BaseComponent)context.deserialize(element, (Type)((Object)BaseComponent.class))});
            }

            @Override
            public JsonElement serialize(ContentText content, Type type, JsonSerializationContext context) {
                return context.serialize(content.getValue());
            }
        }
    }

    public static abstract class Content {
        abstract Action requiredAction();

        void assertAction(Action input) throws UnsupportedOperationException {
            if (input != this.requiredAction()) {
                throw new UnsupportedOperationException("Action " + (Object)((Object)input) + " not compatible! Expected " + (Object)((Object)this.requiredAction()));
            }
        }

        public String toString() {
            return "HoverEvent.Content()";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Content)) {
                return false;
            }
            Content other = (Content)o;
            return other.canEqual(this);
        }

        protected boolean canEqual(Object other) {
            return other instanceof Content;
        }

        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }
}

