/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.Random;
import net.minecraft.server.Block;
import net.minecraft.server.CreativeModeTab;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityTNTPrimed;
import net.minecraft.server.Item;
import net.minecraft.server.ItemStack;
import net.minecraft.server.Material;
import net.minecraft.server.World;

public class BlockTNT
extends Block {
    public BlockTNT(int n, int n2) {
        super(n, n2, Material.TNT);
        this.a(CreativeModeTab.d);
    }

    public int a(int n) {
        if (n == 0) {
            return this.textureId + 2;
        }
        if (n == 1) {
            return this.textureId + 1;
        }
        return this.textureId;
    }

    public void onPlace(World world, int n, int n2, int n3) {
        super.onPlace(world, n, n2, n3);
        if (world.isBlockIndirectlyPowered(n, n2, n3)) {
            this.postBreak(world, n, n2, n3, 1);
            world.setTypeId(n, n2, n3, 0);
        }
    }

    public void doPhysics(World world, int n, int n2, int n3, int n4) {
        if (n4 > 0 && Block.byId[n4].isPowerSource() && world.isBlockIndirectlyPowered(n, n2, n3)) {
            this.postBreak(world, n, n2, n3, 1);
            world.setTypeId(n, n2, n3, 0);
        }
    }

    public int a(Random random) {
        return 1;
    }

    public void wasExploded(World world, int n, int n2, int n3) {
        if (world.isStatic) {
            return;
        }
        EntityTNTPrimed entityTNTPrimed = new EntityTNTPrimed(world, (float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f);
        entityTNTPrimed.fuseTicks = world.random.nextInt(entityTNTPrimed.fuseTicks / 4) + entityTNTPrimed.fuseTicks / 8;
        world.addEntity(entityTNTPrimed);
    }

    public void postBreak(World world, int n, int n2, int n3, int n4) {
        if (world.isStatic) {
            return;
        }
        if ((n4 & 1) == 1) {
            EntityTNTPrimed entityTNTPrimed = new EntityTNTPrimed(world, (float)n + 0.5f, (float)n2 + 0.5f, (float)n3 + 0.5f);
            world.addEntity(entityTNTPrimed);
            world.makeSound(entityTNTPrimed, "random.fuse", 1.0f, 1.0f);
        }
    }

    public boolean interact(World world, int n, int n2, int n3, EntityHuman entityHuman, int n4, float f, float f2, float f3) {
        if (entityHuman.bC() != null && entityHuman.bC().id == Item.FLINT_AND_STEEL.id) {
            this.postBreak(world, n, n2, n3, 1);
            world.setTypeId(n, n2, n3, 0);
            return true;
        }
        return super.interact(world, n, n2, n3, entityHuman, n4, f, f2, f3);
    }

    protected ItemStack c_(int n) {
        return null;
    }
}

