/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import net.minecraft.server.DedicatedServer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerConfigurationManagerAbstract;

public class ServerConfigurationManager
extends ServerConfigurationManagerAbstract {
    private File e;
    private File f;

    public ServerConfigurationManager(DedicatedServer dedicatedServer) {
        super(dedicatedServer);
        this.e = dedicatedServer.f("ops.txt");
        this.f = dedicatedServer.f("white-list.txt");
        this.d = dedicatedServer.a("view-distance", 10);
        this.maxPlayers = dedicatedServer.a("max-players", 20);
        this.setHasWhitelist(dedicatedServer.a("white-list", false));
        if (!dedicatedServer.H()) {
            this.getNameBans().setEnabled(true);
            this.getIPBans().setEnabled(true);
        }
        this.getNameBans().load();
        this.getNameBans().save();
        this.getIPBans().load();
        this.getIPBans().save();
        this.t();
        this.v();
        this.u();
        this.w();
    }

    public void setHasWhitelist(boolean bl) {
        super.setHasWhitelist(bl);
        this.getServer().a("white-list", (Object)bl);
        this.getServer().a();
    }

    public void addOp(String string) {
        super.addOp(string);
        this.u();
    }

    public void removeOp(String string) {
        super.removeOp(string);
        this.u();
    }

    public void removeWhitelist(String string) {
        super.removeWhitelist(string);
        this.w();
    }

    public void addWhitelist(String string) {
        super.addWhitelist(string);
        this.w();
    }

    public void reloadWhitelist() {
        this.v();
    }

    private void t() {
        try {
            this.getOPs().clear();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.e));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                this.getOPs().add(string.trim().toLowerCase());
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            a.warning("Failed to load operators list: " + exception);
        }
    }

    private void u() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.e, false));
            for (String string : this.getOPs()) {
                printWriter.println(string);
            }
            printWriter.close();
        }
        catch (Exception exception) {
            a.warning("Failed to save operators list: " + exception);
        }
    }

    private void v() {
        try {
            this.getWhitelisted().clear();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.f));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                this.getWhitelisted().add(string.trim().toLowerCase());
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            a.warning("Failed to load white-list: " + exception);
        }
    }

    private void w() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.f, false));
            for (String string : this.getWhitelisted()) {
                printWriter.println(string);
            }
            printWriter.close();
        }
        catch (Exception exception) {
            a.warning("Failed to save white-list: " + exception);
        }
    }

    public boolean isWhitelisted(String string) {
        string = string.trim().toLowerCase();
        return !this.getHasWhitelist() || this.isOp(string) || this.getWhitelisted().contains(string);
    }

    public DedicatedServer getServer() {
        return (DedicatedServer)super.getServer();
    }

    public /* synthetic */ MinecraftServer getServer() {
        return this.getServer();
    }
}

