/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityBoat;
import net.minecraft.server.EntityEgg;
import net.minecraft.server.EntityEnderCrystal;
import net.minecraft.server.EntityEnderDragon;
import net.minecraft.server.EntityEnderPearl;
import net.minecraft.server.EntityEnderSignal;
import net.minecraft.server.EntityExperienceOrb;
import net.minecraft.server.EntityFallingBlock;
import net.minecraft.server.EntityFireball;
import net.minecraft.server.EntityFishingHook;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityMinecart;
import net.minecraft.server.EntityPainting;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.EntityPotion;
import net.minecraft.server.EntitySmallFireball;
import net.minecraft.server.EntitySnowball;
import net.minecraft.server.EntitySquid;
import net.minecraft.server.EntityTNTPrimed;
import net.minecraft.server.EntityThrownExpBottle;
import net.minecraft.server.EntityTrackerEntry;
import net.minecraft.server.IAnimal;
import net.minecraft.server.IntHashMap;
import net.minecraft.server.Packet;
import net.minecraft.server.WorldServer;

public class EntityTracker {
    private final WorldServer world;
    private Set b = new HashSet();
    private IntHashMap trackedEntities = new IntHashMap();
    private int d;

    public EntityTracker(WorldServer worldServer) {
        this.world = worldServer;
        this.d = worldServer.getMinecraftServer().getServerConfigurationManager().a();
    }

    public void track(Entity entity) {
        if (entity instanceof EntityPlayer) {
            this.addEntity(entity, 512, 2);
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            for (EntityTrackerEntry entityTrackerEntry : this.b) {
                if (entityTrackerEntry.tracker == entityPlayer) continue;
                entityTrackerEntry.updatePlayer(entityPlayer);
            }
        } else if (entity instanceof EntityFishingHook) {
            this.addEntity(entity, 64, 5, true);
        } else if (entity instanceof EntityArrow) {
            this.addEntity(entity, 64, 20, false);
        } else if (entity instanceof EntitySmallFireball) {
            this.addEntity(entity, 64, 10, false);
        } else if (entity instanceof EntityFireball) {
            this.addEntity(entity, 64, 10, false);
        } else if (entity instanceof EntitySnowball) {
            this.addEntity(entity, 64, 10, true);
        } else if (entity instanceof EntityEnderPearl) {
            this.addEntity(entity, 64, 10, true);
        } else if (entity instanceof EntityEnderSignal) {
            this.addEntity(entity, 64, 4, true);
        } else if (entity instanceof EntityEgg) {
            this.addEntity(entity, 64, 10, true);
        } else if (entity instanceof EntityPotion) {
            this.addEntity(entity, 64, 10, true);
        } else if (entity instanceof EntityThrownExpBottle) {
            this.addEntity(entity, 64, 10, true);
        } else if (entity instanceof EntityItem) {
            this.addEntity(entity, 64, 20, true);
        } else if (entity instanceof EntityMinecart) {
            this.addEntity(entity, 80, 3, true);
        } else if (entity instanceof EntityBoat) {
            this.addEntity(entity, 80, 3, true);
        } else if (entity instanceof EntitySquid) {
            this.addEntity(entity, 64, 3, true);
        } else if (entity instanceof IAnimal) {
            this.addEntity(entity, 80, 3, true);
        } else if (entity instanceof EntityEnderDragon) {
            this.addEntity(entity, 160, 3, true);
        } else if (entity instanceof EntityTNTPrimed) {
            this.addEntity(entity, 160, 10, true);
        } else if (entity instanceof EntityFallingBlock) {
            this.addEntity(entity, 160, 20, true);
        } else if (entity instanceof EntityPainting) {
            this.addEntity(entity, 160, Integer.MAX_VALUE, false);
        } else if (entity instanceof EntityExperienceOrb) {
            this.addEntity(entity, 160, 20, true);
        } else if (entity instanceof EntityEnderCrystal) {
            this.addEntity(entity, 256, Integer.MAX_VALUE, false);
        }
    }

    public void addEntity(Entity entity, int n, int n2) {
        this.addEntity(entity, n, n2, false);
    }

    public void addEntity(Entity entity, int n, int n2, boolean bl) {
        if (n > this.d) {
            n = this.d;
        }
        if (this.trackedEntities.b(entity.id)) {
            throw new IllegalStateException("Entity is already tracked!");
        }
        EntityTrackerEntry entityTrackerEntry = new EntityTrackerEntry(entity, n, n2, bl);
        this.b.add(entityTrackerEntry);
        this.trackedEntities.a(entity.id, entityTrackerEntry);
        entityTrackerEntry.scanPlayers(this.world.players);
    }

    public void untrackEntity(Entity entity) {
        Object object;
        if (entity instanceof EntityPlayer) {
            object = (EntityPlayer)entity;
            for (EntityTrackerEntry entityTrackerEntry : this.b) {
                entityTrackerEntry.a((EntityPlayer)object);
            }
        }
        if ((object = (EntityTrackerEntry)this.trackedEntities.d(entity.id)) != null) {
            this.b.remove(object);
            ((EntityTrackerEntry)object).a();
        }
    }

    public void updatePlayers() {
        ArrayList<EntityPlayer> arrayList = new ArrayList<EntityPlayer>();
        for (Object object : this.b) {
            ((EntityTrackerEntry)object).track(this.world.players);
            if (!((EntityTrackerEntry)object).n || !(((EntityTrackerEntry)object).tracker instanceof EntityPlayer)) continue;
            arrayList.add((EntityPlayer)((EntityTrackerEntry)object).tracker);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2 = object = (EntityPlayer)iterator.next();
            for (EntityTrackerEntry entityTrackerEntry : this.b) {
                if (entityTrackerEntry.tracker == object2) continue;
                entityTrackerEntry.updatePlayer((EntityPlayer)object2);
            }
        }
    }

    public void a(Entity entity, Packet packet) {
        EntityTrackerEntry entityTrackerEntry = (EntityTrackerEntry)this.trackedEntities.get(entity.id);
        if (entityTrackerEntry != null) {
            entityTrackerEntry.broadcast(packet);
        }
    }

    public void sendPacketToEntity(Entity entity, Packet packet) {
        EntityTrackerEntry entityTrackerEntry = (EntityTrackerEntry)this.trackedEntities.get(entity.id);
        if (entityTrackerEntry != null) {
            entityTrackerEntry.broadcastIncludingSelf(packet);
        }
    }

    public void untrackPlayer(EntityPlayer entityPlayer) {
        for (EntityTrackerEntry entityTrackerEntry : this.b) {
            entityTrackerEntry.clear(entityPlayer);
        }
    }
}

